#include "stdlib.h"
#include "alloc.h"
#include "largearr.h"


/* Format of macro


---

	#define <variable>(x) *((<variable type> *)pointer_add(<pointer to
			first memory location>,x))

---
Note memory must be declared later on in the program
*/

#define data_char(x) *((char *)pointer_add(DATA_CHAR,x))
#define data_int(x) *((int *)pointer_add(DATA_INT,x<<1))
#define data_long(x) *((long *)pointer_add(DATA_LONG,x<<2))

#define square(x,y) *((char *)pointer_add(SQUARE,(x<<8)+y))

void main()
{
	long i,j;
	void *DATA_CHAR,*DATA_INT,*DATA_LONG,*SQUARE;
	DATA_CHAR=char_array(80000);
	DATA_INT=int_array(40000);
	DATA_LONG=long_array(20000);
	SQUARE=char_array(256L*256L);

	printf ("Memory still available %ld\n",coreleft());
	printf ("Press a key to check arrays\n");
	getch();
	start_timer();
	printf ("Filling char array\n");
	for (i=0;i<80000;i++)
		data_char(i)=(char)i;
	printf ("Filling int array\n");
	for (i=0;i<40000;i++)
		data_int(i)=(int)i;
	printf ("Filling long array\n");
	for (i=0;i<20000;i++)
		data_long(i)=i;
	printf ("Filling square array\n");
	for (i=0;i<256;i++)
		for (j=0;j<256;j++)
			square(i,j)=(char)(i*j);
	printf ("Checking char array\n");
	for (i=0;i<80000;i++)
	{
		if (data_char(i)!=(char)i) goto ERR;
	}
	printf ("Checking int array\n");
	for (i=0;i<40000;i++)
		if (data_int(i)!=(int)i) goto ERR;
	printf ("Checking long array\n");
	for (i=0;i<20000;i++)
		if (data_long(i)!=i) goto ERR;
	printf ("Checking square array\n");
	for (i=0;i<256;i++)
		for (j=0;j<256;j++)
			if (square(i,j)!=(char)(i*j)) goto ERR;
	printf ("Arrays checked out ok\n");
	stop_timer();

	exit(1);
ERR:
	printf ("Error in large array\n");
	printf ("%p %p %p %ld\n",DATA_CHAR,DATA_INT,DATA_LONG,i);
	printf ("%p %p %p\n",pointer_add(DATA_CHAR,i),
					pointer_add(DATA_INT,i),pointer_add(DATA_LONG,i));
	printf ("%d %d %ld\n",(char)data_char(i),data_int(i),data_long(i));
}


