/****************************************************************
*	RDBASIC.C -- example program that reads a BASIC data file	*
****************************************************************/

#include <stdio.h>		/* FILE, fclose(), fopen(), puts(), ...	*/
#include <stdlib.h>		/* exit(), EXIT_FAILURE					*/
#include <ctype.h>
#include "c2bas2c.h"

struct
	{
	int		i;
	char	s[20];
	float	f;
	double	d;
	} buffer;

void main(void)
	{
	int   i;
	FILE *infile, *outfile;

	/* Open the files for BASIC input and output */
	if ( (infile=fopen("BASIC.IN","rb")) == NULL)
		{
		puts("Error - can't open BASIC.IN!");
		exit(EXIT_FAILURE);
		}
	if ( (outfile=fopen("BASIC.OUT","wb")) == NULL)
		{
		puts("Error - can't open BASIC.OUT!");
		exit(EXIT_FAILURE);
		}

	/* Process each record */
	while (fread(&buffer,sizeof(buffer),1,infile) == 1)
		{
		/* convert the float & double to Turbo C format */
		buffer.f = GWfloatToTCfloat(buffer.f);
		buffer.d = GWdoubleToTCdouble(buffer.d);

		/* print the buffer on the screen */
		printf("%3d %20.20s %5.5f %5.10f\n",
			buffer.i, buffer.s, buffer.f, buffer.d);

		/* modify the numbers, and make the string uppercase */
		buffer.i *= 2;
		buffer.f *= 3.25;
		buffer.d *= 9.75;
		for (i=0; i<20; i++)
			buffer.s[i] = toupper(buffer.s[i]);

		/* convert the modified values to GWBASIC format */
		buffer.f = TCfloatToGWfloat(buffer.f);
		buffer.d = TCdoubleToGWdouble(buffer.d);

		/* write the buffer to the output file */
		if (fwrite(&buffer,sizeof(buffer),1,outfile) != 1)
			puts("Error writing buffer!");
		}

	fclose(infile);
	fclose(outfile);
	}
