/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|         'TSR with INT-9 and INT-8 Example                    |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1991 by Borland International              |*/
/*|                  All Rights Reserved.                        |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/


/* This tsr will do a COLD re-boot when the hot key, <Ctrl><Alt><SysReq>,
   is pressed.  It hooks INT 8 and 9 and wooks like this:

   When the Hot key sequence is reached in INT_9, a global flag is set.
   This is checked in the INT_8 routine and the return address on the
   stack is modified to point to another function.  This function then
   re-boots the machine.

*/

/* written by Jeff Peters */

#ifndef __LARGE__
  #error Must compile in Large Model
#endif

#include <dos.h>
#include <conio.h>
#include <stdlib.h>

void interrupt (*_T_old_09) (void);
void interrupt (*_T_old_08) (void);

void interrupt _T_my_08 (void);
void interrupt _T_my_9 (void);
void far _T_re_boot (void);

char far *_T_kbflag;
int _T_G_flag = 0;
unsigned _T_sseg;

extern unsigned _stklen = 128;
extern unsigned _heaplen = 128;

char title[] = "Turbo Re-booter v 1.0 (C) Copyright 1991 by Borland Int'l.\r\n";
char title2[] = "Press <Ctrl><Alt><Sys Req> to do a COLD Re-boot.\r\n";

unsigned stack[100], eos;

void far _T_re_boot (void)
{
  _AX = 0x0000;
  _DX = 0xFFFF;
  __emit__ (0x52, 0x50, 0xCB);
                          // push dx
                          // push ax
                          // retf
}


void interrupt _T_my_9 (void)
{
  _AL = inportb (0x60);  /* get in scan code from port */
  if (_AL != 0x54)
  {
    (*_T_old_09)();
    return;
  }

  if ((*_T_kbflag & 12) == 12)
  {
    _AL = inportb (0x61);
    _AH = _AL;
    _AL = _AL | 0x80;
    outportb (_AL, 0x61);
    _AL = _AH;
    outportb (_AL, 0x61);
    _AL = 0x20;
    outportb (_AL, 0x20);
    if (!_T_G_flag)
    {
      disable ();
      _T_G_flag = 1;
    }
  }
  else
    (*_T_old_09)();


    enable ();
}

void interrupt _T_my_08 (void)
{
  (*_T_old_08)();
  disable ();
  if (_T_G_flag)
  {
    cputs ("\r\n\nRe-booting: COLD ");

/*
     The stack frame will now look like:

                       [bp+22] - flags
                       [bp+20] - segment
                       [bp+18] - offset

                       [bp+16] - ax
                       [bp+14] - bx
                       [bp+12] - cx
                       [bp+10] - dx
                       [bp+08] - es
                       [bp+06] - ds
                       [bp+04] - si
                       [bp+02] - di
                       [bp+00] - bp

    */

      /* patch the new return address into the stack */

      *((unsigned _ss *) (_BP + 18) ) = FP_OFF (_T_re_boot);
      *((unsigned _ss *) (_BP + 20) ) = FP_SEG (_T_re_boot);

      /* and now we exit... */
      _T_G_flag++;
  }
}

void main (void)
{
  _T_kbflag = MK_FP (0x0040,0x0017); /* keyboard shift status byte */
  _T_old_08 = getvect (0x08);
  setvect (0x08, _T_my_08);
  _T_old_09 = getvect (0x09);
  setvect (0x09, _T_my_9);

  cputs (title);
  cputs (title2);
  keep (0, ((_SP >> 4) + _SS) - _psp + 5 );
}

