/*	Copyright (c) 1989 Citadel	*/
/*	   All Rights Reserved    	*/

/* #ident	"@(#)rolodeck.h	1.4 - 90/06/21" */

#ifndef ROLODECK_H	/* prevent multiple includes */
#define ROLODECK_H

#include <cbase.h>

/* cbase name */
#define ROLODECK	"rolodeck.dat"

/* record definition */
typedef struct {
	char rd_contact[41];	/* contact name (last name first) */
	char rd_title[41];	/* contact job title */
	char rd_company[41];	/* company name */
	char rd_addr[2*40+1];	/* company address */
	char rd_city[26];	/* city */
	char rd_state[3];	/* state */
	char rd_zip[11];	/* zip code */
	char rd_phone[13];	/* phone number */
	char rd_ext[5];		/* phone extension */
	char rd_fax[13];	/* fax number */
	char rd_notes[4*40+1];	/* notes */
} rolodeck_t;

/* field names */
#define RD_CONTACT	 (0)
#define RD_TITLE	 (1)
#define RD_COMPANY	 (2)
#define RD_ADDR		 (3)
#define RD_CITY		 (4)
#define RD_STATE	 (5)
#define RD_ZIP		 (6)
#define RD_PHONE	 (7)
#define RD_EXT		 (8)
#define RD_FAX		 (9)
#define RD_NOTES	(10)
#define RDFLDC		(11)

/* field definition list */
extern const cbfield_t rdfldv[RDFLDC];

#endif	/* #ifdef ROLODECK_H */
