@echo off
rem blkio installation batch file-----------------------------------------------
rem binst.bat	1.4 - 90/06/21

rem ----------------------------------------------------------------------------
rem NAME
rem      install.bat - blkio library installation batch file for MS-DOS
rem
rem SYNOPSIS
rem      install model [x]
rem
rem DESCRIPTION
rem     install.bat performs the installation of the blkio library for
rem     MS-DOS.  model specifies the memory model as one of the following.
rem
rem          S        small model
rem          M        medium model
rem          C        compact model
rem          L        large model
rem          H        huge model
rem
rem     The library file is named blkiom.lib, where m would correspond
rem     to the memory model of the library.
rem
rem     If specified, the second parameter causes the reference manual to
rem     be extracted from the source code.  The reference manual is placed
rem     in the file blkio.man.
rem
rem SEE ALSO
rem      makefile
rem
rem NOTES
rem      This batch file is written for use with Microsoft C.  To convert
rem      it for use with another compiler, make the following
rem      modifications:
rem           1. Replace \c\include with the include directory used by
rem              the new compiler.
rem           2. Replace \c\lib with the library directory used by the
rem              new compiler.
rem           3. Replace cl with the command to invoke the compiler being
rem              used, replacing the switches also, if necessary.  Below
rem              are listed the Microsoft C switches used and their
rem              meanings.
rem                   -Oalt     optimization
rem                   -Gs       speed optimization
rem                   -c        compile but don't link
rem                   -Za       ANSI keywords only
rem                   -A        memory model
rem           4. The command to build the library archive from the object
rem              modules may vary more drastically.  Microsoft C uses the
rem              lib command with what is called a response file.  This
rem              response file, blkio.rsp, contains a list of all the
rem              object modules in the library.
rem
rem ----------------------------------------------------------------------------

rem verify arguments------------------------------------------------------------
if "%1" == "S" goto arg1
if "%1" == "M" goto arg1
if "%1" == "C" goto arg1
if "%1" == "L" goto arg1
if "%1" == "H" goto arg1
echo Usage:  install model [x]
echo Valid values for model are S (small), M (medium), C (compact),
echo   H (large), and H (huge).  Model must be upper case.
echo If x is specified, the reference manual will be extracted.
goto end
:arg1

if "%2" == "" goto arg2
if "%2" == "x" goto arg2
echo Usage:  install model [x]
echo Invalid second argument.  Valid value is lowercase x.
:arg2

if "%3" == "" goto arg3
echo Usage:  install model [x]
echo Too many arguments specified.
:arg3

rem install boolean header file-------------------------------------------------
rem
if not exist \c\include\bool.h goto bool
echo \c\include\bool.h exists.  ^C to exit, any other key to continue.
pause
:bool
echo on
copy bool.h \c\include\bool.h
@echo off

rem extract the reference manual------------------------------------------------
if not "%2" == "x" goto skipman
echo Extracting reference manual into blkio.man.
if not exist blkio.man goto man
echo blkio.man exists.  ^C to exit, any other key to continue.
pause
:man
if not exist tmp goto tmp
echo tmp exists.  ^C to exit, any other key to continue.
pause
:tmp
echo on
copy blkio.h/a+bclose.c+bexit.c+bflpop.c+bflpush.c+bflush.c+bgetb.c tmp
type tmp | manx -c > blkio.man
copy bgetbf.c/a+bgeth.c+bgethf.c+bopen.c+bputb.c+bputbf.c tmp
type tmp | manx -c >> blkio.man
copy bputh.c/a+bputhf.c+bsetbuf.c+bsetvbuf.c+bsync.c+lockb.c tmp
type tmp | manx -c >> blkio.man
del tmp
@echo off
:skipman

rem compile all blkio source files----------------------------------------------
echo on
cl -c -Oalt -Gs -Za -A%1 bclose.c   bexit.c    bflpop.c   bflpush.c  bflush.c   bgetb.c
cl -c -Oalt -Gs -Za -A%1 bgetbf.c   bgeth.c    bgethf.c   bopen.c    bputb.c    bputbf.c
cl -c -Oalt -Gs -Za -A%1 bputh.c    bputhf.c   bsetbuf.c  bsetvbuf.c bsync.c    lockb.c
cl -c -Oalt -Gs -Za -A%1 bops.c     buops.c
@echo off

rem build the blkio library archive---------------------------------------------
if exist blkio%1.lib del blkio%1.lib
echo on
lib blkio%1 @blkio.rsp
@echo off

rem install the blkio library---------------------------------------------------
if not exist \c\include\blkio.h goto h
echo \c\include\blkio.h exists.  ^C to exit, any other key to continue.
pause
:h
echo on
copy blkio.h \c\include\blkio.h
@echo off

if not exist \c\lib\blkio%1.lib goto lib
echo \c\lib\blkio%1.lib exists.  ^C to exit, any other key to continue.
pause
:lib
echo on
copy blkio%1.lib \c\lib\blkio%1.lib
@echo off

rem end of blkio installation batch file----------------------------------------
:end
