/* test.c */

#include <stdio.h>
#include <stdlib.h>
#include "dbmgr.h"
#include "test.h"

void main( void);

char *dbNames[] =
    {
    "Customer",
    "acctNbr",
    "company",
    "Address",
    "zip",
    "telephone",
    "Invoice",
    "invNbr",
    "InvoiceLine"
    };

#define CUSTOMER        dbNames[0]
#define ACCTNBR         dbNames[1]
#define COMPANY         dbNames[2]
#define ADDRESS         dbNames[3]
#define ZIP             dbNames[4]
#define TELEPHONE       dbNames[5]
#define INVOICE         dbNames[6]
#define INVNBR          dbNames[7]
#define INVOICELINE     dbNames[8]

struct Customer customer[3] =
    {
    {1000L,"Fred Gwynne Company",0.00},
    {1001L,"CompuServe Incorporated",0.00},
    {1002L,"Microsoft",0.00},
    };

struct Address address[4] =
    {
    {"124 South Columbus St.","Columbus","Oh","43201","6142883222"},
    {"2000 Arlington Center Blvd","Columbus","Oh","43228","6144598600"},
    {"12 North Fork Ave.","Redmond","WA","55555","5332341234"},
    {"13 North Fork Ave.","Redmond","WA","55555","5332341235"},
    };


void main( void)
    {
    long acctNbr = 1001L;
    struct currency_index currency;
    struct Customer t_customer;
    struct Address t_address;

    if( DbOpen( "test.dbd"))
        {
        printf( "Error opening test.dbd\n");
        exit( 1);
        }

    /* Customer 1000 */
    if( DbRecordAdd( CUSTOMER, &customer[0]))
        {
        printf( "Call: DbRecordAdd( CUSTOMER, &customer[0]))\n");
        exit( 1);
        }
    if( DbRecordAdd( ADDRESS, &address[0]))
        {
        printf( "Call: DbRecordAdd( ADDRESS, &address[0]))\n");
        exit( 1);
        }
    if( DbSetAdd( CUSTOMER, ADDRESS))
        {
        printf( "Call: DbSetAdd( CUSTOMER, ADDRESS))\n");
        exit( 1);
        }

    /* Customer 1001 */
    if( DbRecordAdd( CUSTOMER, &customer[1]))
        {
        printf( "Call: DbRecordAdd( CUSTOMER, &customer[1]))\n");
        exit( 1);
        }
    if( DbRecordAdd( ADDRESS, &address[1]))
        {
        printf( "Call: DbRecordAdd( ADDRESS, &address[1]))\n");
        exit( 1);
        }
    if( DbSetAdd( CUSTOMER, ADDRESS))
        {
        printf( "Call: DbSetAdd( CUSTOMER, ADDRESS))\n");
        exit( 1);
        }

    /* Customer 1002 */
    if( DbRecordAdd( CUSTOMER, &customer[2]))
        {
        printf( "Call: DbRecordAdd( CUSTOMER, &customer[2]))\n");
        exit( 1);
        }
    if( DbRecordAdd( ADDRESS, &address[2]))
        {
        printf( "Call: DbRecordAdd( ADDRESS, &address[2]))\n");
        exit( 1);
        }
    if( DbSetAdd( CUSTOMER, ADDRESS))
        {
        printf( "Call: DbSetAdd( CUSTOMER, ADDRESS))\n");
        exit( 1);
        }
    if( DbRecordAdd( ADDRESS, &address[3]))
        {
        printf( "Call: DbRecordAdd( ADDRESS, &address[3]))\n");
        exit( 1);
        }
    if( DbSetAdd( CUSTOMER, ADDRESS))
        {
        printf( "Call: DbSetAdd( CUSTOMER, ADDRESS))\n");
        exit( 1);
        }

    /* Get the first customer by account number */
    if( DbRecordFindFirst( CUSTOMER, ACCTNBR))
        {
        printf( "Call: DbRecordFindFirst( CUSTOMER, ACCTNBR))\n");
        exit( 1);
        }
    if( DbRecordGetCurrent( CUSTOMER, ACCTNBR, &t_customer))
        {
        printf( "Call: DbRecordGetCurrent( CUSTOMER, ACCTNBR, &t_customer))\n");
        exit( 1);
        }

    /* Save the currency */
    if( DbRecordGetCurrency( CUSTOMER, &currency))
        {
        printf( "Call: DbRecordGetCurrency( CUSTOMER, &currency))\n");
        exit( 1);
        }

    /* Get the last customer */
    if( DbRecordGetLast( CUSTOMER, ACCTNBR, &t_customer))
        {
        printf( "Call: DbRecordGetLast( CUSTOMER, ACCTNBR, &t_customer))\n");
        exit( 1);
        }

    /* Get the addresses */
    if( DbSetFindFirst( CUSTOMER, ADDRESS))
        {
        printf( "Call: DbSetFindFirst( CUSTOMER, ADDRESS))\n");
        exit( 1);
        }
    if( DbSetGetFirst( CUSTOMER, ADDRESS, &t_address))
        {
        printf( "Call: DbSetGetFirst( CUSTOMER, ADDRESS, &t_address))\n");
        exit( 1);
        }
    if( DbSetGetNext( CUSTOMER, ADDRESS, &t_address))
        {
        printf( "Call: DbSetGetNext( CUSTOMER, ADDRESS, &t_address))\n");
        exit( 1);
        }

    /* Restore the customer currency and retrieve the current customer */
    if( DbRecordUpdCurrency( CUSTOMER, &currency))
        {
        printf( "Call: DbRecordUpdCurrency( CUSTOMER, &currency))\n");
        exit( 1);
        }
    if( DbRecordGetCurrent( CUSTOMER, ACCTNBR, &t_customer))
        {
        printf( "Call: DbRecordGetCurrent( CUSTOMER, ACCTNBR, &t_customer))\n");
        exit( 1);
        }

    /* Get customer 1001 */
    if( DbRecordGetByKey( CUSTOMER, ACCTNBR, &t_customer, &acctNbr))
        {
        printf( "Call: DbRecordGetByKey( CUSTOMER, ACCTNBR, &t_customer, &acctNbr))\n");
        exit( 1);
        }

    /* Get address */
    if( DbRecordGetByKey( ADDRESS, ZIP, &t_address, "55555"))
        {
        printf( "Call: DbRecordGetByKey( ADDRESS, ZIP, &t_address, \"55555\"))\n");
        exit( 1);
        }

    /* Get the owner of the address */
    if( DbSetGetOwner( CUSTOMER, ADDRESS, &t_customer))
        {
        printf( "Call: DbSetGetOwner( CUSTOMER, ADDRESS, &t_customer))\n");
        exit( 1);
        }

    DbFlush();
    DbClose();
    }
