/* joystick.h       defines and prototypes for the joystick functions in...

                    joystklo.c: Low level game-adapter port access functions.
                    joystkmd.c: Middle level joystick functions for joystklo.c.

                See joystklo.se & joystkmd.se for pseudo code/structured english
                and joystick.doc for an explanation of the functions.

                This module has been released to the public domain
                        Tue  01-07-1992   23:30:18
                by Ed Torgerson : CIS 70313,456,  GEnie E.TORGERSON1.
                any constructive correspondence is welcome.

-----------------------------------------------------------------------------*/

#ifndef __JOYSTICK_H__
#define __JOYSTICK_H__

/* return values for JstGetChangedButton and JstGetButton */

#define JA1_BUTTON_DOWN        16       /* joystick A, button 1, down */
#define JA1_BUTTON_UP           1       /* joystick A, button 1, up   */
#define JA2_BUTTON_DOWN        32       /* joystick A, button 2, down */
#define JA2_BUTTON_UP           2       /* joystick A, button 2, up   */

#define JB1_BUTTON_DOWN        64       /* joystick B, button 1, down */
#define JB1_BUTTON_UP           4       /* joystick B, button 1, up   */
#define JB2_BUTTON_DOWN       128       /* joystick B, button 2, down */
#define JB2_BUTTON_UP           8       /* joystick B, button 2, up   */

#define J_ANY_BUTTON_DOWN    0xf0       /* any button down: either joystick */

#define J_A_BUTTON_DOWN      0x30       /* any button down: joystick A */
#define J_B_BUTTON_DOWN      0xC0       /* any button down: joystick B */

#define J_BUTTON_1_DOWN      0x50       /* button 1 down: either joystick */
#define J_BUTTON_2_DOWN      0xA0       /* button 2 down: either joystick */

/* values to be passed to JstGetPosition */

#define JAX_AXIS                1       /* x axis mask for joystick A */
#define JAY_AXIS                2       /* y axis mask for joystick A */
#define JBX_AXIS                4       /* x axis mask for joystick B */
#define JBY_AXIS                8       /* y axis mask for joystick B */

/* values for stick parameter to be passed to functions in joystkmd.c */

#define JOYSTICK_A              3       /* axis mask for joystick A */
#define JOYSTICK_B           0x0C       /* axis mask for joystick B */

/* joystick position structure to be passed to functions in joystkmd.c */

 struct JoystickPosition {
         int         jx  ;       /* joystick x-coordinate value */
         int         jy  ;       /* joystick y-coordinate value */
 } ;

/*-- Function Prototypes from joystklo.c -----*/

int  JstGetChangedButton( void ) ;
int  JstGetButton ( void ) ;
int  JstGetPosition ( int axis ) ;
int  JstDetect ( void ) ;
int  JstGetValidAxes ( void ) ;
int  JstGetActiveAxes ( void ) ;
int  JstSetActiveAxes ( unsigned mask ) ;
                                     
/*-- Function Prototypes from joystkmd.c -----*/

int  JstInitialize ( void (*NotifyUserFunc)(int) ) ;
int  JstGetChangedPosition ( int stick, struct JoystickPosition *stickpos ) ;
int  JstSetCenter ( int stick ) ;
int  JstSetMin( int stick ) ;
int  JstSetMax( int stick ) ;
void JstGetCenter( int stick, struct JoystickPosition *jpos ) ;
void JstGetMin( int stick, struct JoystickPosition *jpos ) ;
void JstGetMax( int stick, struct JoystickPosition *jpos) ;
void JstXlatToCart ( int stick, struct JoystickPosition *stickpos ) ;
int  JstGetTolerance ( void ) ;
void JstSetTolerance ( int tolerance ) ;

#endif
/*-- end joystick.h -----*/
