/* testlow.c    
                Test for low level game-adapter procedures in joystklo.c.
                Quits if no peripheral (joystick) is detected at port 201h.

                written for Borland C++ 2.0 ;

                to complile :
                            bcc testlow.c joystklo.c
                        or
                            bcc -ms testlow.c joystk_s.lib

                by Ed Torgerson : CIS 70313,456,  GEnie E.TORGERSON1.
                any constructive correspondence is welcome.

-----------------------------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include "joystick.h"

void  main(void)
{
    int     oldA1, newA1, oldA2, newA2 ;
    int     oldB1, newB1, oldB2, newB2 ;
    int     i ;
    char    down[5] = "down" ;
    char    up[5]   = "up  " ;

    oldA1 = newA1 = oldA2 = newA2 = 0 ;
    oldB1 = newB1 = oldB2 = newB2 = 0 ;
    i = 0 ;

    clrscr () ;
    i = JstDetect () ;

    if ( i == 0 )
    {
        printf ("Joystick not detected.") ;
        return ;
    }
    printf ("Joystick detected by JstDetect():\n") ;
    if ( (i & JAX_AXIS) != 0 )
            printf("\tJoystick A x-axis is valid.\n" );
    if ( (i & JAY_AXIS) != 0 )
            printf("\tJoystick A y-axis is valid.\n" );
    if ( (i & JBX_AXIS) != 0 )
            printf("\tJoystick B x-axis is valid.\n" );
    if ( (i & JBY_AXIS) != 0 )
            printf("\tJoystick B y-axis is valid.\n" );
    printf ( "\n" ) ;
    printf ( "JstGetActiveAxes() - %02xh\n", JstGetActiveAxes() ) ;
    printf ( "JstGetValidAxes()  - %02xh\n", JstGetValidAxes() ) ;
    i = JstGetValidAxes() ;
    i = i ^ 0xf ;
    JstSetActiveAxes ( (unsigned) i ) ;
    printf ( "\nAttempting to set invalid active axis\nJstSetActiveAxes " ) ;
    printf ( "(%02xh) == %d", i, JstSetActiveAxes ( (unsigned) i ) ) ;
    printf ( "\t\tActive_Axes - %02xh\n", JstGetActiveAxes() ) ;
    i = JstGetValidAxes() ;
    i = i & 0x5 ;
    printf ( "\nAttempting to set valid active axis\nJstSetActiveAxes " ) ;
    printf ( "(%02xh) == %d", i, JstSetActiveAxes ( (unsigned) i ) ) ;
    printf ( "\t\tActive_Axes - %02xh\n", JstGetActiveAxes() ) ;
    i = JstGetValidAxes() ;
    printf ( "\nAttempting to reset original active axis\nJstSetActiveAxes " ) ;
    printf ( "(%02xh) == %d", i, JstSetActiveAxes ( (unsigned) i ) ) ;
    printf ( "\t\tActive_Axes - %02xh\n", JstGetActiveAxes() ) ;

    printf ("\n\n\nany key to continue...\n") ;
    getch() ;

    /*----- Current Button Status Test --------------------------------------*/

    clrscr () ;
    printf ("JstGetButton()       gets current button status\n") ;
    printf ("any key to continue...\n") ;
    gotoxy (10, 10) ;
    printf ( "Joystick A Button 1 is " ) ;
    gotoxy (10, 11) ;
    printf ( "Joystick A Button 2 is " ) ;
    gotoxy (10, 12) ;
    printf ( "Joystick B Button 1 is " ) ;
    gotoxy (10, 13) ;
    printf ( "Joystick B Button 2 is " ) ;

    while( !kbhit() )
    {
        i = JstGetButton () ;
        gotoxy (33, 10) ;
           if ( (i & JA1_BUTTON_DOWN) )
               printf ( "%s", down ) ;
           else
               printf ( "%s", up ) ;
        gotoxy (33, 11) ;
           if ( (i & JA2_BUTTON_DOWN) )
               printf ( "%s", down ) ;
           else
               printf ( "%s", up ) ;
        gotoxy (33, 12) ;
           if ( (i & JB1_BUTTON_DOWN) )
               printf ( "%s", down ) ;
           else
               printf ( "%s", up ) ;
        gotoxy (33, 13) ;
           if ( (i & JB2_BUTTON_DOWN) )
               printf ( "%s", down ) ;
           else
               printf ( "%s", up ) ;
        delay ( 50 ) ;
    }
    getch() ;

    clrscr () ;
    printf ( "JstGetChangedButton() returns button values ") ;
    printf ( "only if they've changed.\n") ;
    printf ( "JstGetPosition() returns the current position") ;
    printf ( " of valid joystick axes.\n") ;
    printf ( "For this demonstration, only changes greater than") ;
    printf ( " 2 units are reported.\n\n\n") ;

    delay (100) ;

do_test_loop:

    while( !kbhit() )
    {
    /*----- Changed Button Status Test -----------------------------------*/
        i = JstGetChangedButton () ;

        if ( (i & JA1_BUTTON_DOWN) != 0 )
            printf("Joystick A Button 1 down\n" );
        if ( (i & JA1_BUTTON_UP  ) != 0 )
            printf("Joystick A Button 1     up\n" );
        if ( (i & JA2_BUTTON_DOWN) != 0 )
            printf("Joystick A Button 2 down\n" );
        if ( (i & JA2_BUTTON_UP  ) != 0 )
            printf("Joystick A Button 2     up\n" );
        if ( (i & JB1_BUTTON_DOWN) != 0 )
            printf("Joystick B Button 1 down\n" );
        if ( (i & JB1_BUTTON_UP  ) != 0 )
            printf("Joystick B Button 1     up\n" );
        if ( (i & JB2_BUTTON_DOWN) != 0 )
            printf("Joystick B Button 2 down\n" );
        if ( (i & JB2_BUTTON_UP  ) != 0 )
            printf("Joystick B Button 2     up\n" );
        delay ( 6 ) ;

    /*----- Joystick A Position Test --------------------------------------*/
        newA1 = JstGetPosition ( JAX_AXIS ) ;
        newA2 = JstGetPosition ( JAY_AXIS ) ;

        if ( (newA1 != 0) || (newA2 != 0) )
        {
            if ( (newA1 < (oldA1 - 2) ) || (newA1 > (oldA1 + 2) ) ||
                 (newA2 < (oldA2 - 2) ) || (newA2 > (oldA2 + 2) ) )
            {
                printf("Joystick A      \t   %3dx    %3dy real\n", newA1, newA2 );
                oldA1 = newA1 ;
                oldA2 = newA2 ;
            }
        }
        delay ( 6 ) ;

    /*----- Joystick B Position Test --------------------------------------*/
        newB1 = JstGetPosition ( JBX_AXIS ) ;
        newB2 = JstGetPosition ( JBY_AXIS ) ;

        if ( (newB1 != 0) || (newB2 != 0) )
        {
            if ( (newB1 < (oldB1 - 2) ) || (newB1 > (oldB1 + 2) ) ||
                 (newB2 < (oldB2 - 2) ) || (newB2 > (oldB2 + 2) ) )
            {
                printf("Joystick B      \t   %3dx    %3dy real\n", newB1, newB2 );
                oldB1 = newB1 ;
                oldB2 = newB2 ;
            }
        }
        delay ( 6 ) ;
    }
    i = getch () ;
    if ( (i == 59) )
    {
        clrscr () ;
        printf("\n\n\t\t\tPress escape to quit.\n\n") ;
        goto do_test_loop ;
    }
    if ( (i != 27) )
        goto do_test_loop ;

}

/*-- end testlow.c ----*/
