/* testmid.c
                Test for middle level joystick procedures in joystkmd.c.
                Quits if no joystick is detected at port 201h.

                written for Borland C++ 2.0

                to complile :
                            bcc testmid.c joystkmd.c joystklo.c
                        or
                            bcc -ms testmid.c joystk_s.lib

                by Ed Torgerson : CIS 70313,456,  GEnie E.TORGERSON1.
                any constructive correspondence is welcome.

-----------------------------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include "joystick.h"

/*-- Global variables -----*/

void NotifyUser ( int msg ) ;

void NotifyUser (int msg)
{               
    switch (msg)
    {
        case  -2:
            printf ( "warning: joystick installation incomplete!!!!!\n\n" ) ;
            break ;
        case  -1:
            printf ( "joystick installation terminated by user!!!!\n\n" ) ;
            break ;
        case   0:
            printf ( "no joystick detected\n\n" ) ;
            break ;
        case   1:
            printf ( "press escape to quit joystick initialization.\n\n" ) ;
            break ;
        case   2:
            printf ( "center joystick and press button\n\n" ) ;
            break ;
        case   3:
            printf ( "move joystick to top-left and press button 1\n\n" ) ;
            break ;
        case   4:
            printf ( "move joystick to lower-right and press button 2\n\n" ) ;
            break ;
        case  -3:
        default :
            break ;
    }
    return ;
}

void  main(void)
{
    struct JoystickPosition jpos ;
    int     i, tolerence ;

    i = 0 ;

    clrscr () ;
/*------------------ Notice -----------------------------*/

    printf ("\tDemonstration program for the joystick support functions\n") ;
    printf ("\tin joystklo.c, joystkmd.c, and joystick.h.  This program \n") ;
    printf ("\twill quit if no joystick is detected.  The functions in \n") ;
    printf ("\tjoystklo.c provide mixed language support at the port level.\n") ;
    printf ("\tThe functions in joystkmd.c provide C language middle level\n") ;
    printf ("\ttranslation of the low level output.\n\n" ) ;
    printf ("\tThe features of this library include screening for changed\n");
    printf ("\tstate events only, position/resistance scaling for non-linear\n");
    printf ("\tjoystick output, rough translation from the top-left origin\n" );
    printf ("\tjoystick coordinate system to a fairly balanced 0-centered\n");
    printf ("\tcartesian system, and valid axis detection.\n\n" ) ;
    printf ("\tThis library is organized in an Object-Ready fashion.Inter-\n");
    printf ("\tmodule data accesses are hidden by class-style support\n" ) ;
    printf ("\tfunctions.  C++ mavens should have little difficulty in\n" ) ;
    printf ("\ttranslating this library to classes.\n\n" ) ;
    printf ("\t\tEd Torgerson  CIS 70313,456,  GEnie E.TORGERSON1\n\n" ) ;
    printf ("\tFor a look at pure low level C Functions, see the file in\n" ) ;
    printf ("\tBorland's C forum on which my low level functions are based:\n");
    printf ("\t\tJOY.ARC written by Gary Blaine  72707,1736\n" ) ;
    printf ("\t\t\tany key to continue...") ;
    getch() ;
    clrscr () ;

/*------------------ Initialization test -----------------------------*/
    if ( JstInitialize ( NotifyUser ) == 0 )
    {
        printf( "Initialize failed or was terminated!!!\n\n" ) ;
        return ;
    }          
    printf( "Initialize succeeded!\n\n" ) ;
    i = JstGetActiveAxes() ;
    if ( (i & JAX_AXIS) != 0 )
            printf("\tJoystick A x-axis is valid.\n" );
    if ( (i & JAY_AXIS) != 0 )
            printf("\tJoystick A y-axis is valid.\n" );
    if ( (i & JBX_AXIS) != 0 )
            printf("\tJoystick B x-axis is valid.\n" );
    if ( (i & JBY_AXIS) != 0 )
            printf("\tJoystick B y-axis is valid.\n\n" );

    printf ( "\nG_Stick_Centers - " ) ;
    JstGetCenter( JOYSTICK_A, &jpos) ;
    printf ("jax: %04d,  jay: %04d,  ", jpos.jx, jpos.jy);
    JstGetCenter( JOYSTICK_B, &jpos) ;
    printf ("jbx: %04d,  jby: %04d\n", jpos.jx, jpos.jy);

    printf ( "\nG_Stick_Minimums - " ) ;
    JstGetMin( JOYSTICK_A, &jpos) ;
    printf ("jax: %04d,  jay: %04d,  ", jpos.jx, jpos.jy);
    JstGetMin( JOYSTICK_B, &jpos) ;
    printf ("jbx: %04d,  jby: %04d\n", jpos.jx, jpos.jy);

    printf ( "\nG_Stick_Maximums - " ) ;
    JstGetMax( JOYSTICK_A, &jpos) ;
    printf ("jax: %04d,  jay: %04d,  ", jpos.jx, jpos.jy);
    JstGetMax( JOYSTICK_B, &jpos) ;
    printf ("jbx: %04d,  jby: %04d\n", jpos.jx, jpos.jy);

    tolerence = JstGetTolerance() ;
    printf ( "\nG_Stick_Tolerence - %04d\n", tolerence ) ;

    printf ("\nany key to continue...\n") ;
    getch() ;
/*------------------ Middle Level tests -----------------------------*/


    clrscr() ;
    printf("JstGetChangedButton() returns button values") ;
    printf(" only if they've changed.\n") ;
    printf("JstGetChangedPosition() returns the current position") ;
    printf(" only if it has changed.\n") ;
    printf("JstXlatToCart() translates the current position") ;
    printf(" to cartesian coordinates.\n") ;
    printf("J or j sets the center to the current location. JstSetCenter()\n") ;
    printf("M or m sets the minimum to the current location. JstSetMin()\n") ;
    printf("N or n sets the maximum to the current location. JstSetMax()\n") ;
    printf("+ or - increments or decrements the tolerence. JstSetTolerance()") ;
    printf("\n\n\t\tmove joystick/press buttons.\n") ;
    printf("\n\t\t\t\t\tpresss ESCAPE to quit...\n") ;

    delay (100) ;

    tolerence = tolerence >> 1 ;        /* set tolerence by half steps */

do_test_loop:

    while( !kbhit() )
    {
    /*----- Button Changed Status Test --------------------------------------*/
        i = JstGetChangedButton () ;

        if ( (i & JA1_BUTTON_DOWN) != 0 )
            printf("Joystick A Button 1 down\n" );
        if ( (i & JA1_BUTTON_UP  ) != 0 )
            printf("Joystick A Button 1     up\n" );
        if ( (i & JA2_BUTTON_DOWN) != 0 )
            printf("Joystick A Button 2 down\n" );
        if ( (i & JA2_BUTTON_UP  ) != 0 )
            printf("Joystick A Button 2     up\n" );
        if ( (i & JB1_BUTTON_DOWN) != 0 )
            printf("Joystick B Button 1 down\n" );
        if ( (i & JB1_BUTTON_UP  ) != 0 )
            printf("Joystick B Button 1     up\n" );
        if ( (i & JB2_BUTTON_DOWN) != 0 )
            printf("Joystick B Button 2 down\n" );
        if ( (i & JB2_BUTTON_UP  ) != 0 )
            printf("Joystick B Button 2     up\n" );
        delay ( 6 ) ;

    /*----- A Position Test -----------------------------------------------*/

        if ( JstGetChangedPosition(JOYSTICK_A, &jpos) )
        {
            printf("Joystick A      \t   %3dx    %3dy real", jpos.jx, jpos.jy) ;
            JstXlatToCart (JOYSTICK_A, &jpos) ;
            printf("\t   %4dx    %4dy cartesian\n", jpos.jx, jpos.jy) ;
        }
        delay ( 6 ) ;

    /*----- B Position Test -----------------------------------------------*/
        if ( JstGetChangedPosition(JOYSTICK_B, &jpos) )
        {
            printf("Joystick B      \t   %3dx    %3dy real", jpos.jx, jpos.jy) ;
            JstXlatToCart (JOYSTICK_B, &jpos) ;
            printf("\t   %4dx    %4dy cartesian\n", jpos.jx, jpos.jy) ;
        }

        delay ( 6 ) ;
    }
    i = getch () ;
    if ( (i == 'j') || (i == 'J') )
    {
        printf ("\n\n\t\tResetting center position of both joysticks.\n") ;
        JstSetCenter( JOYSTICK_A ) ;
        JstSetCenter( JOYSTICK_B ) ;
        JstGetCenter( JOYSTICK_A, &jpos ) ;
        printf ( "New Centers at - " ) ;
        printf ("jx: %04d,  jy: %04d,  ", jpos.jx, jpos.jy);
        JstGetCenter( JOYSTICK_B, &jpos) ;
        printf ("jx: %04d,  jy: %04d\n\n", jpos.jx, jpos.jy);
        goto do_test_loop ;
    }
    if ( (i == 'n') || (i == 'N') )
    {
        printf ("\n\n\t\tResetting minimum position of both joysticks.\n") ;
        JstSetMin( JOYSTICK_A ) ;
        JstSetMin( JOYSTICK_B ) ;
        JstGetMin( JOYSTICK_A, &jpos) ;
        printf ( "New Minimums at - " ) ;
        printf ("jx: %04d,  jy: %04d,  ", jpos.jx, jpos.jy);
        JstGetMin( JOYSTICK_B, &jpos) ;
        printf ("jx: %04d,  jy: %04d\n\n", jpos.jx, jpos.jy);
        goto do_test_loop ;
    }
    if ( (i == 'm') || (i == 'M') )
    {
        printf ("\n\n\t\tResetting maximum position of both joysticks.\n") ;
        JstSetMax( JOYSTICK_A ) ;
        JstSetMax( JOYSTICK_B ) ;
        JstGetMax( JOYSTICK_A, &jpos) ;
        printf ( "New Maximums at - " ) ;
        printf ("jx: %04d,  jy: %04d,  ", jpos.jx, jpos.jy);
        JstGetMax( JOYSTICK_B, &jpos) ;
        printf ("jx: %04d,  jy: %04d\n\n", jpos.jx, jpos.jy);
        goto do_test_loop ;
    }
    else if ( i == '+' )
    {
        i = JstGetTolerance() ;
        if ( i < tolerence * 20 )
        {
            i += tolerence ;
            JstSetTolerance( i ) ;
            printf("\n\tJoystick tolerence now set to %d\n\n", i ) ;
        }
        goto do_test_loop ;
    }
    else if ( i == '-' )
    {
        i = JstGetTolerance() ;
        if ( i > tolerence )
        {
            i -= tolerence ;
            JstSetTolerance( i ) ;
            printf("\n\tJoystick tolerence now set to %d\n\n", i ) ;
        }
        goto do_test_loop ;
    }
    if ( (i == 59) )
    {
        clrscr () ;
        printf("\n\n\tj:center,\tm:minimum,\tn:maximum,\t+/-:tolerance\n") ;
        printf("\n\t\t\tPress escape to quit.\n\n") ;
        goto do_test_loop ;
    }
    if ( (i != 27) )
        goto do_test_loop ;
    return ;

}
/*-- end testmid.c */
