/* code.h  - taking C to higher level */
/* Coding Language of "Raw" C language preprocessor transformations */

   /* Operator Constructs */

      /* Logical Operators */
      # define   AND   &&
      # define   OR    ||
      # define   NOT   !


      /* Bitwise operators */
      # define   BAND  &             /* Bitwise AND */
      # define   BOR   |
      # define   BXOR  ^
      # define   BNOT  ~
      # define   LSHF  <<
      # define   RSHF  >>

   /* Control Constructs (block implicit) */

      /* IF ___ ELSE ___ ENDIF construct */
      # define   IF(c)        if(c) {
      # define   ELSE         ;} else {
      # define   ENDIF        ;}
      # define   ELSEIF(c)    ;} else if(c) {

      /* CASE construct */
      # define   CASE(c)      switch(c) {
      # define   CASEOF(c)    case c : {
      # define   DEFCASE      default : {
      # define   ENDCOF       } break;
      # define   ENDCASE      }

      /* WHILE(c) ___ ENDW construct */
      # define   WHILE(c)     while(c) {
      # define   ENDW         ;}

      /* FOR(c) ___ ENDF construct */
      # define   FOR(c)       for(c) {
      # define   ENDF         ;}

      /* FOREVER ___ ENDFR */
      # define   FOREVER      while (1) {
      # define   ENDFR        ;}

      /* REPEAT ___ UNTIL(c) */
      # define   REPEAT       do {
      # define   UNTIL(c)     } while(!(c));

      /* BEGIN ___ END  General block */
      # define   BEGIN   {
      # define   END     }

