#include <string.h>
#include <dos.h>
#include <alloc.h>

/*
   CMDPARSE - Contains several TURBO-C functions to handle the command line
              passed on the call to a program.

              Several assumptions are made:

                  All parameters are separated by one or more spaces. The
                   number of spaces is not significant and the spaces are
                   not a part of the parameter.

                  No more than 20 parameters and options will be passed.

                  Options are indicated by a leading switch character,
                   either a slash (/) or a dash (-).

                  Slash-delimited options may be appended to a field without
                   a separating space, vis.

                            param/n        command/c

                  Dash-delimited options will always be preceded by a space.

                  Options always are terminated by a space.

                  Options can take one of three forms:

                           Switch+character    example:   /n
                           Switch+string       example:   /noi
                           Switch+expression   example:   /VIDEO=MONO

                  The switch+expression options may NOT have spaces before &/or
                    after the = sign.

                  No case conversions are done.

*/

#define TRUE 1

#define FALSE 0

/* ********************* Global variables ************************** */

/* combined_cmd holds the pieces of the command pointed to by cmd_arg[] */

static char combined_cmd[260];

/* cmd_arg[] is an array of pointers to the pieces of the command.  It
   is accessible from the program using extern.
*/

char *cmd_arg[22];

/* arg_type[] is an array of flags indicating the type of each of the
   arguments.  It is accessible from the program using extern.  The
   flags are 0=parameter 1=option.
*/

int arg_type[22];


/* *************************** Functions ************************** */

/*
    CMD_INIT retrives and parses the command line into the arrays.

    Call:        status = cmd_init();

    Returns:     0 if error, non-zero if ok

*/

int cmd_init(void)
{
    char *buffer;               /* Scratch buffer to assemble cmdline */

    int i;                      /* Index variable */

    char *cmdline, *outline;    /* Pointers used during parse */


    /* Allocate temporary buffer to assemble command line */

    if ((buffer = (char *) calloc(260, sizeof(char))) == NULL)
          return(0);

    if (_argc == 0) return(0);

    /* Assemble command line */

    strcpy(buffer,*_argv);              /* Command argument */

    for (i=1;i<_argc;i++)
    {
        strcat(buffer,"\v");             /* Param delimiter */
        strcat(buffer,*(_argv+i));
    }

    /* Now move the line into its final resting place, delimit params
    */

    cmdline = buffer;                   /* Source pointer */

    outline = &combined_cmd[0];         /* Destination pointer */

    while (*cmdline != '\0')
    {
        if (*cmdline == '/' && *(cmdline-1) != '\v')
        {
            *outline = '\v';             /* Leading delimiter  */
            outline += 1;
        }
        *outline = *cmdline;
        outline += 1;
        cmdline += 1;
    }
    *outline = '\0';                   /* Null-terminate string */

    free(buffer);                      /* Release temporary string */

    /* Now set up array */

    cmdline = &combined_cmd[0];

    cmd_arg[0] = cmdline;              /* program name  */
    cmd_arg[1] = NULL;                 /* end of array test */

    i=1;

    while (*cmdline != '\0')
    {
        if (*cmdline == '\v')
        {
            *cmdline = '\0';
            cmdline += 1;

            cmd_arg[i] = cmdline;     /* pointer to next */

            if (*(cmdline) == '/' || *(cmdline) == '-')
                 arg_type[i] = 1;
            else
                 arg_type[i] = 0;

            i += 1;
            cmd_arg[i] = NULL;         /* End of array test */
        }
        else
            cmdline += 1;
    }


    return(1);
}

/*
     GET_PARAM - Returns a pointer to a read-only string containing the
                 value of the parameter.

     Call:    ch_pointer = get_param(n)

                     n = number of the parameter (0 - n)

     Return:  Pointer to parameter in combined_cmd, NULL if not found

*/

char *get_param(int pnum)
{
    int i,count;

    if (pnum == 0) return(cmd_arg[0]);

    count=0;

    for (i=1; cmd_arg[i] != NULL; i++)
    {
        if (arg_type[i] == 0)
        {
            count += 1;

            if (count == pnum)  return(cmd_arg[i]);       /* Return from here */
        }
    }

    return(NULL);
}

/*
   IF_OPTION - Scans all option fields and tests the first character(s)
               following the switch to see if they match.  The number of
               characters checked is determined by the number of characers
               in the test string passed.

               The comparison is case sensitive.

   Call:   result = if_option("n");

           result = if_option("MVID");

   Result:       0 if not found
                 array subscript in cmd_arg[] if found

*/

int if_option(char *tst_str)
{
    int i;
    size_t tsl;

    tsl = strlen(tst_str);

    for (i=1; cmd_arg[i] != NULL; i++)
    {
        if (arg_type[i] == 1)
            if ((strlen(cmd_arg[i])-1) >= tsl)
                if ((strncmp(tst_str,(cmd_arg[i]+1),tsl)) == 0)
                          return(i);                            /* Return
                                                                   from
                                                                   here
                                                                   */
    }

    return(0);
}


/*
   IF_OPTIONI - Scans all option fields and tests the first character(s)
               following the switch to see if they match.  The number of
               characters checked is determined by the number of characers
               in the test string passed.

               The comparison is case insensitive.

   Call:   result = if_option("n");

           result = if_option("MVID");

   Result:       0 if not found
                 array subscript in cmd_arg[] if found

*/

int if_optioni(char *tst_str)
{
    int i;
    size_t tsl;

    tsl = strlen(tst_str);

    for (i=1; cmd_arg[i] != NULL; i++)
    {
        if (arg_type[i] == 1)
            if ((strlen(cmd_arg[i])-1) >= tsl)
                if ((strnicmp(tst_str,(cmd_arg[i]+1),tsl)) == 0)
                          return(i);                            /* Return
                                                                   from
                                                                   here
                                                                   */
    }

    return(0);
}


/*
     OPT_VALUE - Returns a pointer to the read-only string containing the
                 rvalue of a /optname=value option type. Scans all option
               fields and tests the first character(s) following the switch
               to see if they match.  The number of characters checked is
               determined by the number of characers in the test string
               passed.

               The comparison is case sensitive.

    Call:   c_pointer = opt_value("CHGSTR");

            c_pointer = opt_value("x");

    Returns:  Pointer to rvalue substring in combined_cmd.
              NULL if not found.

*/

char *opt_value(char *tst_str)
{
    int i;
    size_t tsl;
    char *rvalue;

    tsl = strlen(tst_str);

    for (i=1; cmd_arg[i] != NULL; i++)
    {
        if (arg_type[i] == 1)
            if ((strlen(cmd_arg[i])-1) >= tsl)
                if ((strncmp(tst_str,(cmd_arg[i]+1),tsl)) == 0)
                {
                    rvalue = strchr(cmd_arg[i],'=');
                    if (rvalue != NULL) return(rvalue+1);       /* Return
                                                                   from
                                                                   here
                                                                   */
                }

    }

    return(NULL);
}


/*
     OPT_VALUEI - Returns a pointer to the read-only string containing the
                 rvalue of a /optname=value option type. Scans all option
               fields and tests the first character(s) following the switch
               to see if they match.  The number of characters checked is
               determined by the number of characers in the test string
               passed.

               The comparison is case insensitive.

    Call:   c_pointer = opt_value("CHGSTR");

            c_pointer = opt_value("x");

    Returns:  Pointer to rvalue substring in combined_cmd.
              NULL if not found.

*/

char *opt_valuei(char *tst_str)
{
    int i;
    size_t tsl;
    char *rvalue;

    tsl = strlen(tst_str);

    for (i=1; cmd_arg[i] != NULL; i++)
    {
        if (arg_type[i] == 1)
            if ((strlen(cmd_arg[i])-1) >= tsl)
                if ((strnicmp(tst_str,(cmd_arg[i]+1),tsl)) == 0)
                {
                    rvalue = strchr(cmd_arg[i],'=');
                    if (rvalue != NULL) return(rvalue+1);       /* Return
                                                                   from
                                                                   here
                                                                   */
                }

    }

    return(NULL);
}

