/* menudrv.h -- header file for menu system */

#define editable   /* define editable to permit user to modify menus */

typedef char string14[15];
typedef char string40[41];
typedef char string80[81];
typedef char string66[67];
typedef char string255[256];
typedef struct _linerec
	{
	string80 line;
	struct _linerec * next;
	} linerec;

typedef struct _menuitem
{
   char id;              			/*menu id (M is first)*/
   char prompt;                     /*user prompt (1,2,3..)*/
   char description[82];            /*line item description*/
   char tomenu;                     /*id of next menu, if appropriate*/
   struct _linerec * firstline;     /*pointer to first line for batch file*/
} menuitem;

typedef linerec* lineptr;
typedef menuitem *menuptr;
typedef unsigned char vscreen[4000];
typedef vscreen  *vptr;

#define blink 		0x80
#define maxitem 	1000          	/*maximum number of individual line items*/
#define fname 		"menu.dat"      /*data file name*/
#define bakfname 	"menu.bak"
#define tempfname 	"menu.$$$"
#define parmfname 	"menu.prm"
#define bfname 		"menuload.bat"  /*batch file name*/
#define TRUE 		1
#define FALSE 		0



/* function predeclarations */
void display_menu(void);