#include "menudrv.h"
#include "menudrv.def"
#include <alloc.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*========================================================================*/
/* EDIT subroutines                                                       */
/*========================================================================*/
/* declarations */

int insertx=60,inserty=1;
int trimblanks=FALSE;
int colx=0,coly=0;

/*-----------------------------------------------------------------------*/

void pad(char st[],int len)
/* pad the length of string st to len chars */
{
   char *cp;
   int i;

   /* find end of string */
   for (cp=st,i=0; (*cp != 0) && (i<len); cp++,i++);
   /* if not long enough, pad it */
   while (i<len) {
     *(cp++)=' ';
     i++;
   }
   /* and reterminate it */
   *cp=0;
}

/*-----------------------------------------------------------------------*/

void trim(char st[])
/* trim trailing blanks off of string st */
{
    int i;

    if ( st[0] != 0 ) {
       i = strlen(st)-1;
       while ( (i >= 0) && (st[i] == ' ') ) i--;
       if (st[i] == ' ') st[i]=0;
       else st[i+1]=0;
    }
}

/*-----------------------------------------------------------------------*/

void lcase(char st[])
/* trim and convert string st to lower case */
{
   trim(st);
   while (*st != NULL) tolower(*(st++));
}

/*-----------------------------------------------------------------------*/

int getstring(int x,int y,int *c,char st[],int len)
/* x,y are the position where the field begins; c is the cursor column
   within the field (0 for 1st position); c is updated by getstring() */
/* return codes (based on exit keystroke):
    0:    CR, original entry changed
    1:    CR, original entry unchanged
    2:    Esc
    3:    up arrow, ctrl-e
    4:    left arrow, ctrl-s
    5:    right arrow, ctrl-d
    6:    down arrow, ctrl-x
    7:    ctrl-w
    8:    End
    9:    PgUp, ctrl-r
   10:    PgDn, ctrl-c
   11-20: F1..F10
   21:    ctrl-y
   22:    ctrl-z
   23:    ctrl-n
   24:    Home
*/
{
   int _fret, i, n, nn;
   char ch, c2, ch2, *cp;
   string80 blankfield,model;

/* activate next section if colons (:) are desired around input fields */
/* gotoxy(x - 1,y);
   cprintf("%c", ':');
   gotoxy(x + len,y);
   cprintf("%c", ':');  */

   gotoxy(insertx,inserty);
   if ( insert )
        cputs(" INSERT    ");
   else
        cputs(" OVERWRITE ");

   strcpy(model,st);  /* make reference copy */
   gotoxy(x,y);
   strcpy(blankfield,blank);
   blankfield[len]=0;  /* truncate length */

   pad(st,len);

   cputs(st);

   n = *c;
   do {
      gotoxy(x + n,y);
      ch = getch();

      /*handle special characters*/
      if ( ch == 0 ) {  /* IBM PC special char sequence */
         c2 = getch();  /* get second char */
         /* return predefined exit codes for F1..F10  (11..20) */
         if ((c2 >= 59) && (c2 <= 68)) {
            _fret = c2 - 48;
            goto L99;
         }
         switch ( c2 ) {
            case 72 :        /* up arrow */
               ch = 5;       /* convert to ctrl-e */
               break;
            case 80 :        /* down arrow */
               ch = 24;      /* convert to ctrl-x */
               break;
            case 75 :        /* left arrow */
               ch = 19;      /* convert to ctrl-s */
               break;
            case 77 :        /* right arrow */
               ch = 4;       /* convert to ctrl-d */
               break;
            case 73 :        /* PgUp */
               ch = 18;      /* convert to ctrl-r */
               break;
            case 81 :        /* PgDn */
               ch = 3;       /* convert to ctrl-c */
               break;
            case 82 :        /* Ins */
               ch = 22;      /* convert to ctrl-v */
               break;
            case 83 :        /* Del */
               ch = 7;       /* convert to ctrl-g */
               break;
            case 79 :        /* End */
               _fret = 8;
               goto L99;
            case 71 :        /* Home */
               _fret =  24;  /* return code 24 */
               goto L99;
            default:
               ch = 0;
               break;
         }  /* switch */
      }    /* if special */

      switch ( ch ) {        /* Esc */
         case 27 :
               _fret = 2;
               goto L99;
         case 13 :           /* CR */
               if (strcmp(st,model)==0) _fret = 1;
               else _fret = 0;
               if (y<25) (y)++;
               goto L99;
         case 5 :            /* ctrl-e */
               _fret = 3;
               goto L99;
         case 19 :           /* ctrl-s */
                if ( n == 1 ) {
                  _fret = 4;
                  goto L99;
                }
                else n--;
                break;
         case 4 :            /* ctrl-d */
                if ( n == len ) {
                  _fret = 5;
                  goto L99;
                }
                else n++;
                break;
         case 24 :           /* ctrl-x */
               _fret = 6;
               goto L99;
         case 23 :           /* ctrl-w */
               _fret = 7;
               goto L99;
         case 18 :           /* ctrl-r */
               _fret = 9;
               goto L99;
         case 3 :            /* ctrl-c */
               _fret = 10;
               goto L99;
         case 25 :           /* ctrl-y */
               strcpy(st,blankfield);
               n = 0;
               gotoxy(x,y);
               cputs(blankfield);
              _fret = 21;
              goto L99;
         case 26 :           /* ctrl-z */
              _fret = 22;
              goto L99;
         case 14 :           /* ctrl-n */
              _fret = 23;
              goto L99;
         case 22 :           /* ctrl-v */
               insert = !(insert);
               gotoxy(insertx,inserty);
               if ( insert )
                  cputs(" INSERT    ");
               else
                  cputs(" OVERWRITE ");
               break;
         case 7 :            /* ctrl-g */
               for ( i = n; i < len - 1; i++ )
                  st[i] = st[i + 1];
               st[len - 1] = ' ';
               gotoxy(x,y);
               cputs(st);
               break;
         case 20 :           /* ctrl-t */
               p = n;
               if (st[n] == ' ' )
                  while ( (p < len) && (st[p] == ' ') ) p++;
               else
                  while ( (p < len) && (st[p] != ' ') ) p++;
               strdel(st,n,p);
               for ( i = 0; i <= p - n; i++ )
                  strcat(st," ");
               gotoxy(x,y);
               cputs(st);
               break;
        case 9 :              /* ctrl-i or TAB */
               n++;
               while ((n<len) && (5 * (n / 5) != n)) n++;
               gotoxy(x + n,y);
               break;
        case 17:             /* ctrl-q */
                ch2=getch();
                ch2=toupper(ch2);
                if ((ch2 =='D') || (ch2==4)) {  /* end of line */
                    n=len;
                    while ((st[n-1]==' ') && (n>0)) n--;
                    if (n<len) n++;
                }
                else if ((ch2 == 'S') || (ch==13)) { /* beg of line */
                    n=1;
                    while ((st[n-1]==' ') && (n<len)) n++;
                }
                else if ((ch2=='R') || (ch2==12)) {
                  _fret=9;
                  goto L99;
                }
                else if ((ch2=='C') || (ch2== 3)) {
                  _fret=10;
                  goto L99;
                }
                else putch(7);
                break;
         case 1 :            /* ctrl-a */
               while ( (n > 0) && (st[n] != ' ')) n--;
               while ( (n > 0) && (st[n] == ' ')) n--;
               while ( (n > 0) && (st[n] != ' ' )) n--;
               if ( st[n] == ' ') n++;
               gotoxy(x + n,y);
               break;
         case 6 :            /* ctrl-f */
               /* find end of current word */
               while ( (n < len - 1) && (st[n] != ' ') ) n++;
               nn = n;
               /* find beginning of nextg word */
               while ( (n < len) && (st[n] == ' ') ) n++;
               if ( n == len ) {    /* no next word: back up */
                 n = nn;
                 if (n<len) n++;
               }
               gotoxy(x + n,y);
               break;
         default:
           {
           if ((insert) && !((ch >= 8) && (ch <= 13))){
                  for ( i = len - 1; i > n ; i-- )
                     st[i] = st[i - 1];
                  st[n] = ch;
                  gotoxy(x,y);
                  cputs(st);
               }
               else {
                  if (!((ch >= 8) && (ch <= 13)) ) {
                     st[n] = ch;
                     putch(ch);
                  }
               }
               if ( (ch == '\x08') && (n > 0) )   /*backing up*/
                  n--;
               else if (ch != '\x08')
                  n++;
            }
            break;
      } /*switch/case*/

      if (colx != 0) {
        gotoxy(colx,coly);
        printf("%3d",n+1);
      }

   } while ( ! ((ch == '\x0D') || (n > len)) );
   if ( n >= len )  putch(7);
   _fret = 0;

L99:

   if (trimblanks) {
     if ( st[0] != 0 ) {
       i = len-1;
       while ( (i >= 0) && (st[i] == ' ') ) i--;
       if (st[i] == ' ') st[i]=0;
       else st[i+1]=0;
     }
   }

   (*c) = n;  /* update cursor position */
   return(_fret);

} /*getstring*/

/*-----------------------------------------------------------------------*/
#ifdef editable
/*-----------------------------------------------------------------------*/

int getint(int x,int y,int *i,int w)
{
   int retcd,ret,col;
   string80 temp;
   col=0;

   do {
     sprintf(temp,"%wd",*i);
     retcd = getstring(x,y,&col,temp,w);
     trim(temp);
     ret = sscanf(temp, "%d", i);
     if (ret==0) putch(7);
   }
   while (ret == 0);
   gotoxy(x,y);
   cprintf("%wd", (*i));
   return(retcd);
}  /*getint*/

/*-----------------------------------------------------------------------*/

int getachar(int x,int y,char *ch)
{
  int retval,col;
  col=0;
  retval = getstring(x,y,&col,ch,1);
  return(retval);
}

/*-----------------------------------------------------------------------*/

void editscreen (void)
{
    bclear(2);
    bfore=(color(fore5));
    bback=(color(back5));
    bwrite(2,1,1,"ͻ");
    bwrite(2,1,2," Menu:       Item:         Descr:                                             ");
    bwrite(2,1,3,"͹");
    bwrite(2,1,4,"                                                                              ");
    bwrite(2,1,5,"                                                                              ");
    bwrite(2,1,6,"                                                                              ");
    bwrite(2,1,7,"                                                                              ");
    bwrite(2,1,8,"                                                                              ");
    bwrite(2,1,9,"                                                                              ");
    bwrite(2,1,10,"                                                                              ");
    bwrite(2,1,11,"                                                                              ");
    bwrite(2,1,12,"                                                                              ");
    bwrite(2,1,13,"                                                                              ");
    bwrite(2,1,14,"                                                                              ");
    bwrite(2,1,15,"                                                                              ");
    bwrite(2,1,16,"                                                                              ");
    bwrite(2,1,17,"                                                                              ");
    bwrite(2,1,18,"                                                                              ");
    bwrite(2,1,19,"                                                                              ");
    bwrite(2,1,20,"                                                                              ");
    bwrite(2,1,21,"                                                                              ");
    bwrite(2,1,22,"                                                                              ");
    bwrite(2,1,23,"ͼ");
    bfore=(color(fore1));
    bback=(color(back1));
    restorescreen(2);
}

/*-----------------------------------------------------------------------*/

void topfill (void)
{
    gotoxy(36,2);
    cprintf("%-40s",cdescription);
    gotoxy(9,2);
    putchar(cmenu);
    gotoxy(21,2);
    putchar(citem);
}

/*-----------------------------------------------------------------------*/

void topedit (void)
{
     int        xpos, ypos, col;
     string80   temp;

    xpos=36;
    ypos=2;
    col=0;
    getstring(xpos,ypos,&col,cdescription,40);
    trim(cdescription);
}

/*-----------------------------------------------------------------------*/

void redraw (void)   /* redraw internal part of screen */
{

    int     i;

    savescreen(2);
    bfore=(color(fore5));
    bback=(color(back5));
    for (i=1; i<20; i++) bwrite(2,2,i+3,edscreen[i]);
    restorescreen(2);
    bfore=(color(fore1));
    bback=(color(back1));
}

/*-----------------------------------------------------------------------*/

void redisplay (void)   /* redisplay current screen buffer */
{
    editscreen();
    redraw();
    topfill();
}

/*-----------------------------------------------------------------------*/

void do_help (void)
{

    char   ch;

    savescreen(2);
    bclear(3);
    bfore=(color(fore6));
    bback=(color(back6));
    bwrite(3,5,2,"ͻ");
    bwrite(3,5,3,"     EDIT HELP SCREEN                                                ");
    bwrite(3,5,4,"                             F1 - show this help screen              ");
    bwrite(3,5,5,"                             Home - goto line 1, column 1            ");
    bwrite(3,5,6,"           ^e                PgUp, ^r - goto top of screen           ");
    bwrite(3,5,7,"                             PgDn, ^c - goto bottom of screen        ");
    bwrite(3,5,8,"            ^                End, ^w  - save changes, exit           ");
    bwrite(3,5,9,"            |                Ins, ^v  - toggle insert mode           ");
    bwrite(3,5,10,"            |                Del, ^g  - delete one character         ");
    bwrite(3,5,11,"    ^s <----o----> ^d        Tab, ^i  - goto next tab position       ");
    bwrite(3,5,12,"            |                ^y  -  delete line                      ");
    bwrite(3,5,13,"            |                ^z  -  blank screen                     ");
    bwrite(3,5,14,"            v                ^t  -  delete word right                ");
    bwrite(3,5,15,"                             ^a/^f  -  advance word left/right       ");
    bwrite(3,5,16,"           ^x                ^qs/^qd - goto beginning/end of line    ");
    bwrite(3,5,17,"                             ^n  -  insert line                      ");
    bwrite(3,5,18,"     Cursor Movement                                                 ");
    bwrite(3,5,19,"    (or use cursor keys)                                             ");
    bwrite(3,5,20,"                                                                     ");
    bwrite(3,5,21,"    Note: ^ indicates hold the Ctrl key while pressing the key       ");
    bwrite(3,5,22,"ͼ");
    bwrite(3,5,24,"Press any key to continue editing...");
    restorescreen(3);
    getch();
    bfore=(color(fore5));
    bback=(color(back5));
    restorescreen(2);

}

/*-----------------------------------------------------------------------*/

void do_examples (void)

{
    char     ch;

    savescreen(2);
    bclear(4);
    bfore=(color(fore6));
    bback=(color(back6));
    bwrite(4,5,1,"ͻ");
    bwrite(4,5,2,"     CREATING MENU ITEMS:                                            ");
    bwrite(4,5,3,"          The lines which you supply for a menu item using this      ");
    bwrite(4,5,4,"          editor ultimately become lines in a DOS batch file         ");
    bwrite(4,5,5,"          when the item is selected--therefore, any legal batch      ");
    bwrite(4,5,6,"          file commands may be used.  For example:                   ");
    bwrite(4,5,7,"                  cd\\multimate                                       ");
    bwrite(4,5,8,"                  wp                                                 ");
    bwrite(4,5,9,"                  cd\\                                                ");
    bwrite(4,5,10,"                  menu                                               ");
    bwrite(4,5,11,"          would change the directory to 'multimate', execute 'wp',   ");
    bwrite(4,5,12,"          change back to the root directory, and restore the menu.   ");
    bwrite(4,5,13,"          (Note: you should always restart the menu as your last     ");
    bwrite(4,5,14,"          item if you want the menu to return)                       ");
    bwrite(4,5,15,"                                                                     ");
    bwrite(4,5,16,"          Command line substitution may be accomplished by           ");
    bwrite(4,5,17,"          enclosing a prompt string between square brackets ([]s)    ");
    bwrite(4,5,18,"          at the position of a command line where the substitution   ");
    bwrite(4,5,19,"          is needed.   For example:                                  ");
    bwrite(4,5,20,"                    copy [Source?] [Destination?]                    ");
    bwrite(4,5,21,"          will cause MENU to prompt the user for 'Source?' and       ");
    bwrite(4,5,22,"          'Destination?' in turn, then use the replies to build      ");
    bwrite(4,5,23,"          the DOS command line.                                      ");
    bwrite(4,5,24,"ͼ");
    bwrite(4,5,25,"Press any key to continue....");
    restorescreen(4);
    getch();
    bwrite(4,5,1,"ͻ");
    bwrite(4,5,2,"     CREATING MENU ITEMS (continued):                                ");
    bwrite(4,5,3,"                                                                     ");
    bwrite(4,5,4,"          Normally, a batch file is created by the menu driver       ");
    bwrite(4,5,5,"          and the menu program exits to DOS, which executes the      ");
    bwrite(4,5,6,"          batch file.  If you are executing a relatively short       ");
    bwrite(4,5,7,"          stand-alone program, however, you may do so as a           ");
    bwrite(4,5,8,"          subprocess while the menu system remains resident.         ");
    bwrite(4,5,9,"                                                                     ");
    bwrite(4,5,10,"          To execute a program as a subprocess, place a '&'          ");
    bwrite(4,5,11,"          in the first column of the command line, e.g.:             ");
    bwrite(4,5,12,"                                                                     ");
    bwrite(4,5,13,"                   &c:\\dos\\link.exe parm1 parm2 ...                  ");
    bwrite(4,5,14,"                                                                     ");
    bwrite(4,5,15,"          The '&' will be trimmed off by the menu driver,            ");
    bwrite(4,5,16,"          and the remaining command will be executed as a child      ");
    bwrite(4,5,17,"          process.  This is noticeably faster than the batch file    ");
    bwrite(4,5,18,"          approach, and may extend to multiple command lines.        ");
    bwrite(4,5,19,"          Command line parameters and [] substitution are permitted. ");
    bwrite(4,5,20,"                                                                     ");
    bwrite(4,5,21,"          Notice that the FULL PATH and FILENAME must be specified   ");
    bwrite(4,5,22,"          for the subprocess.  Error messages will be returned if    ");
    bwrite(4,5,23,"          the call is not successful.                                ");
    bwrite(4,5,24,"ͼ");
    bwrite(4,5,25,"Press any key to continue editing...");
    restorescreen(4);
    getch();
    if (color(back1)>7) textcolor(color(fore1)+blink);
    else textcolor(color(fore1));
    textbackground(color(back1));
    restorescreen(2);
}

/*-----------------------------------------------------------------------*/

void edit (void)    /* edit the screen */
{
    char        ch,ch2,c2;
    int         a,b;
    int         i,j,n,retcd,col;
    int         xx;

    insert=FALSE;
    editscreen();
    for (i=1; i<20; i++) pad(edscreen[i],77); /* pad length to 77 */
    topfill();
    redraw();
    topedit();
    x=1;
    y=1;
    col=0;
    colx=24;
    coly=24;
    do  {
        if (color(back1)>7) textcolor(color(fore1)+blink);
        else textcolor(color(fore1));
        textbackground(color(back1));
        gotoxy(5,24);
        cprintf("Row: %3d   Column: %3d",y,col+1);
        cprintf("  Use F1 for help, F2 for examples     ");
        if (color(back5)>7) textcolor(color(fore5)+blink);
        else textcolor(color(fore5));
        textbackground(color(back5));

        retcd=getstring(x+1,y+3,&col,edscreen[y],77);
        switch (retcd) {
          case 0 :
          case 1 :
            col=0;
          case 6 :
            if (y<19) y++;
            break;
          case 3 :
            if (y>1) y--;
            break;
          case 11 :         /* F1 */
            do_help();
            break;
          case 12 :         /* F2 */
            do_examples();
            break;
          case 24 :         /* Home */
            y = 1;
            col = 0;
            break;
          case 9 :          /* PgUp */
            y = 1;
            break;
          case 10:          /* PgDn */
            y = 19;
            break;
          case 21:          /* ctrl-y */
            for (i=y; i<19; i++)
                strcpy(edscreen[i],edscreen[i+1]);
            edscreen[19][0]=0;
            pad(edscreen[19],77);
            redisplay();
            break;
          case 22:          /* ctrl-z */
            gotoxy(10,24);
            clreol();
            cprintf("Zap entire screen -- you sure (Y/N)?");
            ch=getch();
            ch=toupper(ch);
            if (ch == 'Y') {
                for (i=1; i<20; i++) {
                    edscreen[i][0]=0;
                    pad(edscreen[i],77);
                }
                y=1;
                col=0;
                redisplay();
            }
            else {
             gotoxy(10,24);
                clreol();
            }
            break;
          case 23:      /* ctrl-n */
            for (i=19; i>y; i--) strcpy(edscreen[i],edscreen[i-1]);
            edscreen[y][col]=0; /* cut orig line short */
            if (y<19) {
              strdel(edscreen[y+1],0,col);
              pad(edscreen[y],77);
              y++;
              col=0;
            }
            redraw();
            break;
        } /* switch retcd */
    }
    while ((retcd != 7) && (retcd != 8));

    gotoxy(1,24);
    if (color(back1)>7) textcolor(color(fore1)+blink);
    else textcolor(color(fore1));
    textbackground(color(back1));
    clreol();
    colx=0;
    coly=0;

    for (i=1; i<20; i++) trim(edscreen[i]);  /* trim trailing blanks */

} /* edit */

/*-----------------------------------------------------------------------*/
#endif
/*-----------------------------------------------------------------------*/

void getdata (void)
{

    char        *p;
    lineptr     cp,np;
    char        inpline[128];

    items=lines=0;
    cp=np=NULL;
    datafile=fopen(fname,"r");

    if (datafile==NULL) {
        cprintf("Unable to open %s.\n",fname);
        cprintf("Press any key to continue...");
        ch=getch();
        clrscr();
        exit(1);
    }
    while (fgets(inpline,127,datafile) != NULL) {
        p=strstr(inpline,"\n");
        if (p!=NULL) *p=0;  /* delete carriage returns */
        if (inpline[0]=='&') {   /* continuation of previous item */
            strdel(inpline,0,1);
            while ((strlen(inpline)>0) && (inpline[0]==' '))
              strdel(inpline,0,1);
            goto L10; /* process parameters */
        }
        while (inpline[0]==' ') strdel(inpline,0,1);  /* trim it */
        while (inpline[strlen(inpline)-1]==' ')
            strdel(inpline,strlen(inpline)-1,1);
        items++;
        if (items>maxitem) {
            cprintf("Item overflow \7\n");
            items--;
            cprintf("Press any key to continue...");
            ch=getch();
            clrscr();
            exit(1);
        }
        item[items]=(menuptr) calloc(1,sizeof(*(item[items])));
        if (item[items]==NULL) {
            cprintf("Unable to allocate storage for menu items.\n");
            exit(1);
        }
        item[items]->id=toupper(inpline[0]);
        item[items]->tomenu=toupper(inpline[2]);
        item[items]->prompt=toupper(inpline[4]);
        strdel(inpline,0,6);
        p=strstr(inpline,",");
        if (p==NULL) {
            strcpy(item[items]->description,inpline);
            inpline[0]=0;
        }
        else {
            *p=0;   /* mark comma position as temporary end of string */
            strcpy(item[items]->description,inpline);
            *p=' '; /* replace null with ASCII blank */
            strdel(inpline,0,(p-inpline)+1);  /* delete thru blank */
        }

    item[items]->firstline=NULL;

L10:
        p=strstr(inpline,",");
        while (p!=NULL) {  /* capture parameters */
            if (p==inpline) strdel(inpline,0,1); /* first char */
            else {
                np=(lineptr)calloc(1,sizeof(*np));  /*allocate new line*/
                if (np==NULL) {
                    cprintf("Unable to allocate storage for next line.\n");
                    exit(1);
                }
                *p=0;
                strcpy(np->line,inpline);
                np->next=NULL;
                if (item[items]->firstline==NULL)
                    item[items]->firstline=np;
                else cp->next=np; /* make the previous line point to this */
                cp=np;
                *p=' ';
                strdel(inpline,0,(p-inpline)+1);
            } /* else */
            p=strstr(inpline,",");
        }  /* while p!=NULL */
        if (strlen(inpline)>0) {   /*1 last item*/
            np=(lineptr)calloc(1,sizeof(*np));   /*allocate new line*/
            if (np==NULL) {
                    cprintf("Unable to allocate storage for next line.\n");
                    exit(1);
                }
            strcpy(np->line,inpline);
            np->next=NULL;
            if (item[items]->firstline==NULL)
                item[items]->firstline=np;
            else cp->next=np; /* make previous line point to this one */
            cp=np;
            inpline[0]=0; /* done with line */
        }
    } /* while more input remains */

    parmfile=fopen(parmfname,"r");
    if (parmfile!=NULL) {
        fscanf(parmfile,"%s\n",fore1);
        fscanf(parmfile,"%s\n",back1);
        fscanf(parmfile,"%s\n",fore2);
        fscanf(parmfile,"%s\n",back2);
        fscanf(parmfile,"%s\n",fore3);
        fscanf(parmfile,"%s\n",back3);
        fscanf(parmfile,"%s\n",fore4);
        fscanf(parmfile,"%s\n",back4);
        fscanf(parmfile,"%s\n",fore5);
        fscanf(parmfile,"%s\n",back5);
        fscanf(parmfile,"%s\n",fore6);
        fscanf(parmfile,"%s\n",back6);
        fclose(parmfile);
    }
} /*getdata*/

/*-----------------------------------------------------------------------*/

void savemenu (void)
/* save menu data if user has changed it */
{
    int         i,j,n;
    char        otline[128];
    lineptr     cp,np;

    datafile=fopen(tempfname,"w");
    for (i=1; i<=items; i++) if (item[i] != NULL){
        sprintf(otline,"%c,%c,%c %s",item[i]->id,item[i]->tomenu,
          item[i]->prompt,item[i]->description);
        cp=item[i]->firstline;
        while (cp != NULL) {
            if ((strlen(cp->line)+strlen(otline))>79) {
                fprintf(datafile,"%s\n",otline);
                strcpy(otline,"& ");
            }
            else strcat(otline,",");
            strcat(otline,cp->line);
            cp=cp->next;
        }
        fprintf(datafile,"%s\n",otline);
    } /* for */
    fclose(datafile);

    unlink(bakfname);
    rename(fname,bakfname);
    rename(tempfname,fname);
} /* savemenu */

/*-----------------------------------------------------------------------*/

void saveparm (void)
/* save color parameters */
{
    parmfile=fopen(parmfname,"w");
    fprintf(parmfile,"%s\n",fore1);
    fprintf(parmfile,"%s\n",back1);
    fprintf(parmfile,"%s\n",fore2);
    fprintf(parmfile,"%s\n",back2);
    fprintf(parmfile,"%s\n",fore3);
    fprintf(parmfile,"%s\n",back3);
    fprintf(parmfile,"%s\n",fore4);
    fprintf(parmfile,"%s\n",back4);
    fprintf(parmfile,"%s\n",fore5);
    fprintf(parmfile,"%s\n",back5);
    fprintf(parmfile,"%s\n",fore6);
    fprintf(parmfile,"%s\n",back6);
    fclose(parmfile);
}

/*-----------------------------------------------------------------------*/

void getsysdate (void)
{
    union REGS regs;
    regs.h.ah=42;   /* DOS get date function */
    int86(33,&regs,&regs);
    month=regs.h.dh;
    day=regs.h.dl;
    year=regs.x.cx;
    weekday=regs.h.al;
}

/*-----------------------------------------------------------------------*/

void dispdate (void)
{
    string80 temp;

    sprintf(temp,"%s, %s %d, %d",wdname[weekday],mname[month],
            day,year);
    bwrite(1,1,1,temp);
}

/*-----------------------------------------------------------------------*/

void getsystime (void)
{
    union REGS regs;

    regs.h.ah=44;   /* DOS get time function */
    int86(33,&regs,&regs);
    hour=regs.h.ch;
    min=regs.h.cl;
    sec=regs.h.dh;
    hun=regs.h.dl;
}

/*-----------------------------------------------------------------------*/

void disptime (void)
{

    int pm,h;
    string80 temp;

    if (hour>12) {
        h=hour - 12;
        pm=TRUE;
    }
    else {
        h=hour;
        pm=FALSE;
    }
    cprintf("%2d:%02d:%02d %s",h,min,sec,(pm ? "pm" : "am"));

}

/*-----------------------------------------------------------------------*/

void bcalendar(int x,int y)
{

    int     i,d,w,cw,cd;
    char    syear[11];
    char    sn[20];

    bfore=color(fore2);
    bback=color(back2);
    bwrite(1,x,y,"");
    for (i=1;i<=26;i++) bwrite(1,x+i,y,"");
    bwrite(1,x+27,y,"");
    for (i=1;i<=8;i++) {
        bwrite(1,x,y+i,"                          ");
    }
    bwrite(1,x,y+9,"");
    for (i=1;i<=26;i++) bwrite(1,x+i,y+9,"");
    bwrite(1,x+27,y+9,"");
    sprintf(syear,"%4d",year);
    bwrite(1,x+3,y+1,syear);
    bwrite(1,x+14-strlen(mname[month]) / 2,y+1,mname[month]);
    bwrite(1,x+21,y+1,syear);
    bwrite(1,x+2,y+2,"S   M   T   W   T   F   S");
    d=weekday;
    w=((day+5-d) / 7)+1;  /*weeks into month*/
    cw=w;
    cd=d;
    for (i=day;i>0;i--) {
        sprintf(sn,"%2d",i);
        if (holiday[month][i]) bfore=color(fore3);
        if (specialday[month][i]) {
          bfore=color(back2);
          bback=color(fore2);
        }
        bwrite(1,x+1+(cd*4),y+2+cw,sn);
        if (holiday[month][i]) bfore=color(fore2);
        if (specialday[month][i]) {
          bfore=color(fore2);
          bback=color(back2);
        }
        cd--;
        if (cd<0) {
            cd=6;
            cw--;
        }
    } /* for */
    cw=w;
    cd=d;
    /* leap year correction */
    if ((year % 4 == 0) &&
        ((year % 100 !=0) || (year % 400==0))) days[2]=29;
    for (i=day;i<=days[month];i++) {
        sprintf(sn,"%2d",i);
        if (holiday[month][i]) bfore=color(fore3);
        if (specialday[month][i]) {
          bfore=color(back2);
          bback=color(fore2);
        }
        bwrite(1,x+1+(cd*4),y+2+cw,sn);
        if (holiday[month][i]) bfore=color(fore2);
        if (specialday[month][i]) {
          bfore=color(fore2);
          bback=color(back2);
        }
        cd++;
        if (cd>6) {
            cd=0;
            cw++;
        } /* if */
    } /* for */
    bfore=color(fore1);
    bback=color(back1);
    sprintf(sn,"%2d",day);
    bwrite(1,x+1+(d*4),y+2+w,sn);
    bfore=color(fore2);
    bback=color(back2);
    d=0;
    for (i=1; i<=(month-1);i++) d=d+days[i];
    d=d+day;
    sprintf(sn,"Day of year: %3d",d);
    bwrite(1,x+10,y+8,sn);
}    /* calendar */

/*-----------------------------------------------------------------------*/

#ifdef editable

void menued(void)
{
    bfore=color(fore1);
    bback=color(back1);
    bclear(2);
    bfore=color(fore5);
    bback=color(back5);
    bwrite(2,1,3,"ͻ");
    bwrite(2,1,4," Menu:       Item:         Descr:                                             ");
    bwrite(2,1,5," Menu to transfer to:                                                         ");
    bwrite(2,1,6,"͹");
    bwrite(2,1,7," Note: This menu entry transfers control to another menu.                     ");
    bwrite(2,1,8,"       It has no DOS action items of its own.                                 ");
    bwrite(2,1,9,"ͼ");
    bfore=color(fore1);
    bback=color(back1);
    restorescreen(2);
}

/*-----------------------------------------------------------------------*/

void menufill(void)
{
    gotoxy(36,4);
    cprintf("%-40s",cdescription);
    gotoxy(9,4);
    cprintf("%c",cmenu);
    gotoxy(21,4);
    cprintf("%c",citem);
    gotoxy(24,5);
    cprintf("%c",ctomenu);
}

/*-----------------------------------------------------------------------*/

void menuedit(void)
{
    int     rcode,pos;

    pos=0;
L20:
    rcode=getachar(21,4,&citem);
    if (rcode==2 || rcode==7) goto L50;
    if (rcode==3 || rcode==4) goto L40;
L30:
    rcode=getstring(36,4,&pos,cdescription,40);
    if (rcode==2 || rcode==7) goto L50;
    if (rcode==3 || rcode==4) goto L20;
L40:
    rcode=getachar(24,5,&ctomenu);
    if (rcode==2 || rcode==7) goto L50;
    if (rcode==3 || rcode==4) goto L30;
L50:
    ;
}

void editmenu(void)
{
    menued();
    menufill();
    menuedit();
}

#endif

/*-----------------------------------------------------------------------*/

void colorhelp(void)
{
    int i;

    bfore=(color(fore6));
    bback=(color(back6));
    bwrite(2,2,22,"ͻ");
    bwrite(2,2,23," COLORS: black, blue, green, cyan, red, magenta, brown, lightgray, darkgray ");
    bwrite(2,2,24," lightblue, lightgreen, lightcyan, lightred, lightmagenta, yellow, white    ");
    bwrite(2,2,25,"ͼ");
    for (i=0; i<16; i++) {
        bback=i;
        bwrite(2,1,i+4,"    ");
    }
    bfore=(color(fore1));
    bback=(color(back1));
}

/*-----------------------------------------------------------------------*/

void dispcolors(void)
{

    bfore=(color(fore1));
    bback=(color(back1));
    border(color(back1));
    bclear(2);
    bwrite(2,10,1,"Set Display Colors");
    bfore=(color(fore5));
    bback=(color(back5));
    bwrite(2,8,2,"ͻ");
    bwrite(2,8,3," DEFAULT (date, time, today's date, messages)                      ");
    bwrite(2,8,4," Foreground:                      Background:                      ");
    bwrite(2,8,5,"ͺ");
    bwrite(2,8,6," CALENDAR                                                          ");
    bwrite(2,8,7," Foreground:                      Background:                      ");
    bwrite(2,8,8,"ͺ");
    bwrite(2,8,9," MENU SELECTIONS                                                   ");
    bwrite(2,8,10," Foreground:                      Background:                      ");
    bwrite(2,8,11,"ͺ");
    bwrite(2,8,12," ALARM ITEMS (under calendar, and when alerted)                    ");
    bwrite(2,8,13," Foreground:                      Background:                      ");
    bwrite(2,8,14,"ͺ");
    bwrite(2,8,15," EDIT SCREEN                                                       ");
    bwrite(2,8,16," Foreground:                      Background:                      ");
    bwrite(2,8,17,"ͺ");
    bwrite(2,8,18," EDIT HELP                                                         ");
    bwrite(2,8,19," Foreground:                      Background:                      ");
    bwrite(2,8,20,"ͼ");
    bfore=(color(fore1));
    bback=(color(back1));
    bwrite(2,10,21,"Use cursor arrows to move between fields, ctrl-W when done.");
    colorhelp();
    restorescreen(2);
}

/*-----------------------------------------------------------------------*/

void fillcolors(void)
{
    gotoxy(21,4);
    cprintf("%-14s",fore1);
    gotoxy(54,4);
    cprintf("%-14s",back1);
    gotoxy(21,7);
    cprintf("%-14s",fore2);
    gotoxy(54,7);
    cprintf("%-14s",back2);
    gotoxy(21,10);
    cprintf("%-14s",fore3);
    gotoxy(54,10);
    cprintf("%-14s",back3);
    gotoxy(21,13);
    cprintf("%-14s",fore4);
    gotoxy(54,13);
    cprintf("%-14s",back4);
    gotoxy(21,16);
    cprintf("%-14s",fore5);
    gotoxy(54,16);
    cprintf("%-14s",back5);
    gotoxy(21,19);
    cprintf("%-14s",fore6);
    gotoxy(54,19);
    cprintf("%-14s",back6);
}

/*-----------------------------------------------------------------------*/

void edcolors(void)
{
    int rcode,i,col,field;

    field=1;
    do {
      col=0;
      switch (field) {
      case 1:
            rcode=getstring(21,4,&col,fore1,12);
            lcase(fore1);
            break;
      case 2:
            rcode=getstring(54,4,&col,back1,12);
            lcase(back1);
            break;
      case 3:
            rcode=getstring(21,7,&col,fore2,12);
            lcase(fore2);
            break;
      case 4:
            rcode=getstring(54,7,&col,back2,12);
            lcase(back2);  /* convert to lower case */
            break;
      case 5:
            rcode=getstring(21,10,&col,fore3,12);
            lcase(fore3);  /* convert to lower case */
            break;
      case 6:
            rcode=getstring(54,10,&col,back3,12);
            lcase(back3);  /* convert to lower case */
            break;
      case 7:
            rcode=getstring(21,13,&col,fore4,12);
            lcase(fore4);  /* convert to lower case */
            break;
      case 8:
            rcode=getstring(54,13,&col,back4,12);
            lcase(back4);  /* convert to lower case */
            break;
      case 9:
            rcode=getstring(21,16,&col,fore5,12);
            lcase(fore5);  /* convert to lower case */
            break;
      case 10:
            rcode=getstring(54,16,&col,back5,12);
            lcase(back5);  /* convert to lower case */
            break;
      case 11:
            rcode=getstring(21,19,&col,fore6,12);
            lcase(fore6);  /* convert to lower case */
            break;
      case 12:
            rcode=getstring(54,19,&col,back6,12);
            lcase(back6);  /* convert to lower case */
      } /* switch/case */
      if (rcode==3 || rcode==4) field--;
      else field++;
      if (field>12) field=1;
      if (field<1) field=12;
    } while ((rcode != 2) && (rcode != 7)); /* do */
}

/*-----------------------------------------------------------------------*/

void editcolor(void)
{
    dispcolors();
    fillcolors();
    edcolors();
}
