#include "menudrv.h"
#include "menudrv.def"
#include <alloc.h>
#include <dos.h>
#include <mem.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>

/* Important! Use a memory model which employs far data pointers so that
   these routines can access video memory directly; suggest: compact model;
   otherwise, the FP_SET and FP_OFF functions will not work!! */
/*=========================================================================*/
/*  short.lib -- library of get functions for use by Turbo C menu driver;  */
/*  includes the following screen functions:                               */
/*                                                                         */
/*    binit;  <allocate buffers>                                           */
/*    savescreen(b);  <save current video display to buffer b (0..4)>      */
/*    restorescreen(b);  <restore video display from buffer b>             */
/*    bclear(b); <clear buffer b using current bfore, bback color codes>   */
/*    bwrite(b,x,y,str); <insert string <str> into buffer b at (x,y)>      */
/*                                                                         */
/*=========================================================================*/


void binit(void)  /* initialize video buffers */
{
   int i;
   union REGS regs;

   for ( i = 0; i <= 4; ++i ) {
      sbuff[i] = calloc(1,sizeof(*sbuff[i]));
   }
   bfore = WHITE;
   bback = BLACK;
   /*determine whether display is monochrome or color*/
   regs.x.ax = 0;
   int86(17,&regs,&regs);  /*equipment list call*/
   if ( (regs.h.al & 48) == (48) ) {
      monochrome = TRUE;
   }
   else {
      monochrome = FALSE;
   }
   initialized = TRUE;
}

/*====================================================*/

void savescreen(int i)
{
   unsigned char b;

   if ( ! initialized ) {
      cprintf("%s%s%s\n", "** savescreen routine called without buffer ",
       "initialization **",
       "\x07\x07");
      return;
   }

   b = peek(0,1125);
   outportb(984,(b & 240) | 1);  /*blank screen*/
   if ( monochrome ) {
      movedata(0xb000,0,FP_SEG(sbuff[i]),FP_OFF(sbuff[i]),4000);
   }
   else {
      movedata(0xb800,0,FP_SEG(sbuff[i]),FP_OFF(sbuff[i]),4000);
   }
   outportb(984,b);
}

/*====================================================*/

void restorescreen(int i)
{
   unsigned char b;

   if ( ! initialized ) {
      cprintf("%s%s%s\n",
      "** restorescreen routine called without buffer ",
      "initialization **", "\x07\x07");
      return;
   }
   b = peek(0,1125); /*DOS video mode byte reference*/
   outportb(984,(b & 240) | 1);  /*blank screen*/
   if ( monochrome ) {
      movedata(FP_SEG(sbuff[i]),FP_OFF(sbuff[i]),0xb000,0,4000);
   }
   else {
      movedata(FP_SEG(sbuff[i]),FP_OFF(sbuff[i]),0xb800,0,4000);
   }
   poke(0,1125,b & 223);
   outportb(984,b & 223);
}

/*====================================================*/

void copyscreen(int i,int j)
{

   if ( ! initialized ) {
      cprintf("%s%s%s\n",
      "** copyscreen routine called without buffer ",
      "initialization **", "\x07\x07");
      return;
   }
   if ((i<0) || (i>4)) {
      return;
   }
   movedata(FP_SEG(sbuff[i]),FP_OFF(sbuff[i]),
     FP_SEG(sbuff[j]),FP_OFF(sbuff[j]),4000);
}
/*====================================================*/

void bclear(int b)
{
   int i;

   if ( ! initialized ) {
      cprintf("%s%s%s\n", "** bclear routine called without buffer ",
      "initialization **", "\x07\x07");
      return;
   }
   i = 0;
   while ( i < 4000 ) {
      (*sbuff[b])[i] = 32;  /*ASCII blank*/
      (*sbuff[b])[i + 1] = (bback) * 16 + bfore;
      i += 2;
   }
}  /*bclear*/

/*====================================================*/

void bwrite(int b,int x,int y,char st[])
{
   int i;
   int p;

   if ( ! initialized ) {
      cprintf("%s%s%s\n", "** bwrite routine called without buffer ",
      "initialization **", "\x07\x07");
      return;
   }
   p = ((y - 1) * 160) + ((x - 1) * 2) ;  /*starting position in buffer*/
   for ( i = 0; i < strlen(st); i++) {
      (*sbuff[b])[p] = st[i];
      (*sbuff[b])[p + 1] = (bback) * 16 + bfore;
      p += 2;
   } /*for i*/
}  /*bwrite*/

/*=========================================================================*/

void border(color)
int color;
{
   union REGS regs;

   regs.h.ah = 11; /*set color palette*/
   regs.h.bh = 0;
   regs.h.bl = color;
   int86(16,&regs,&regs); /*video services*/

} /*border*/

/*=========================================================================*/

int color(char st[])
{
   int _fret;

   if ( (strcmp(st,"black") == 0) ) _fret = BLACK;
   else if ( (strcmp(st, "white") == 0) ) _fret = WHITE;
   else if ( (strcmp(st, "blue") == 0) ) _fret = BLUE;
   else if ( (strcmp(st, "cyan") == 0) ) _fret = CYAN;
   else if ( (strcmp(st, "green") == 0) ) _fret = GREEN;
   else if ( (strcmp(st, "red") == 0) ) _fret = RED;
   else if ( (strcmp(st, "magenta") == 0) ) _fret = MAGENTA;
   else if ( (strcmp(st, "brown") == 0) ) _fret = BROWN;
   else if ( (strcmp(st, "yellow") == 0) ) _fret = YELLOW;
   else if ( (strcmp(st, "lightgray") == 0) ) _fret = LIGHTGRAY;
   else if ( (strcmp(st, "darkgray") == 0) ) _fret = DARKGRAY;
   else if ( (strcmp(st, "lightblue") == 0) ) _fret = LIGHTBLUE;
   else if ( (strcmp(st, "lightgreen") == 0) ) _fret = LIGHTGREEN;
   else if ( (strcmp(st, "lightcyan") == 0) ) _fret = LIGHTCYAN;
   else if ( (strcmp(st, "lightred") == 0) ) _fret = LIGHTRED;
   else if ( (strcmp(st, "lightmagenta") == 0) ) _fret = LIGHTMAGENTA;
   else _fret = WHITE;
   return(_fret);
}

/*=========================================================================*/

void colorval(int color,char st[])
{

   if ( color == BLACK ) strcpy(st,"black");
   else if ( color == WHITE ) strcpy(st,"white");
   else if ( color == BLUE ) strcpy(st,"blue");
   else if ( color == CYAN ) strcpy(st,"cyan");
   else if ( color == GREEN ) strcpy(st,"green");
   else if ( color == RED ) strcpy(st,"red");
   else if ( color == MAGENTA ) strcpy(st,"magenta");
   else if ( color == BROWN ) strcpy(st,"brown");
   else if ( color == YELLOW ) strcpy(st,"yellow");
   else if ( color == LIGHTGRAY ) strcpy(st,"lightgray");
   else if ( color == DARKGRAY ) strcpy(st,"darkgray");
   else if ( color == LIGHTBLUE ) strcpy(st,"lightblue");
   else if ( color == LIGHTGREEN ) strcpy(st,"lightgreen");
   else if ( color == LIGHTCYAN ) strcpy(st,"lightcyan");
   else if ( color == LIGHTRED ) strcpy(st,"lightred");
   else if ( color == LIGHTMAGENTA ) strcpy(st,"lightmagenta");
   else strcpy(st,"WHITE");
}
