/*	ConvChar.C - DOS filter to convert single characters to another char */
/*	This little ditty is hereby released into public domain */
/*	Author - Steve Kraus - 12 June 1989*/

#include <stdio.h>

void main (int argc, char *argv[])

{
	int c;				/* char read from stdin & converted */
	int fromch;			/* source char to convert */
	int toch;			/* destination char to convert */

	if (argc < 2) {					/* need two arguments, give help & quit */
		fputs ("ConvChar is a DOS filter to convert single character values globally\n"
			"  to another character value.  Usage:\n\n"
			"ConvChar fromchar tochar <source >dest		Where:\n\n"
			"  fromchar is the decimal value of the character to convert\n"
			"  tochar   is the decimal value of the character to replace\n"
			"  source   is the Ascii source file\n"
			"  dest     is the Ascii destination file\n\n"
			"ConvChar 0 255 <olddoc >newdoc\n"
			"Reads & copies OLDDOC file to NEWDOC, converting chars valued 0 to value 255\n\n"
			"ConvChar 255 0 <newdoc >newerdoc\n"
			"Reverses above, reads NEWDOC, converts 255 value chars back to 0 on NEWERDOC\n\n"
			"DIR /W | ConvChar 9 32\n"
			"Converts all tab chars from DIR /W (value 9) to a single space (value 32)\n"
			,stdout);
		exit(1);
	}

	fromch = atoi (argv[1]);			/* source character value */
	toch = atoi (argv[2]);				/* destination character value */

	while ((c = getchar()) != EOF) {	/* read single char until EOF */
		if (c == fromch) c = toch;		/* convert matching characters */
		putchar (c);					/* copy character to stdout */
	}

}
