#include <stdio.h> 

#ifndef CPP
#define CPP "/lib/cpp"
#endif /* CPP */

char *progname;
char *c_source_file;
extern char current_file_name[];
extern FILE *yyin;

/*  This is main. */

int
main (argc, argv)
     int argc;
     char **argv;
{
  char *cpp_cmd_line;
  int nocpp = 0;
  int sz;
  int i;

  init_tree_nodes ();
  progname = rindex (argv[0], '/');
  if (0 != progname)
    ++progname;
  else
    progname = argv[0];

  if (argc < 2)
    {
      fprintf (stderr, "Usage: %s [-nocpp] [-any valid cpp options] file [file .. ]\n", progname);
      exit (1);
    }

  sz = strlen (CPP);
  for (i = 0; i < argc; ++i)
    sz += strlen (argv[i]);
  cpp_cmd_line = (char *) malloc (sz);
  if ((char *)0 == cpp_cmd_line)
    {
      perror (progname);
      exit (1);
    }
  strcpy (cpp_cmd_line, CPP);
  strcat (cpp_cmd_line, " ");

  for (i = 1; i < argc && '-' == argv[i][0]; ++i)
    {
      switch (argv[i][1])
	{
	case 'C':
	case 'H':
	case 'M':
	case 'P':
	case 'R':
	case 'T':
	case 'Y':
	  strcat (cpp_cmd_line, argv[i]);
	  strcat (cpp_cmd_line, " ");
	  break;
	case 'I':
	case 'D':
	case 'U':
	  strcat (cpp_cmd_line, argv[i]);
	  strcat (cpp_cmd_line, " ");
	  if (0 == argv[i][2])
	    {
	      strcat (cpp_cmd_line, argv[i]);
	      strcat (cpp_cmd_line, " ");
	    }
	  break;
	default:
	  if (0 == strcmp ("-undef", argv[i]))
	    strcat (cpp_cmd_line, "-undef ");
	  else if (0 == strcmp ("-nocpp", argv[i]))
	    ++nocpp;
	  break;
	  
	}
    }

  if (nocpp)
    {
      for (; i < argc; ++i)
	{
          yyin = fopen (argv[i], "r");
          c_source_file = argv[i];
          strcpy (current_file_name, c_source_file);

	  if ((FILE *) 0 != stdin)
	    {
	      int ret;
	      ret = yyparse ();
	      if (ret)
		exit (1);
	      build_prototypes ();
	      free_prototypes ();
	      fclose (yyin);
	    }
	  else
	    fprintf (stderr, "%s: Can't open <%s>, skipping.\n", progname, argv[i]);
	}
    }
  else
    {
      int ind = strlen (cpp_cmd_line);
      for (; i < argc; ++i)
	{
          strcat (cpp_cmd_line, argv[i]);
	  yyin = popen (cpp_cmd_line, "r");
          c_source_file = argv[i];
          strcpy (current_file_name, c_source_file);
 
	  if ((FILE *) 0 != stdin)
	    {
	      int ret;

	      ret = yyparse ();
	      if (ret)
		exit (1);
	      build_prototypes ();
	      free_prototypes ();
	      pclose (yyin);
 	      cpp_cmd_line[ind] = 0;
	    }
	else
	  fprintf (stderr, "%s: Couldn't execute cpp line <%s>, skipping.\n", progname, cpp_cmd_line);
	}
    }
  return 0;
}

extern char yytext[];
extern int column, old_column;
extern int line_number;

yyerror(s)
     char *s;
{
  register int i;
  
  if (0 == strcmp (c_source_file, current_file_name))
    fprintf (stderr, "%s: %s: Syntax error around line %d column %d-%d\n", 
	     progname, current_file_name, line_number, old_column, column);
  else
    fprintf (stderr, "%s: %s: Syntax error in header file <%s> around line %d column %d-%d\n",
	     progname, c_source_file, current_file_name, line_number, old_column, column);
  exit (1);
}
