#include <stdio.h>
#include "tr.h"
#include "li.h"

TRnode *tltail = 0;
TRnode *tlhead = 0;

void
build_prototypes ()
{
  LInode *liproto;
  
  /*  Loop through the list of trees, building a prototype for each
      baby.  */
  for (liproto = li_head; liproto != 0; liproto = liproto->next)
    {
      int done = 0;

      listify (liproto);
      
      if (liproto->comment)
	dump_comment (liproto->comment);
      
      if (0 != liproto->list_decl_spec)
	dump_decl_spec (liproto->list_decl_spec);
      else
	printf ("int ");
      
      if (0 != liproto->list_decl)
	done = dump_decl (liproto->list_decl);
      else
	fprintf (stderr, "ERROR! no Function declaration.");
      
      if (done)
	{
	  printf (");\n");
	  if (liproto->list_decl_list)
	    printf ("/*  The above proto had both types of protos: inline and traditional.  */\n\n");
	}
      else if (0 != liproto->list_decl_list)
	{
	  dump_decl_list (liproto->list_decl_list);
	}
      else
	printf (");\n");

      printf ("\n");
    }
}


listify (linode)
     LInode *linode;
{
  
  if ((TRnode *)0 != linode->decl_spec)
    {
      trav_tree (linode->decl_spec);
      linode->list_decl_spec = tlhead;
      tlhead = (TRnode *) 0;
    }
  else
    linode->list_decl_spec = (TRnode *) 0;

  if ((TRnode *)0 != linode->decl)
    {
      trav_tree (linode->decl);
      linode->list_decl = tlhead;
      tlhead = (TRnode *) 0;
    }
  else
    linode->list_decl = (TRnode *) 0;

  if ((TRnode *)0 != linode->decl_list)
    {
      trav_tree (linode->decl_list);
      linode->list_decl_list = tlhead;
      tlhead = (TRnode *) 0;
    }
  else
    linode->decl_list = (TRnode *) 0;

  return;
}


tladd (node)
     TRnode *node;
{
  if (tlhead == 0)
    {
      tlhead = node;
      tltail = node;
    }
  else
    {
      tltail->list_next = node;
      tltail = node;
    }
}


trav_tree (anode)
     TRnode *anode;
{
  if (0 != anode->left)
    trav_tree (anode->left);
  
  if (anode->type != NOP)
    tladd (anode);
  
  if (0 != anode->right)
    trav_tree (anode->right);
}



free_prototypes ()
{
  
}


dump_comment ()
{
  
}

dump_decl_spec (node)
     TRnode *node;
{
  TRnode *trnode;

  for (trnode = node; trnode != (TRnode *)0; trnode = trnode->list_next)
    {
      printf ("%s ", trnode->pc);
    }
}

dump_decl (node)
     TRnode *node;
{
  int struct_last = 0;
  int typed = 0;

  while (PTR == node->type)
    {
      printf ("*");
      node = node->list_next;
      if ((TRnode *)0 == node)
	{
	  fprintf (stderr, "ACK!!\n");
	  exit (5);
	}
    }

  printf ("%s (", node->pc);
  node = node->list_next;
  
  if (node && node->type == IDENT)
    return 0;
  while ((TRnode *)0 != node)
    {

      printf ("%s", node->pc);
      if (node->type == IDENT && !struct_last && node->list_next != (TRnode *)0)
	printf (", ");
      else 
	printf (" ");
      if (node->type == TYPE)
	typed = 1;
      struct_last = 0;
      if (node->type == LABEL &&
	  (0 == strcmp ("struct", node->pc)
	   || 0 == strcmp ("union", node->pc)
	   || 0 == strcmp ("enum", node->pc)))
	++struct_last; 
      
      node = node->list_next;
    }
  return typed;
}

dump_decl_list (node)
     TRnode *node;
{
  int here = 0;
  int in_struct = 0;

  for (; (TRnode *)0 != node; node = node->list_next)
    {
      if ((here == 2 && in_struct)
	  || (here && !in_struct))
	{
	  printf (", ");
	  in_struct = here = 0;
	}
      printf (" %s", node->pc);
      if (node->type == LABEL &&
	  (0 == strcmp ("struct", node->pc)
	   || 0 == strcmp ("union", node->pc)
	   || 0 == strcmp ("enum", node->pc)))
	++in_struct;

      if (node->type == IDENT)
	++here;
    }
  printf (");\n");
}

