D			[0-9]
O			[0-7]
L			[a-zA-Z_]
H			[a-fA-F0-9]
E			[Ee][+-]?{D}+
FS			(f|F|l|L)
IS			(u|U|l|L)*

%{
#include <stdio.h>
#include <sys/param.h>
#include "y.tab.h"

int s_u_e_last = 0;
void count ();
void comment ();
%}

%%
"/*"			{ comment(); }

"auto"			{ count(0); return(AUTO); }
"break"			{ count(0); return(BREAK); }
"case"			{ count(0); return(CASE); }
"char"			{ count(0); return(CHAR); }
"const"			{ count(0); return(CONST); }
"continue"		{ count(0); return(CONTINUE); }
"default"		{ count(0); return(DEFAULT); }
"do"			{ count(0); return(DO); }
"double"		{ count(0); return(DOUBLE); }
"else"			{ count(0); return(ELSE); }
"enum"			{ count(0); s_u_e_last = 1; return(ENUM); }
"extern"		{ count(0); return(EXTERN); }
"float"			{ count(0); return(FLOAT); }
"for"			{ count(0); return(FOR); }
"goto"			{ count(0); return(GOTO); }
"if"			{ count(0); return(IF); }
"int"			{ count(0); return(INT); }
"long"			{ count(0); return(LONG); }
"register"		{ count(0); return(REGISTER); }
"return"		{ count(0); return(RETURN); }
"short"			{ count(0); return(SHORT); }
"signed"		{ count(0); return(SIGNED); }
"sizeof"		{ count(0); return(SIZEOF); }
"static"		{ count(0); return(STATIC); }
"struct"		{ count(0); s_u_e_last = 1; return(STRUCT); }
"switch"		{ count(0); return(SWITCH); }
"typedef"		{ count(0); return(TYPEDEF); }
"union"			{ count(0); s_u_e_last = 1; return(UNION); }
"unsigned"		{ count(0); return(UNSIGNED); }
"void"			{ count(0); return(VOID); }
"volatile"		{ count(0); return(VOLATILE); }
"while"			{ count(0); return(WHILE); }

{L}({L}|{D})*		{ count(1); return(check_type(yytext)); }

0[xX]{H}+{IS}?		{ count(0); return(CONSTANT); }
0{O}*{IS}?		{ count(0); return(CONSTANT); }
{D}+{IS}?		{ count(0); return(CONSTANT); }
'(\\.|[^\\'])+'		{ count(0); return(CONSTANT); }

{D}+{E}{FS}?		{ count(0); return(CONSTANT); }
{D}*"."{D}+({E})?{FS}?	{ count(0); return(CONSTANT); }
{D}+"."({E})?{FS}?	{ count(0); return(CONSTANT); }

\"(\\.|[^\\"])*\"	{ count(0); return(STRING_LITERAL); }

"..."			{ count(0); return(ELIPSIS); }
">>="			{ count(0); return(RIGHT_ASSIGN); }
"<<="			{ count(0); return(LEFT_ASSIGN); }
"+="			{ count(0); return(ADD_ASSIGN); }
"-="			{ count(0); return(SUB_ASSIGN); }
"*="			{ count(0); return(MUL_ASSIGN); }
"/="			{ count(0); return(DIV_ASSIGN); }
"%="			{ count(0); return(MOD_ASSIGN); }
"&="			{ count(0); return(AND_ASSIGN); }
"^="			{ count(0); return(XOR_ASSIGN); }
"|="			{ count(0); return(OR_ASSIGN); }
">>"			{ count(0); return(RIGHT_OP); }
"<<"			{ count(0); return(LEFT_OP); }
"++"			{ count(0); return(INC_OP); }
"--"			{ count(0); return(DEC_OP); }
"->"			{ count(0); return(PTR_OP); }
"&&"			{ count(0); return(AND_OP); }
"||"			{ count(0); return(OR_OP); }
"<="			{ count(0); return(LE_OP); }
">="			{ count(0); return(GE_OP); }
"=="			{ count(0); return(EQ_OP); }
"!="			{ count(0); return(NE_OP); }
";"			{ count(0); return(';'); }
"{"			{ count(0); return('{'); }
"}"			{ count(0); return('}'); }
","			{ count(0); return(','); }
":"			{ count(0); return(':'); }
"="			{ count(0); return('='); }
"("			{ count(0); return('('); }
")"			{ count(0); return(')'); }
"["			{ count(0); return('['); }
"]"			{ count(0); return(']'); }
"."			{ count(0); return('.'); }
"&"			{ count(0); return('&'); }
"!"			{ count(0); return('!'); }
"~"			{ count(0); return('~'); }
"-"			{ count(0); return('-'); }
"+"			{ count(0); return('+'); }
"*"			{ count(0); return('*'); }
"/"			{ count(0); return('/'); }
"%"			{ count(0); return('%'); }
"<"			{ count(0); return('<'); }
">"			{ count(0); return('>'); }
"^"			{ count(0); return('^'); }
"|"			{ count(0); return('|'); }
"?"			{ count(0); return('?'); }
"#"                     { count(0); cpp_symbol ();  }
[ \t\v\n\f]		{  count (1); }
.			{ /* ignore bad characters */ }

%%

#define EATWHITE   do  {  c = input ();  }  while ( c != 0 && isspace (c))

char current_file_name[MAXPATHLEN];
int line_number = 1;
int column = 0, old_column = 0;
int comment_counter = 0;
int real_token = 0;
char *comment_buffer;
int comment_buffer_size = 0;

void
comment()
{
  char c, c1;

  if (real_token)
    comment_counter = 0;

  if (comment_buffer_size <= comment_counter)
    {
      if (comment_buffer_size == 0)
        comment_buffer_size = 1024;
      else
       comment_buffer_size *= 2;
      
      grow_buffer (&comment_buffer, comment_buffer_size);
    }

  do 
    {
      while ((c = input()) != '*' && c != 0)
	{
	  comment_buffer[comment_counter++] = c;
	  if (comment_buffer_size == comment_counter)
	    {
	      comment_buffer_size *= 2;
	      grow_buffer (&comment_buffer, comment_buffer_size + 2);
	    }
	}

      if (c != 0 && (c1 = input()) != '/' && c1 != 0)
	comment_buffer[comment_counter++] = c;
    }
  while (c != 0 && c1 != 0 && c1 != '/');

  comment_buffer[comment_counter++] = '\t';
}


void 
count(k)
  int k;
{
  int i;

  if (k == 0)
    {
      s_u_e_last = 0;
      real_token = 1;
    }
  old_column = column;
  for (i = 0; yytext[i] != '\0'; i++)
    if (yytext[i] == '\n')
      {
	column = 0;
	++line_number;
      }
    else if (yytext[i] == '\t')
      column += 8 - (column % 8);
    else
      ++column;
}

int check_type(pc)
char *pc;
{
  int i;
  extern int number_user_defined_types;
  extern char **user_defined_types;

  if (s_u_e_last)
    { 
      s_u_e_last = 0;
      return IDENTIFIER;
    }

  for (i = 0; i < number_user_defined_types; i++)
    if (0 == strcmp (pc, user_defined_types[i]))
    { /* printf ("\tRETURN TYPENAME\t");*/
      return TYPE_NAME;  }

  return IDENTIFIER;
}

cpp_symbol ()
{
  char c, oldc;
  int i;
  char digit[32];


  /*  There are a number of formats... */
  /*  Here we just handle "# line_no filename"  */
  EATWHITE;
  i = 0;
  do 
    {
      digit[i++] = c;
      c = input ();
    }
  while ( isdigit (c));
  digit[i] = 0;
  line_number = atoi (digit);

  EATWHITE;
  if ('"' == c)
    c = input ();
  i = 0;
  do
    {
      current_file_name[i++] = c;
      c = input ();
    } while (c != '"' && !isspace (c) && c != 0);
  current_file_name[i] = NULL;

  do {
    while ((c = input ()) != '\n' && c != 0)
      oldc = c;
    } 
  while (oldc == '\\');

/*  ++line_number; */
  return;
  
}

yywrap()
{
  return(1);
}




