#include <errno.h>
#include <stdio.h>
#include "criterr.h"

/* example program to test critical error trap routine */
/* link in module criterr.obj, or add to library */
/* for buffered i/o devices, better flush them otherwise errors */
/* will be delayed until buffer gets written */

/* WRITTEN BY PETER HYMAN, (609) 799-2638 */

void disp_cerr( void );                          /* function to display critical error */

main()
{
	int i;
	FILE *fp;

	i = criterr( 1 );                              /* trap critical error */
	fputs( "abcde", stdprn );
	fflush ( stdprn );       		                   /* TAKE PRINTER OFF LINE */
	if ( cerr.ceflag )
			disp_cerr();                               /* show error */

	clrcriterr();                                  /* clear structure */

	if ( ( fp = fopen( "a:junk", "w" ) ) == NULL ) /* OPEN DRIVE A DOOR OR PUT A DISK IN */
	{
		if ( cerr.ceflag )
				disp_cerr();                             /* show error */
		else if ( errno )                            /* see if file not found error or such */
				printf( "Non Critical Error %d -- %s\n", errno, os_errlist[errno] );
	}
	if ( criterr( 1 ) )                            /* try to turn it on again */
			printf( "Critical error handler already installed\n" );

	printf( "Critical error trap is now turned off.\n");
	i = criterr( 0 );                              /* remove trap */

	/* now a critical error will be generated by DOS */
	fp = fopen( "a:junk", "w" );
}

/*****************************************************************************
 *                          --- void disp_cerr ---
 *
 * FUNCTION:	DISPLAYS CRITICAL ERROR AND RELATED MESSAGES
 *****************************************************************************/
void disp_cerr()
{
   printf(
"                        Critical error: %2d -- %s\n\
Critical Error Code in AX (ret by DOS): %X\n\
                           Device Name: %8s\n\
                                 Drive: %c:\n\
                         READ or WRITE: %2d -- %s\n\
                    DISK Area of Error: %2d -- %s\n\
                         Response Mask: %2d -- %s\n\
      Extended Error Number (Dos >= 3): %2d -- %s\n\
                           Error Class: %2d -- %s\n\
  Error Recovery Action Recommendation: %2d -- %s\n\
                           Error Locus: %2d -- %s\n\n",
cerr.cerrno, crit_errlist[cerr.cerrno], cerr.cerrtype,
cerr.name,cerr.drive,
cerr.read_wr, readwr_list[cerr.read_wr],
cerr.disk_area, diskarea_list[cerr.disk_area],
cerr.resp_mask, respmask_list[cerr.resp_mask],
cerr.exterr,os_errlist[cerr.exterr],
cerr.eclass,err_classlist[cerr.eclass],
cerr.action, err_actionlist[cerr.action],
cerr.locus, err_locuslist[cerr.locus] );
}

