/* HEADER FILE CRITERR.H
 *
 * FOR USE WITH ALERNATE CRITICAL ERROR HANDLER
 *
 * BY PETER HYMAN
 *
 * modified 2/16/91 to change structure CE and make small descriptive
 * changes to the arrays
 */

#ifndef __CERR_H
#define __CERR_H
extern struct CE
{
	unsigned char ceflag;                          /* critical error flag 1=yes */
	unsigned char cerrno;                          /* critical error number */
	int cerrtype;                                  /* critical error type, returned by AX */
	unsigned char	drive;    					             /* drive letter of error */
	unsigned char	read_wr;                         /* read or write error */
	unsigned char	disk_area;                       /* where on disk, 0 = DOS, 1 = FAT, 2 = DIR, 3 = DATA */
	unsigned char	resp_mask;                       /* really a pad, but shows allowable responses ( see tech ref ) */
	unsigned char	exterr;                          /* extended error number  DOS >= 3 */
  unsigned char eclass;	                         /* error class */
  unsigned char action;	                         /* action recommendations */
  unsigned char locus ;                          /* location of error */
  long nextdev;	                                 /* long pointer to next device */
  short attr;	                                   /* device attributes */
  short sfunc;	                                 /* short pointer to strategy function */
  short ifunc;	                                 /* short pointer to interrupt function */
  char name[8];                                  /* device name */
	char dummy;																		 /* terminating null */
} cerr;                                          /* critical error struct */

/* function prototypes for setting of critical error trap */

extern int criterr( int );
extern void clrcriterr( void );

/* THE FOLLOWING ARRAYS OF ERRORS ARE COMPLETE LISTINGS OF ALL
 * ERRORS REPORTED BY DOS.  THEY CORRESPOND TO THE EXTENDED ERROR
 * NUMBERS ( AND IN THE CASE OF OS_ERRLIST, TO ERRNO, UP TO #18 )
 * THESE ARRAYS MAY BE OMITTED FROM FILES IF THEY ARE NOT NEEDED
 */

/* Critical Error Messages: use cerr.cerrno as index */

char *crit_errlist[] =
{
/* 00h */     "Write Protect Error",
/* 01h */     "Invalid Drive Specified",
/* 02h */     "Drive Not Ready",
/* 03h */     "Invalid Command",
/* 04h */     "CRC Error",
/* 05h */     "Bad Request Structure Length",
/* 06h */     "Seek Error",
/* 07h */     "Unknown Medium",
/* 08h */     "Sector Not Found",
/* 09h */     "Printer Out Of Paper",
/* 0ah */     "Write Error",
/* 0bh */     "Read Error",
/* 0ch */     "General Failure"
};

int num_criterr = sizeof( crit_errlist ) / sizeof( crit_errlist[0] );

/* Read/Write Errors: use cerr.read_wr as index */

char *readwr_list[] =
{
/* 00 */    "Reading",
/* 01 */    "Writing"
};

/* DISK Area Errors: use cerr.disk_area as index */

char *diskarea_list[] =
{
/* 00 */    "DOS/System Area",
/* 01 */    "FAT Area",
/* 02 */    "Directory Area",
/* 03 */    "Data Area"
};

char *respmask_list[] =
{
/* 00 */    "Abort Suggested",
/* 01 */    "Abort or Fail Allowed",
/* 02 */    "Abort or Retry Allowed",
/* 03 */    "Abort, Retry or Fail Allowed",
/* 04 */    "Abort or Ignore Allowed",
/* 05 */    "Abort, Fail or Ignore Allowed",
/* 06 */    "Abort, Retry or Ignore Allowed",
/* 07 */    "Abort, Fail, Retry or Ignore Allowed"
};

/* Operating System Errors: use cerr.exterr as index */
/* or from errno if not critical error */

char *os_errlist[] =
{
/* 00 */		"Unknown Error Code",
/* 01 */		"Invalid Function Number",
/* 02 */		"File Not Found",
/* 03 */		"Path Not Found",
/* 04 */		"Too Many Files Opened",
/* 05 */		"Access Denied",
/* 06 */		"Invalid Handle",
/* 07 */		"Memory Control Blocks Destroyed",
/* 08 */		"Insufficient Memory",
/* 09 */		"Invalid Memory Block Address",
/* 10 */		"Invalid Environment",
/* 11 */		"Invalid Format",
/* 12 */		"Invalid Access Code",
/* 13 */		"Invalid Data",
/* 14 */		"Error 14",
/* 15 */		"Invalid Drive Code",
/* 16 */		"Can't Remove Current Directory",
/* 17 */		"Not Same Device",
/* 18 */		"No More Files",
/* 19 */		"Can't Write on Protected Device",
/* 20 */		"Unknown Unit",
/* 21 */		"Drive Not Ready",
/* 22 */		"Unknown Command",
/* 23 */		"Data Error (CRC)",
/* 24 */		"Bad Request Structure Length",
/* 25 */		"Seek Error",
/* 26 */		"Unknown Media Type",
/* 27 */		"Sector Not Found",
/* 28 */		"Printer Out Of Paper",
/* 29 */		"Write Fault",
/* 30 */		"Read Fault",
/* 31 */		"General Failure",
/* 32 */		"Sharing Violation",
/* 33 */		"Lock Violation",
/* 34 */		"Invalid Disk Change",
/* 35 */		"FCB Unavailable",
/* 36 */		"Sharing Buffer Overflow",
/* 37 */		"Error 37",
/* 38 */		"Error 38",
/* 39 */		"Error 39",
/* 40 */		"Error 40",
/* 41 */		"Error 41",
/* 42 */		"Error 42",
/* 43 */		"Error 43",
/* 44 */		"Error 44",
/* 45 */		"Error 45",
/* 46 */		"Error 46",
/* 47 */		"Error 47",
/* 48 */		"Error 48",
/* 49 */		"Error 49",
/* 50 */		"Network Request Not Supported",
/* 51 */		"Remote Computer Not Listening",
/* 52 */		"Duplicate Name on Network",
/* 53 */		"Network Name Not Found",
/* 54 */		"Network Busy",
/* 55 */		"Network Device No Longer Exists",
/* 56 */		"Net BIOS Command Limit Exceeded",
/* 57 */		"Network Adaptor Hardware Error",
/* 58 */		"Incorrect Response from Network",
/* 59 */		"Unexpected Network Error",
/* 60 */		"Incompatible Remote Adaptor",
/* 61 */		"Print Queue Full",
/* 62 */		"Not Enough Space for Print File",
/* 63 */		"Print File was Deleted",
/* 64 */		"Network Name was Deleted",
/* 65 */		"Access Denied",
/* 66 */		"Incorrect Network Device Type",
/* 67 */		"Network Name not Found",
/* 68 */		"Network Name Limit Exceeded",
/* 69 */		"Net BIOS Session Limit Exceeded",
/* 70 */		"Temporarily Paused",
/* 71 */		"Network Request not Accepted",
/* 72 */		"Print or Disk Redirection is Paused",
/* 73 */		"Error 73",
/* 74 */		"Error 74",
/* 75 */		"Error 75",
/* 76 */		"Error 76",
/* 77 */		"Error 77",
/* 78 */		"Error 78",
/* 79 */		"Error 79",
/* 80 */		"File Exists",
/* 81 */		"Error 81",
/* 82 */		"Cannot Make Directory Entry",
/* 83 */		"Fail on INT 24",
/* 84 */		"Too Many Redirections",
/* 85 */		"Duplicate Redirection",
/* 86 */		"Invalid Password",
/* 87 */		"Invalid Parameter",
/* 88 */		"Network Device Fault"
};

int num_oserr = sizeof( os_errlist ) / sizeof( os_errlist[0] );

/* Error Classes: use cerr.eclass as index */

char *err_classlist[] =
{
/* 00h */	"Unknown",
/* 01h */	"Out of Resource",
/* 02h */ "Temporary Situation",
/* 03h */	"Authorization",
/* 04h */	"Internal Error",
/* 05h */	"Hardware Failure",
/* 06h */	"System Failure",
/* 07h */	"Application Program Error",
/* 08h */	"Not Found",
/* 09h */	"Bad Format",
/* 0ah */	"Locked Item",
/* 0bh */	"Media Failure",
/* 0ch */	"Already Exists",
/* 0dh */	"Unknown"
};

int num_errclass = sizeof( err_classlist ) / sizeof( err_classlist[0] );

/* Error Actions: use cerr.action as index */

char *err_actionlist[] =
{
/* 00 */ "Unknown",
/* 01 */ "Retry",
/* 02 */ "Delay Retry",
/* 03 */ "User Input",
/* 04 */ "Abort",
/* 05 */ "Immediate Exit",
/* 06 */ "Ignore",
/* 07 */ "Retry after User Intervention"
};

int num_erraction = sizeof( err_actionlist ) / sizeof( err_actionlist[0] );

/* Error Loci: use cerr.locus as index */

char *err_locuslist[] =
{
/* 00 */ "Unknown",
/* 01 */ "Unknown",
/* 02 */ "Block Device",
/* 03 */ "Network",
/* 04 */ "Serial Device",
/* 05 */ "Memory"
};

int num_errlocus = sizeof( err_locuslist ) / sizeof( err_locuslist[0] );

#endif

/* end of header */
