;
; assembly language functions for C programs to use the
; multi-tasking features of Cswitch
;

p1 = 6
p2 = 8
p3 = 10
p4 = 12

;
; cswitch INT62 functions
;
; 1  = relinqush rest of our time slice
; 2  = wait for semaphore
; 3  = check semaphore
; 4  = trigger semaphore
; 5  = sleep
; 6  = suspend
; 7  = spawn
; 8  = wake up a task
; 10 = test message queue
; 11 = send message
; 12 = read message
; 13 = don't allow task to be swapped out
; 14 = allow swapping again
; 15 = load and run a program from disk
; 16 = terminate a spawned program
; 17 = get tcb information
; 18 = get tcb address
; 19 = check status of previous load_task call
;


mt_cint_text    segment word public 'CODE'
        assume  cs:mt_cint_text

    public _relinq
    public _spawn
    public _loadtask
    public _sleep
    public _send_md_msg
    public _testmsg
    public _recvmsg
    public _sem_attach
    public _sem_release
    public _sem_test
    public _setpri
    public _suspend
    public _wakeup
    public _hog
    public _nohog
    public _spawn_exit
    public _get_tcb_info
    public _get_tcb_address
    public _get_load_status

    
_relinq  proc    far
    mov ah,1
    int 62h
    ret
_relinq endp


_get_load_status  proc    far
    mov ah,19
    int 62h
    ret
_get_load_status endp

_spawn_exit proc far
    mov ah,16
    int 62h
    ret
_spawn_exit endp

_hog  proc    far
    mov ah,13
    int 62h
    ret
_hog endp

_nohog  proc    far
    mov ah,14
    int 62h
    ret
_nohog endp

_spawn  proc    far
    push    bp
    mov     bp,sp
    push    es
    push    bx
    push    cx
    mov     bx,[bp+6]   ;offset
    mov     ax,[bp+8]   ;segment
    mov     es,ax
    mov     cx,[bp+10]
    mov     ah,7
    int     62h
    pop     cx
    pop     bx
    pop     es
    pop     bp
    ret
_spawn  endp

_get_tcb_info  proc    far
    push    bp
    mov     bp,sp
    push    es
    push    bx
    mov     bx,[bp+6]   ;offset
    mov     ax,[bp+8]   ;segment
    mov     es,ax
    mov     ah,17
    int     62h
    pop     bx
    pop     es
    pop     bp
    ret
_get_tcb_info  endp

_get_tcb_address  proc    far
    push    bp
    mov     bp,sp
    push    es
    push    bx
    mov     bx,[bp+6]   ;offset
    mov     ax,[bp+8]   ;segment
    mov     es,ax
    mov     ah,18
    int     62h
    pop     bx
    pop     es
    pop     bp
    ret
_get_tcb_address  endp

_loadtask  proc    far
    push    bp
    mov     bp,sp
    push    es
    push    bx
    push    cx
    push    dx
    mov     bx,[bp+6]   ;offset of command line
    mov     ax,[bp+8]   ;segment
    mov     es,ax
    mov     cx,[bp+10]  ;priority
    mov     dx,[bp+12]  ;background flag - if non-0, allows loading to ems
    mov     ah,15
    int     62h
    pop     dx
    pop     cx
    pop     bx
    pop     es
    pop     bp
    ret
_loadtask  endp

; params = how many ticks
_sleep  proc    far
    push    bp
    mov     bp,sp
    push    bx
    mov     bx,[bp+6]
    mov     ah,5
    int     62h
    pop     bx
    pop     bp
    ret
_sleep   endp


_suspend  proc    far
    mov     ah,6
    int     62h
    ret
_suspend   endp

;params = task to wake up
_wakeup  proc    far
    push    bp
    mov     bp,sp
    push    bx
    mov     bx,[bp+6]
    mov     ah,8
    int     62h
    pop     bx
    pop     bp
    ret
_wakeup   endp


; params = new priority
_setpri  proc    far
    push    bp
    mov     bp,sp
    push    bx
    mov     bx,[bp+6]
    mov     ah,9
    int     62h
    pop     bx
    pop     bp
    ret
_setpri   endp

_sem_attach    proc far
    push    bp
    mov     bp,sp
    push    dx
    mov     dx,[bp+6]
    mov     ah,2
    int     62h
    pop     dx
    pop     bp
    ret
_sem_attach    endp

_sem_test    proc far
    push    bp
    mov     bp,sp
    push    dx
    mov     dx,[bp+6]
    mov     ah,3
    int     62h
    pop     dx
    pop     bp
    ret
_sem_test    endp

_sem_release    proc far
    push    bp
    mov     bp,sp
    push    dx
    mov     dx,[bp+6]
    mov     ah,4
    int     62h
    pop     dx
    pop     bp
    ret
_sem_release    endp

_testmsg  proc far
    push    bp
    mov     bp,sp
    push    dx
    mov     dx,[bp+6]   ;queue number to check
    mov     ah,10
    int     62h
    pop     dx
    pop     bp
    ret
_testmsg      endp

_send_md_msg    proc far
    push    bp
    mov     bp,sp
    push    dx
    push    ds
    push    si
    push    cx
    mov     si,[bp+8]  ;offset for data buffer
    mov     ax,[bp+10]   ;segment for data buffer
    mov     ds,ax
    mov     cx,[bp+12]  ;length
    mov     dx,[bp+6]   ;queue number to read from
    mov     ah,11
    int     62h
    pop     cx
    pop     si
    pop     ds
    pop     dx
    pop     bp
    ret
_send_md_msg    endp

_recvmsg    proc far
    push    bp
    mov     bp,sp
    push    dx
    push    ds
    push    si
    push    cx
    mov     si,[bp+8]  ;offset for data buffer
    mov     ax,[bp+10]   ;segment for data buffer
    mov     ds,ax
    mov     cx,[bp+12]  ;length
    mov     dx,[bp+6]   ;queue number to read from
read2:
    mov     ah,12
    int     62h
    cmp     ax,0fffeh   ;if -2 (0fffeh) is returned, then we have been
                        ;triggered by something arriving on queue, and we
                        ;must make the 'read' call again to retrieve it
    jz      read2
    pop     cx
    pop     si
    pop     ds
    pop     dx
    pop     bp
    ret
_recvmsg    endp

mt_cint_text    ends
        end
    
