/*
** This is a demonstration program for CSWITCH multitasking library.
** Copyright 1990 by Herb Rose
*/

#include "stdio.h"
#include "tcb.h"

extern struct tcb_rec tcb[];
extern int swap_count;
extern int readyq, swapq;
extern int extmem_pages, exmemfree;
extern int mapsize, swap_segment;
extern int idletask2tcb;
extern unsigned int totfreemem;
extern int dos48, dos49, dos4a, dos1a, dos2f;

char msgbuf[1024];

char *tasks[5]={
    "test1.exe","test2.exe","test3.exe","test4.exe","test5.exe" };

int taskidx;

main(argc, argv) int argc; char *argv[];
{
    int k,j,n,m;
    int mf;
    int t[16];
    int noswap;

    noswap=0;
    if(argc > 1)
    {
        if(tolower(argv[1][0])=='n') noswap=1;
    }
    for(k=0; k<10; k++) t[k]=0;

    puts("Multitasking test.\nPress any key to end.");
    start_mt();
    if(!noswap) j=start_swapping();
    printf("Mapsize = %d   swap_segment= %04x\n",mapsize,swap_segment);
    printf("extmem_pages = %uP     exmemfree = %uP\n",extmem_pages,exmemfree);
    findlargemem();
    printf("Memory available = %u paras\n",totfreemem);

    loadprg("test1.exe",3,1);
    loadprg("test2.exe",4,1);
    loadprg("test3.exe",5,1);
    loadprg("test4.exe",6,1);
    loadprg("test5.exe",7,1);
    taskidx=0;

    k=0;

    while(!kbhit())
    {
        while(testmsg(1)>0)
        {
            if(kbhit()) break;
            n=recvmsg(1,msgbuf,1000);
            if(strncmp("test",msgbuf,4)!=0)
            {
                puts(msgbuf);
                continue;
            }
            j=msgbuf[4] & 0xf;
            t[j]++;
            msgbuf[5]='\0';
            printf("%5d:%s t1=%-4d t2=%-4d t3=%-4d t4=%-4d t5=%-4d\n",
                ++k,msgbuf,t[1],t[2],t[3],t[4],t[5]);
            taskidx=j-1;
            if((taskidx >=0) && (taskidx <5))
            {
                while((m=loadprg(tasks[taskidx],j+2,j&1)) < 0)
                {
                    printf("%d error loading %s\n",m,tasks[taskidx]);
                }
            }
        }
        relinq();
    }
    getch();
    end_mt();
}

