;
; assembly language functions for C programs to use the
; multi-tasking features of Cswitch
; small memory model
;

_DATA SEGMENT WORD PUBLIC 'DATA'
_DATA ENDS

_TEXT SEGMENT WORD PUBLIC 'CODE'
  ASSUME CS:_TEXT
  ASSUME DS:_DATA


p1 = 4
p2 = 6
p3 = 8
p4 = 10

;
; Cswitch function codes (int62)
;
; 1  = relinqush rest of our time slice
; 2  = wait for semaphore
; 3  = check semaphore
; 4  = trigger semaphore
; 5  = sleep
; 6  = suspend
; 7  = spawn
; 8  = wake up a task
; 10 = test message queue
; 11 = send message
; 12 = read message
; 13 = don't allow task to be swapped out
; 14 = allow swapping again
; 15 = load and run a program from disk
; 16 = terminate a spawned program
; 17 = get tcb information
; 18 = get tcb address
; 19 = check status of previous load_task
;

    public _relinq
    public _spawn
    public _loadtask
    public _sleep
    public _send_md_msg
    public _testmsg
    public _recvmsg
    public _sem_attach
    public _sem_release
    public _sem_test
    public _setpri
    public _suspend
    public _wakeup
    public _hog
    public _nohog
    public _spawn_exit
    public _get_tcb_info
    public _get_tcb_address
    public _get_load_status
    
_relinq  proc    near
    mov ah,1
    int 62h
    ret
_relinq endp

_get_load_status  proc    near
    mov ah,19
    int 62h
    ret
_get_load_status endp

_spawn_exit proc near
    mov ah,16
    int 62h
    ret
_spawn_exit endp

_hog  proc    near
    mov ah,13
    int 62h
    ret
_hog endp

_nohog  proc    near
    mov ah,14
    int 62h
    ret
_nohog endp

_spawn  proc    near
    push    bp
    mov     bp,sp
    push    es
    push    bx
    push    cx
    mov     bx,[bp+4]   ;offset
    mov     ax,cs   ;segment
    mov     es,ax
    mov     cx,[bp+6]   ;priority
    mov     ah,7
    int     62h
    pop     cx
    pop     bx
    pop     es
    pop     bp
    ret
_spawn  endp

_get_tcb_info  proc    near
    push    bp
    mov     bp,sp
    push    es
    push    bx
    mov     bx,[bp+4]   ;offset
    mov     ax,ds       ;segment
    mov     es,ax
    mov     ah,17
    int     62h
    pop     bx
    pop     es
    pop     bp
    ret
_get_tcb_info  endp

_get_tcb_address  proc    near
    push    bp
    mov     bp,sp
    push    es
    push    bx
    mov     bx,[bp+4]   ;offset
    mov     ax,ds       ;segment
    mov     es,ax
    mov     ah,18
    int     62h
    pop     bx
    pop     es
    pop     bp
    ret
_get_tcb_address  endp


_loadtask  proc    near
    push    bp
    mov     bp,sp
    push    es
    push    bx
    push    cx
    push    dx
    mov     bx,[bp+4]   ;offset of command line
    mov     ax,ds   ;segment
    mov     es,ax
    mov     cx,[bp+6]   ;priority
    mov     dx,[bp+8]  ;background flag - if non-0, allows loading to ems
    mov     ah,15
    int     62h
    pop     dx
    pop     cx
    pop     bx
    pop     es
    pop     bp
    ret
_loadtask  endp

; params = how many ticks
_sleep  proc    near
    push    bp
    mov     bp,sp
    push    bx
    mov     bx,[bp+4]
    mov     ah,5
    int     62h
    pop     bx
    pop     bp
    ret
_sleep   endp


_suspend  proc    near
    mov     ah,6
    int     62h
    ret
_suspend   endp

;params = task to wake up
_wakeup  proc    near
    push    bp
    mov     bp,sp
    push    bx
    mov     bx,[bp+4]
    mov     ah,8
    int     62h
    pop     bx
    pop     bp
    ret
_wakeup   endp


; params = new priority
_setpri  proc    near
    push    bp
    mov     bp,sp
    push    bx
    mov     bx,[bp+4]
    mov     ah,9
    int     62h
    pop     bx
    pop     bp
    ret
_setpri   endp

_sem_attach    proc near
    push    bp
    mov     bp,sp
    push    dx
    mov     dx,[bp+4]
    mov     ah,2
    int     62h
    pop     dx
    pop     bp
    ret
_sem_attach    endp

_sem_test    proc near
    push    bp
    mov     bp,sp
    push    dx
    mov     dx,[bp+4]
    mov     ah,3
    int     62h
    pop     dx
    pop     bp
    ret
_sem_test    endp

_sem_release    proc near
    push    bp
    mov     bp,sp
    push    dx
    mov     dx,[bp+4]
    mov     ah,4
    int     62h
    pop     dx
    pop     bp
    ret
_sem_release    endp

_testmsg  proc near
    push    bp
    mov     bp,sp
    push    dx
    mov     dx,[bp+4]   ;queue number to check
    mov     ah,10
    int     62h
    pop     dx
    pop     bp
    ret
_testmsg      endp

_send_md_msg    proc near
    push    bp
    mov     bp,sp
    push    dx
    push    ds
    push    si
    push    cx
    mov     si,[bp+6]  ;offset for data buffer
                       ;ds already must point to data
    mov     cx,[bp+8]  ;length
    mov     dx,[bp+4]   ;queue number to read from
    mov     ah,11
    int     62h
    pop     cx
    pop     si
    pop     ds
    pop     dx
    pop     bp
    ret
_send_md_msg    endp

_recvmsg    proc near
    push    bp
    mov     bp,sp
    push    dx
    push    ds
    push    si
    push    cx
    mov     si,[bp+6]  ;offset for data buffer
    mov     cx,[bp+8]  ;length
    mov     dx,[bp+4]   ;queue number to read from
read2:
    mov     ah,12
    int     62h
    cmp     ax,0fffeh   ;if -2 (0fffeh) is returned, then we have been
                        ;triggered by something arriving on queue, and we
                        ;must make the 'read' call again to retrieve it
    jz      read2
    pop     cx
    pop     si
    pop     ds
    pop     dx
    pop     bp
    ret
_recvmsg    endp

_TEXT ENDS
        end
    
