Date: Tue, 12 Jul 88 17:45:08 cdt
From: wucs1!wubios!david@uunet.UU.NET (David Camp)
Subject: CWD.C

*-------------------------------------------------------------------------*
| (314) 362-3635                     Mr. David J. Camp                    |
| Room 1108D               ^         Box 8067, Biostatistics              |
| 706 South Euclid       < * >       Washington University Medical School |
|                          v         660 South Euclid                     |
| Bitnet: david%wubios@wucfua.wustl  Saint Louis, MO 63110                |
| Internet: david%wubios@wucfua.wustl.edu                                 |
*-------------------------------------------------------------------------*

/* CWD.C -- program to implement Kermit-like CWD command for MS-Dos */
/* Written by David J. Camp, Washington University Division of Biostatistics */
/* 1988 for Microsoft C 5.0 */

/*
     I have sent you CWD.C and CWD.EXE.  CWD works much like the Kermit
CWD command.  It lets you change both the drive and the directory with one
command.  Its main advantage is that it allows a trailing slash '/' or
backslash 'c' after the specified path.  This allows for easier MAKE
files.  If you have a MAKE macro defined to be a pathname, you may wish to
do several things with it.  For instance, you may wish to change
directories, or append it to a file name.  If you append it to a file
name, you must insert an intervening backslash.  If the selected directory
is the root, you will wind up with two backslashes.  An alternate method
is to end all pathnames with a backslash.  Then appending to filenames
works (without the intervening backslash), but you cannot change
directories.  CWD solves that problem by allowing an optional trailing
backslash in the selected pathname.  I believe CWD will allow the use of
slashes instead of backslashes in the pathname.  Enjoy!

*-------------------------------------------------------------------------*
| (314) 362-3635                     Mr. David J. Camp                    |
| Room 1108D               ^         Box 8067, Biostatistics              |
| 706 South Euclid       < * >       Washington University Medical School |
|                          v         660 South Euclid                     |
| Bitnet: david%wubios@wucfua.wustl  Saint Louis, MO 63110                |
| Internet: david%wubios@wucfua.wustl.edu                                 |
*-------------------------------------------------------------------------*

*/

#include <readable.h>   /* See below */
#include <stdio.h>
#include <direct.h>
#include <dos.h>

main (argc, argv)
int argc;
char * argv [];

begin
char path [256];        /* holds path for getcwd */
int drive;              /* integer drive number */
unsigned drives;        /* holds number of drives returned from _dos_setdrive */
int pathlen;            /* length of specified path minus one */

/* if no arguments is given then */
if (argc eq 1)
    begin
    /* type the current drive and directory. */
    fprintf (stdout, "%s\n", getcwd (path, 256));
    end
/* Else if one argument is given then */
else if (argc eq 2)
    begin
    /* Allow trailing slashes. */
    pathlen = strlen (argv [1]) - 1;
    if (argv [1] [pathlen] eq '\\' or argv [1] [pathlen] eq '/')
        if (pathlen > 0 and argv [1] [pathlen - 1] != ':')
            argv [1] [pathlen] = '\0';
    /* Change to the new directory. */
    chdir (argv[1]);
    /* If the drive is specified then */
    if (argv [1] [1] eq ':')
        begin
        /* also change the drive. */
        drive = argv [1] [0];
        /* One must calculate the drive number from the drive letter. */
        if ('A' <= drive and drive <= 'Z' or 'a' <= drive and drive <= 'z')
            begin
            /* If lower case then */
            if ('a' <= drive)
                /* convert to upper case. */
                drive = drive - 32;
            /* Convert to drive number. */
            drive = drive - 64;
            /* MSC 5.0 routine to change the current drive is _dos_setdrive */
            _dos_setdrive (drive, &drives);
            end
        /* else drive name is invalid */
        else
            begin
            /* Type a message and quit. */
            fprintf (stderr,"Drive name must be a letter\n");
            exit (1);
            end
        end
    end
/* else there are greater than one arguments. */
else
    begin
    /* Type a message and quit. */
    fprintf (stderr, "usage: CWD d:path\n");
    exit (1);
    end
/* This is the normal exit for when everything goes right. */
exit (0);
end
/* readable.h is as follows:
#define begin {
#define end }
#define and &&
#define or ||
#define not !
#define eq ==
*/
