#include "stdio.h"
#include "mw.h"

main ()

{
int loop;

mw_open ("EXAMPLE");    /* create document EXAMPLE.TXT */
mw_font (3);            /* for HP LaserJet III: Univers */
mw_fontsize (16.0);     /* 16 point pitch */

/* next line without any special formatting */
mw_printf ("A completely normal line\n");

/* some paragraph formatting for the 2nd paragraph */
mw_spacing (MW_LINE_SPACING, MW_AUTO);
mw_spacing (MW_SPACE_BEFORE, 1.0);    /* 1 line before and after */
mw_spacing (MW_SPACE_AFTER, 1.0);
mw_spacing (MW_LEFT, 0.6);            /* all indentions in inch */
mw_spacing (MW_FIRST_LINE, 0.7);
mw_spacing (MW_RIGHT, 0.8);
mw_printf ("The second line is pretty strange\n");

/* reset the strange values of preceeding paragraph */
mw_spacing (MW_LINE_SPACING, 3.0);     /* three lines spacing */
mw_spacing (MW_SPACE_BEFORE, 0.0);
mw_spacing (MW_SPACE_AFTER, 1.0);
mw_spacing (MW_LEFT, 0.0);
mw_spacing (MW_FIRST_LINE, 0.0);
mw_spacing (MW_RIGHT, 0.0);

mw_printf ("Now character formats: ");

mw_char (MW_BOLD, ON);
mw_printf ("bold, ");
mw_char (MW_BOLD, OFF);

mw_char (MW_ITALIC, ON);
mw_printf ("italic, ");
mw_char (MW_ITALIC, OFF);

mw_char (MW_UNDERLINE, ON);
mw_printf ("underline, ");
mw_char (MW_UNDERLINE, OFF);

mw_char (MW_STRIKETHROUGH, ON);
mw_printf ("strikethrough, ");
mw_char (MW_STRIKETHROUGH, OFF);

mw_char (MW_UPPERCASE, ON);
mw_printf ("upper case, ");
mw_char (MW_UPPERCASE, OFF);

mw_char (MW_SMALLCAPS, ON);
mw_printf ("small Caps, ");
mw_char (MW_SMALLCAPS, OFF);

mw_char (MW_DOUBLE_UNDERLINE, ON);
mw_printf ("double underline, ");
mw_char (MW_DOUBLE_UNDERLINE, OFF);

mw_char (MW_HIDDEN, ON);
mw_printf ("hidden, ");
mw_char (MW_HIDDEN, OFF);

mw_char (MW_ITALIC, ON);
mw_char (MW_BOLD, ON);
mw_char (MW_UNDERLINE, ON);
mw_printf ("together: italic/bold/underline\n");
mw_char (MW_ITALIC, OFF);
mw_char (MW_BOLD, OFF);
mw_char (MW_UNDERLINE, OFF);

mw_char (MW_SUPERSCRIPT, ON);
mw_printf ("superscript, ");
mw_char (MW_SUBSCRIPT, ON);      /* turns off SUPERSCRIPT */
mw_printf ("subscript, ");
mw_char (MW_SUBSCRIPT, OFF);
mw_printf ("normal\n");

/* some settings for division and page format */
/* could appear anywhere in the program */

mw_division (MW_PAGE_NUMBERS, ON);
mw_division (MW_PAGE_NUMBER_FORMAT, 'I');
mw_division (MW_PAGE_NUMBER_START, 15);

mw_division (MW_LINE_NUMBERS, ON);
mw_division (MW_LINE_NUMBER_RESTART, MW_PAGE);
mw_division (MW_LINE_NUMBER_INCREMENT, 2);

mw_division (MW_COLUMNS, 2);             /* two column text */

mw_page (MW_LENGTH, 11.0);
mw_page (MW_WIDTH, 9.0);
mw_page (MW_MARGIN_TOP, 0.8);
mw_page (MW_MARGIN_BOTTOM, 0.8);
mw_page (MW_MARGIN_LEFT, 0.8);
mw_page (MW_MARGIN_RIGHT, 0.8);
mw_page (MW_HEADER_POS, 0.5);
mw_page (MW_FOOTER_POS, 0.5);
mw_page (MW_COLUMN_SPACE, 0.9);
mw_page (MW_GUTTER_MARGIN, 0.2);
mw_page (MW_PAGE_NUMBERS_FROM_TOP, 0.6);
mw_page (MW_PAGE_NUMBERS_FROM_LEFT, 8.0);
mw_page (MW_LINE_NUMBERS_FROM_TEXT, 0.2);

mw_font (16);                   /* for HP LaserJet III: CGTimes */
mw_paragraph (MW_ALIGNMENT, MW_CENTER);
mw_printf ("centered\n");
mw_paragraph (MW_ALIGNMENT, MW_RIGHT);
mw_printf ("right\n");
mw_paragraph (MW_ALIGNMENT, MW_JUSTIFIED);
for (loop = 0; loop < 20; loop ++)
  mw_printf ("justified text ");
mw_printf ("\n");
mw_paragraph (MW_ALIGNMENT, MW_LEFT);

mw_paragraph (MW_BOX, ON);
mw_printf ("with box\n");

mw_paragraph (MW_LINE_STYLE, MW_DOUBLE);
mw_printf ("with double box\n");
mw_paragraph (MW_BOX, OFF);

mw_paragraph (MW_LINES, MW_LINE_RIGHT | MW_LINE_LEFT);
mw_printf ("with lines right and left\n");

mw_paragraph (MW_LINES, MW_LINE_ABOVE | MW_LINE_BELOW);
mw_printf ("with lines above and below\n");

mw_paragraph (MW_LINES, OFF);
mw_spacing (MW_LINE_SPACING, MW_AUTO);

mw_tab (MW_RESETALL);
mw_tab (MW_SET, 0.5, MW_LEFT, ' ');
mw_tab (MW_SET, 1.0, MW_LEFT, ' ');
mw_tab (MW_SET, 1.5, MW_LEFT, ' ');
mw_tab (MW_SET, 2.5, MW_DECIMAL, '.');

mw_fontsize (6.0);
mw_printf ("The diagonal one-by-one:\n\n");
for (loop = 1; loop < 10; loop ++)
  mw_printf ("%d\tx\t%d\t=\t%d,0\n", loop, loop, loop * loop);

mw_close ();
}

