/* fast multiple disk copy program */
#include <stdio.h>
#include "fdc.h"

#define PROG "fdc"
#define VERSION "0.01"
#define MAX_DRIVES 2;

struct ati *sp;
int max_sect;
int sect_size;
int sect_type;
int sides;
int dasd_drv[MAXDRIVES];
extern int secsize[];

main(argc, argv)
int argc;
char **argv;
{

	int mfd;							/* memory file fd					*/
	int s_drive, d_drive;		/* source & destination drives */
	int s_drv_num, d_drv_num;	/* source & destination drive # */
	long disk_size;				/* size of disk in bytes		*/

	
	if(argc == 2) {
		s_drive = *argv[1];
		d_drive = s_drive;
	} else if(argc == 3) {
		s_drive = *argv[1];
		d_drive = *argv[2];
	} else {
		printf("%s (v%s)\n", PROG, VERSION);
		exit(0);
	}
	s_drv_num = tolower(s_drive) - 'a' + 1;
	d_drv_num = tolower(d_drive) - 'a' + 1;
	checkdrives(s_drv_num, d_drv_num);
	disk_size = 9l * 512l * 2l;		/* dirty way to get max disk size */
	if((mfd = getmspace(disk_size)) == EOF)
		exit(1);
	signon(s_drive, d_drive);
	if(!psdisk(s_drive)) {
		gdtype(s_drv_num);
		dsetup(d_drv_num);
		if(!readdisk(s_drv_num, mfd)) {
			pddisk(d_drive);
			diskcopy(d_drv_num, mfd);
		}
	}
	if(mfd) 
		cleanup(mfd);
	signoff();
	exit(0);
}

int checkdrives(s_drv, d_drv)
int s_drv, d_drv;
{

	int i;
	for(i = 0; i < MAXDRIVES; ++i) 
		dasd_drv[i] = getdasd(i);
	if(!dasd_drv[s_drv] || !dasd_drv[d_drv]) {
		printf("Invalid drive specified!\n");
		exit(1);
	}
}

int cleanup(fd)
int fd;
{

	restoredpb();
	close(fd);
}

int diskcopy(drive, mfd)
int drive, mfd;
{
	/* fill in later */
}


int dsetup(drv_num)
int drv_num;
{

	static first = 0;
	struct dpb *dp;
	extern struct dpb dsk_p_blk[];


	if(!first) {
		setdbp();
		++first;
	}
	dp = &dsk_p_blk[drv_num];
	if((sp->media_type & 0xff) != 0xf9) {
		dp->sector_type = sect_type;
		dp->format_gap_length = 0x50;
		dp->eot = max_sect;
	}
	if(dasd_drv[drv_num] > 1)			/* a 1.2 M disk drive */
		setdasd(drv_num, 2);				/* a 320/360 in a 1.2M */
	else
		setdasd(drv_num, 1);				/* a 320/360 in 320/360 drive */

}

int gdtype(s_drive)
int s_drive;
{
	int i;		
	struct ati *getati();

	sp = getati(s_drive);
	sect_size = sp->sector_size;
	switch(sp->media_type & 0xff) {
		case 0xff:
			sides = 2;
			max_sect = 8;
			break;
		case 0xfe:
			sides = 1;
			max_sect = 8;
			break;
		case 0xfd:
			sides = 2;
			max_sect = 9;
			break;
		case 0xfc:
			sides = 1;
			max_sect = 9;
			break;
		case 0xf9:
			sides = 2;
			max_sect = 15;
			break;
		case 0xf8:
			printf("Trying to fdc the hard disk, eh?\n");
			exit(0);
		default:
			printf("Hummmm. I don't recognize the disk type, %x.\n", 
				sp->media_type);
			exit(0);
	}
	for(i = 0; secsize[i]; ++i)
		if(secsize[i] = sp->sector_size) {
			sect_type = i;
			break;
		}
	if(i && !sect_type) {
		printf("Hummm. I don't recognize this sector size, %d\n", 
			sp->sector_size);
		exit(0);
	}
	printf("Copying %d side(s), %d sector/track\n", sides, max_sect);

}			

int getmspace(space)
long space;
{

	long msize();

	if(msize() < space) {
		printf("Not enough memory for the copy!\n");
		return(EOF);
	}
	return(mopen(space));
}

int psdisk(source)
int source;
{

	return(pdisk("SOURCE", source));

}

int pddisk(destination)
int destination;
{

	return(pdisk("DESTINATION", destination));

}


int pdisk(type, drive)
char *type;
int drive;
{
	int i;

	printf("Please insert the %s diskette into drive %c\n", 
		type, toupper(drive));
	printf("Hit Enter to start, A to abort ");
	for( ; ; ) {
		i = getch();
		if(i == '\r') {
			putchar('\n');
			return(0);
		}		
		if(i == tolower('a')) {
			putchar('\n');
			return(-1);
		}
	}
}


int readdisk(drive, mfd)
int drive, mfd;
{

	int head, track;
	int tracksize;
	char *buf;
	char *malloc();

	tracksize = sect_size * max_sect;
	if((buf = malloc(tracksize)) == NULL) {
		printf("Cannot create temp area!\n");
		return(-1);
	}

	for(track = 0; track < 39; ++track)
		for(head = 0; head < sides; ++head) {
			if(rdtrack(drive, head, track, 1, max_sect, buf)) {
				printf("Error in reading disk!\n");
				return(-1);
			}
			if(write(mfd, buf, tracksize) != tracksize) {
				printf("Error writing to memfile!\n");
				return(-1);
			}  
		}
	free(buf);
	return(0);
}

int signoff()
{

	printf("Thank you for using %s\n", PROG);

}

int signon(source, destination)
int source, destination;
{
	printf("%s (v%s)\n", PROG, VERSION);
	printf("Will copy %c: ==> %c:\n", source, destination);
}
	

