/*
 * 	Verify a track
 *
 * 	Accepts:	drive: 0 = A:, 1 = B:
 *			head: 0 / 1
 *			start_sect: starting sector
 *			max_sect: maximum # of sectors to check
 *			buf: buffer holding informtion to verify
 *			start_sect and max_sect can be 1 - 8, 1 - 9, 1 - 15.
 *
 *	Returns 0 if successful, -1 on error with errno set with DOS return
 */



#include <stdio.h>
#include <dos.h>
#include "fdc.h"

int vertrack(drive, head, track, start_sect, max_sect, buf)
int drive, head, track, start_sect, max_sect;
char *buf;
{

	int i;
	char *advance;
	struct REGVAL r;
	extern int errno;

	advance = buf; 				/* starting buff pointer */
	r.ax = VERIFYTR | max_sect;
	r.es = getds();
	r.bx = advance;
	r.cx = (track << 8) | start_sect; 
	r.dx = (head << 8) | drive;
#if 0
	for(i = 1; i <= max_sect; ++i) {
		if(sysint(DISKINT, &r, &r) & 1) {
			errno = (int)(r.ax >> 8);
			return(i);
		}
		++r.cx;					/* advance to next sector */
		advance += secsize[sec_type];
	}
#endif
	if (sysint(DISKINT, &r, &r) & 1) {
		errno = (int)(r.ax >> 8);
		return(-1);
	}
	return(0);
}
		

	


