%{
    #include <string.h>

    /* These are counts on a per-file basis. (ie. number of whatever's in  */
    /* the current file.  */

    unsigned nl=0;               /* lines                                */
    unsigned ppd=0;              /* pre-processor directives             */
    unsigned comments=0;         /* comments ( of course )               */
    unsigned comment_lines=0;    /* lines occupied by comments           */
    unsigned fl_cpp=0;           /* lines occupied only by c++ comments  */
    unsigned skipped=0;          /* lines skipped due to #if 0 directives*/
    unsigned files=0;            /* files we've looked at                */

    unsigned nested=0;           /* nesting level of pre-processor lines */

    /* this is a list of extensions to search for if none is given      */
	/* if you modify it, be sure to keep a NULL as the last entry       */
	char *extensions[] = {
        ".C",".CPP",".CXX",".H",".HPP",".HXX",".CC",NULL
	};

    unsigned matched=0;

%}
ws      [ \t\v]*
WS      [ \t\v]+

%s SKIP COMMENT
%%

<SKIP>^{ws}#{ws}else  {
                        if (--nested == 0)
                            BEGIN INITIAL;
                      }

<SKIP>^{ws}#{ws}endif {
                        ppd++;
                        if (--nested==0)
                            BEGIN INITIAL;
                }

<SKIP>\n        {       skipped++;  }

<SKIP>^{ws}#{ws}if   {       nested++;   }

<INITIAL>^{ws}#  {
                    ppd++;
                }

<INITIAL>^{ws}#{ws}if{ws}0.*$ {
                        ppd++;
                        nested++;
                        BEGIN SKIP;
                }

<INITIAL>"/*"   {
                    comments++;
                    BEGIN COMMENT;
                }

<COMMENT>\n     {
                    comment_lines++;
                }

<COMMENT>"*/"   {
                    BEGIN INITIAL;
                }

<INITIAL>^"//".*$        {
                    fl_cpp++;
                    comments++;
                    comment_lines++;
                }

<INITIAL>"//".*$         {
                    comments++;
                }

<INITIAL>"*/"   {
                    printf("found unmatched close-comment");
                }

\"(\\.|[^\"])*\"        ;   /* This recognizes and ignores string constants */
'[^\\]'|'\\[0-0xFF]'    ;   /* This does the same for character constants   */
<INITIAL>\n             nl++;

.                       ;

%%

int main(int argc,char **argv) {

#ifdef __TURBOC__
#include <stdlib.h>
#define _MAX_PATH MAXPATH
#endif

    unsigned tppd=0,tnl=0,tl=0;
    unsigned total_comments=0,total_comment_lines=0;
    unsigned total_skipped=0;
	char file_name[_MAX_PATH];
    char **extension;
    char *end;

    if (argc<2) {
		/* read standard input if no file name supplied */
		yylex();
        nl-=ppd+fl_cpp;
        tppd+=ppd;
        tnl+=nl;
        total_comments+=comments;
        total_comment_lines+=comment_lines;
        total_skipped+=skipped;
        tl+=fl_cpp+ppd+nl+comment_lines+skipped;
        files=2;
    }

	else while (--argc) {

        nl=ppd=fl_cpp=comments=comment_lines=skipped=0;

		/* otherwise, open each file supplied in turn. */
        strcpy(file_name,*++argv);
        end=strchr(file_name,'\0');
        if ((yyin=fopen(file_name,"r"))==NULL && strchr(*argv,'.')==NULL) {
            for (extension=extensions;**extension;extension++) {
                strcpy(end,*extension);
                if ((yyin=fopen(file_name,"r"))!=NULL)
					break;
			}
		}
        if (yyin==NULL) {
            printf("\n\nError: Unable to open %s\n",*argv);
            continue;
        }
        files++;
		yylex();        /* do dirty work on file itself */
		/* subtract preprocessor lines and full-line    */
		/* c++ comments to get number of code lines.    */
		/* new-lines contained in normal comments are   */
		/* dealt with in the rule for comments          */
		nl-=ppd+fl_cpp;
		/* report what we found                         */
		printf("\n\t\"%s\" contains:"
            "\n%u preprocessor directives, %u comments on %u lines,"
            "\n%u lines skipped due to pre-processor directives"
            "\nand %u lines of code, for a total of %u lines",
            file_name,ppd,comments,comment_lines,skipped,nl,
			ppd+nl+comment_lines+skipped);
		/* current file's stats to totals               */
		tppd+=ppd;
        tnl+=nl;
		total_comments+=comments;
		total_comment_lines+=comment_lines;
		total_skipped+=skipped;
        tl+=fl_cpp+ppd+nl+comment_lines+skipped;
		/* reset yylex() so we can do another file.  If     */
		/* this isn't done, it won't read other files       */
		/* after it has reached te end of the first one.    */
		/* This particular call is specific to  Flex.       */
		/* lex, LeX, etc. use other  mechanisms.  LeX       */
		/* requires that you open files with ii_newfile()   */
		/* I'm not sure how reall AT&T lex deals with this. */
		yyrestart(yyin);
		fclose(yyin);
	}
	/* print final totals                               */
    if (files>1)
        printf("\n\tTotals:"
            "\n%u preprocessor directives, %u comments on %u lines,"
            "\n%u lines skipped due to pre-processor directives"
            "\nand %u lines of code, for a grand total of %u lines"
            "\nmodules average %d lines",
            tppd,total_comments,total_comment_lines,total_skipped,tnl,tl,tl/files);
        /* and we're outta here !                           */
	return 0;
}
