/* crde.h */

/*
The C Relational Database Engine.
Copyright (c) 1990, Mark Lang.
All Rights Reserved.
*/

#ifndef __LARGE__
#error Must compile in LARGE memory model to use CRDE!
#endif

#ifndef __CRDE__
#define __CRDE__

#ifdef  __STDC__
#define tdecl(type) type
#else
#define tdecl(type) type cdecl
#endif

/* TABLE type */

typedef void TABLE;

/* dollar type */

typedef double dollar_t;

/* table limits */

#define MAXTABLES     128
#define MAXTABLENAME  64
#define MAXROWSIZE    4000
#define MAXCOLNAME    16
#define MAXCOLSIZE    256
#define MAXKEYCOLS    8
#define MAXKEYSIZE    256
#define MAXROWS       2147483647
#define MAXCOLS       256
#define MAXINDEXES    8
#define MAXJOINCOLS   256
#define MAXEXPR       16
#define MAXCHANGES    16

/* search relops */

#define EQ  0
#define LT  1
#define GT  2
#define LE  3
#define GE  4
#define NE  5

#define LTE LE
#define GTE GE
#define NEQ NE

/* temporary table id's */

#define TEMP    ((char *)0)
#define STATIC  ((char *)1)

/* table modes */

#define T_NORMAL 0
#define T_WRITEC 1
#define T_TEMP   2
#define T_STATIC 3

/* function prototypes */

tdecl(int)     taccess     (TABLE *t, int mode);
tdecl(long)    tadd        (TABLE *t1, TABLE *t2);
tdecl(int)     tall        (tdecl(int) (*func)(TABLE *));
tdecl(int)     taverage    (TABLE *t, char *c, void *result);
tdecl(TABLE *) tborrow     (char *name, TABLE *t);
tdecl(long)    tchange     (TABLE *t, ...);
tdecl(long)    tchangeif   (TABLE *t, tdecl(int) (*action)(void *), ...);
tdecl(int)     tchcol      (TABLE *t, char *old, char *new);
tdecl(int)     tclose      (TABLE *t);
tdecl(int)     tcmpstruct  (TABLE *t1, TABLE *t2);
tdecl(int)     tcols       (TABLE *t);
tdecl(int)     tcolsize    (TABLE *t, char *c);
tdecl(char)    tcoltype    (TABLE *t, char *c);
tdecl(int)     tcommit     (TABLE *t);
tdecl(TABLE *) tcopy       (char *name, TABLE *t);
tdecl(int)     tcount      (TABLE *t, char *c, void *result);
tdecl(TABLE *) tcreat      (char *name, char *td);
tdecl(TABLE *) tcrstruct   (char *name, TABLE *t);
tdecl(long)    tdelete     (TABLE *t, ...);
tdecl(long)    tdeleteif   (TABLE *t, tdecl(int) (*action)(void *), ...);
tdecl(TABLE *) tdiff       (char *name, TABLE *t1, TABLE *t2);
tdecl(int)     tdrop       (TABLE *t);
tdecl(int)     tdropindex  (TABLE *t, char *id);
tdecl(int)     tempty      (TABLE *t);
tdecl(int)     terase      (char *name);
tdecl(long)    texportascii(TABLE *t, char *dest);
tdecl(long)    texportdBASE(TABLE *t, char *dest);
tdecl(int)     tflush      (TABLE *t);
tdecl(long)    tget        (TABLE *t, void *buf, long n, ...);
tdecl(long)    tgetif      (TABLE *t, void *buf, long n,
			    tdecl(int) (*action)(void *), ...);
tdecl(TABLE *) tgroup      (char *name, TABLE *t, char *id, char *td,
			    tdecl(int) (*summary)(void *, void *, int));
tdecl(int)     tindex      (TABLE *t, char *id);
tdecl(int)     tindexes    (TABLE *t);
tdecl(TABLE *) timportascii(char *name, char *td, char *source);
tdecl(TABLE *) timportdBASE(char *name, char *source);
tdecl(long)    tinsert     (TABLE *t, void *recs, long n);
tdecl(TABLE *) tintersect  (char *name, TABLE *t1, TABLE *t2);
tdecl(TABLE *) tjoin       (char *name, TABLE *t1, char *cl1, TABLE *t2,
			    char *cl2, char *pl);
tdecl(int)     tload       (TABLE *t, ...);
tdecl(int)     tlookup     (TABLE *t, ...);
tdecl(int)     tlookupif   (TABLE *t, tdecl(int) (*action)(void *), ...);
tdecl(int)     tkeyed      (TABLE *t);
tdecl(TABLE *) tkeys       (char *name, TABLE *t);
tdecl(int)     tmark       (TABLE *t);
tdecl(int)     tmax        (TABLE *t, char *c, void *result);
tdecl(int)     tmin        (TABLE *t, char *c, void *result);
tdecl(int)     tmode       (TABLE *t);
tdecl(int)     tnormal     (TABLE *t);
tdecl(TABLE *) topen       (char *name);
tdecl(TABLE *) tproject    (char *name, TABLE *t, char *pl, ...);
tdecl(TABLE *) tprojectif  (char *name, TABLE *t, char *pl,
			    tdecl(int) (*action)(void *), ...);
tdecl(int)     trelease    (TABLE *t);
tdecl(int)     trename     (char *old, char *new);
tdecl(TABLE *) trepair     (char *name, char *td);
tdecl(long)    treplace    (TABLE *t, void *recs, long n);
tdecl(TABLE *) trestruct   (char *name, TABLE *t, char *td);
tdecl(int)     trollback   (TABLE *t);
tdecl(long)    trows       (TABLE *t);
tdecl(int)     trowsize    (TABLE *t);
tdecl(long)    tscan       (TABLE *t, ...);
tdecl(long)    tscanif     (TABLE *t, tdecl(int) (*action)(void *), ...);
tdecl(TABLE *) tselect     (char *name, TABLE *t, ...);
tdecl(TABLE *) tselectif   (char *name, TABLE *t,
			    tdecl(int) (*action)(void *), ...);
tdecl(TABLE *) tsort       (char *name, TABLE *t, char *id);
tdecl(TABLE *) tstruct     (char *name, TABLE *t);
tdecl(long)    tsubtract   (TABLE *t1, TABLE *t2);
tdecl(int)     tsum        (TABLE *t, char *c, void *result);
tdecl(int)     ttransact   (TABLE *t);
tdecl(TABLE *) tunion      (char *name, TABLE *t1, TABLE *t2);
tdecl(long)    tupdate     (TABLE *t1, TABLE *t2);
tdecl(int)     tview       (TABLE *t, char *cl, char *id, int ax, int ay,
			    int bx, int by, int cattr, int fattr, int battr,
			    void *rec);
tdecl(int)     twritec     (TABLE *t);


/* global variables */

extern tdecl(int)  terrno;            /* contains last error code        */
extern tdecl(long) trowsfound;        /* rows involved in last operation */

#endif

/* end of crde.h */

