/* date.h */

/*
The C Relational Database Engine.
Copyright (c) 1990, Mark Lang.
All Rights Reserved.
*/

#ifndef __LARGE__
#error You must compile in LARGE memory model to use CRDE!
#endif

#ifndef __DATE_T__
#define __DATE_T__

#if __STDC__
#define ddecl(type) type
#else
#define ddecl(type) type cdecl
#endif

/* date_t defined */

typedef long date_t;

/* constants for days of week */

#define SUNDAY    0
#define MONDAY    1
#define TUESDAY   2
#define WEDNESDAY 3
#define THURSDAY  4
#define FRIDAY    5
#define SATURDAY  6

/* function protypes */

ddecl(int)    day        (date_t dt);
ddecl(int)    dayofweek  (date_t dt);
ddecl(int)    dayofyear  (int month, int day, int year);
ddecl(int)    daysinmonth(int month, int year);
ddecl(int)    daysinyear (int year);
ddecl(date_t) firstday   (int month, int year, int dayofweek);
ddecl(int)    gmdate     (date_t dt, int *month, int *day, int *year);
ddecl(int)    leapyear   (int year);
ddecl(date_t) mkdate     (int month, int day, int year);
ddecl(int)    month      (date_t dt);
ddecl(date_t) monthadd   (date_t dt, int months);
ddecl(int)    monthday   (int days, int year, int *month, int *day);
ddecl(int)    year       (date_t dt);
ddecl(date_t) yearadd    (date_t dt, int years);

#endif

/* end of date.h */