/* sample.c */

/**********************************************************************/
/*                                                                    */
/* Sample Application for The C Relational Database Engine.           */
/* Copyright (c) 1990, Mark Lang.                                     */
/*                                                                    */
/* This sample program demostrates the power and ease of use of The   */
/* C Relational Database Engine.  Although only 100 or so lines long, */
/* this program generates a suppliers table with 1000 random records  */
/* and performs several complex queries upon them.                    */
/*								      */
/* Many of a the queries shown which call a single function call in   */
/* CRDE would require hundreds or even thousands of lines of code in  */
/* other database toolkits.  And this power and ease of use is not    */
/* comprimised by lack of performance.  In fact, CRDE will and has    */
/* outperformed professional databases products such as Paradox and   */
/* R:Base, making it more than a match when compared to other C       */
/* database libraries.                                                */
/*                                                                    */
/**********************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include "crde.h"


typedef struct {
  int s;
  char sname[26];
  char city[26];
  int status;
} sup;


int tbuffers = 128;

char *cities[10] = { "Atlanta", "Boston", "Detroit", "Hong Kong", "New York",
  "London", "San Francisco", "Denver", "Charlotte", "Chicago" };

char supname[26];


void showtable(TABLE *t, char *prompt)
{
  gotoxy(3,1); clreol(); puts(prompt);
  gotoxy(3,2); clreol(); puts("Press [Enter] or [Esc] to continue.");
  tview(t, NULL, NULL, 3, 3, 78, 23, 0x07, 0x07, 0x07, NULL);
}

int calccount(void *in, void *out, int first)
{
  typedef struct {
    char city[26];
    int count;
  } outs;

  switch (first) {
    case 1 :
      strncpy(((outs *)out)->city, ((sup *)in)->city, 25);
      ((outs *)out)->count = 0;
    case 0 :
      ((outs *)out)->count++;
  }
  return 1;
}


int main()
{
  TABLE *t, *answer;
  int i;

  clrscr();
  puts("  Generating supplier table with 1000 random suppliers...");

  strcpy(supname, "Supplier    ");

  /* create sups table */
  t = tcreat("sups", "*s# i, sname c26, city c26, status i");

  twritec(t);
  for (i = 1; i <= 1000; i++) {
    itoa(i, &supname[8], 10);
    tload(t, i, supname, cities[random(10)], random(30) + 1);
  }
  tnormal(t);

  /* display table */
  showtable(t, "View supplier table.");

  /* display supplier #100 */
  answer = tselect(TEMP, t, "s#", EQ, 100, NULL);
  showtable(answer, "Selected supplier #100 from supplier table.");

  answer = tselect(TEMP, t, "status", GT, 25, NULL);
  showtable(answer, "Selected all suppliers with a status > 25.");

  answer = tselect(TEMP, t, "status", GT, 25, "city", EQ, "Atlanta", NULL);
  showtable(answer, "Selected all suppliers from Atlanta with a status > 25.");

  /* select distinct cities in sorted order */
  answer = tsort(TEMP, tproject(TEMP, t, "*city", NULL), "city");
  showtable(answer, "Selected distinct cities from suppliers, sorted by city.");

  /* calculate the average status per city */
  answer = tsort(TEMP, tgroup(TEMP, t, "city", "city c26, count i", calccount), "city");
  showtable(answer, "Grouped supplier table by city calculating the number of suppliers per city.");

  clrscr();
  puts("   End of CRDE demostration.");

  tclose(t);
}


/* end of sample.c */