/* tstruct.c */

/***********************************************************************/
/*                                                                     */
/* Command-line program which will display the structure of a CRDE     */
/* table.                                                              */
/*       							       */
/* Usage: tstruct <tablename>                                          */
/*                                                                     */
/* To compile this program requires the creation of a project file     */
/* which should look something like                                    */
/*                                                                     */
/*   tstruct                                                           */
/*   crde.lib                                                          */
/*                                                                     */
/***********************************************************************/

#include <stdio.h>
#include <conio.h>
#include "crde.h"


int tbuffers = 128;

int main(int argc, char *argv[])
{
  TABLE *t;
  int i;

  if (argc < 2) {
    printf("usage: tstruct <tablename>\n");
    exit(1);
  }

  if ((t = topen(argv[1])) == NULL) {
    printf("Unable to open table (error code = %d).\n", terrno);
    exit(1);
  }

  clrscr();
  gotoxy(3, 2); printf("Viewing table %s.", argv[1]);
  gotoxy(3, 3); printf("%ld rows found.", trows(t));
  if (tview(tstruct(TEMP, t), NULL, NULL, 3, 4, 78, 23, 0x07, 0x07, 0x07,
  NULL) < 0)
    printf("Error %d occurred. Program aborted.", terrno);

  tclose(t);
}

/* end of tstruct.c */