/*--------------------------------------------------------------------------*
 *   Copyright (c) AlphaWare, 1991                                          *
 *   Released to Public Domain, 1991                                        *
 *                                                                          *
 *   AlphaWare                                                              *
 *   2010 Appalachia                                                        *
 *   Mequite, Texas 75149                                                   *
 *   (214) 289-2696                                                         *
 *                                                                          *
 *   DISPSTRU.EXE <datebase_filename> [/FF] [> lpt1/lpt2/prn/filename]      *
 *                                                                          *
 *     <database_filename> : This can be a filename or a wildcard           *
 *                           LOG.DBF, LO?.DBF, *.DBF, AA??A?.DBF            *
 *                           filename must end with '.DBF'                  *
 *                                                                          *
 *     /FF                 : This is optional, it places a Form Feed char   *
 *                           at the end of each database file               *
 *                                                                          *
 *     > lpt1/prn/filename : This is optional, it places the output to a    *
 *                           filename or the printer                        *
 ****************************************************************************/




#include <d4base.h>
#include <stdio.h>
#include <dos.h>
#include <string.h>


static char temp_buffer[130];

int  rc;
struct find_t next_file_ptr;

int main( int argn, char *argc[] )
{
   int j;
   long ref;

	printf("DISPSTRU.EXE    ---  Display dBASE file structures        Version 1.00\n");
	printf("                     Copyright (c) 1991, AlphaWare\n");
	printf("                     Released to the Public Domain 1991\n\n");
	

	if ( argn < 2)
	{
		printf("Usage is: DISPSTRU <database_name> [/FF] [> lpt1/prn/filename]\n");
		exit(0);
	}

	if (((rc = strlen(argc[1])) < 5) || (strcmpi( &argc[1][(rc - 4)] , ".DBF") != 0))

	{
		printf("*ERROR*: Database Filename must end with \".DBF\"\a\n");
		exit(2);
	}


	for ( rc = _dos_findfirst( argc[1], _A_NORMAL, &next_file_ptr );
	      rc == 0;
		  rc = _dos_findnext( &next_file_ptr ) )
	{

	if ( d4use( next_file_ptr.name ) < 0) exit(1);

	printf("                                       Database Structure for : %s\n", next_file_ptr.name);
	printf("        Fields     Type   Length  Dec       Number of Records : %ld\n",
	        d4reccount() );
	printf("       ----------  ----   ------  ----\n");

   for ( j=1; j <= f4num_fields(); j++ )
   {
     ref = f4j_ref( j );

	  printf(" %3d   %-10s    %c      %4d  %4d\n",
	         j, f4name(ref), f4type(ref), f4width(ref), f4decimals(ref));
	  

   }
	  if (strcmpi(argc[2], "/FF") == 0) 
	     printf("\f");
	  else
	     printf("\n\n\n\n");


	}

	exit(0);

}








