;-----------------------------------------------------------------------;
; TRUENAME.ASM                                                          ;
;                                                                       ;
; This module contains a C-callable function to determine the           ;
; canonical (fully qualified) name of a given path specification.       ;
; It uses a direct call to undocumented DOS function 60h.  This         ;
; function did not become available until DOS version 3.0, so this      ;
; procedure first checks for a DOS major version number that must       ;
; be 3 or above.  If DOS 2.X or earlier is detected, truename returns   ;
; an error.                                                             ;
;                                                                       ;
; DOS function 60h expects the path string to have no leading or        ;
; trailing white space.  The function strtrim (in module STRTRIM.ASM)   ;
; has been provided for this purpose, and should be called ahead of     ;
; truename unless the caller is certain that the string is already      ;
; properly formed.                                                      ;
;                                                                       ;
; DOS function 60h will return a qualified file name even if the        ;
; final subdirectory\filename.ext does not exist.  It therefore         ;
; cannot be used to test for the actual existence of the file.          ;
; Function 60h is more useful than similar routines that predated       ;
; DOS 3.0, in that it can "see through" SUBST and JOINed drives and     ;
; directories.                                                          ;
;                                                                       ;
; This module recognizes a _model symbol, and can therefore             ;
; generate object code for any model desired.  If _model is not         ;
; defined, the SMALL model is used by default.                          ;
;-----------------------------------------------------------------------;
; Usage:                                                                ;
;                                                                       ;
; #include "fcopy.h"                                                    ;
;                                                                       ;
; Function prototype:                                                   ;
;                                                                       ;
; int truename (char *pathname, char *qualname)                         ;
;                                                                       ;
; Returns:  If successful, returns 0.                                   ;
;                                                                       ;
;           If function fails, returns -1 and sets errno                ;
;           and _doserrno to one of the following:                      ;
;                                                                       ;
;               EINVFNC	Invalid function number (1)                     ;
;               ENOENT  Invalid source name (2)                         ;
;               ENOPATH Invalid drive or malformed path (3)             ;
;-----------------------------------------------------------------------;
; Revision history:                                                     ;
;                                                                       ;
;       1.0     19 APR 92       Original.                               ;
;                                                                       ;
;                               Uses conditional assembly for all       ;
;                               memory models by defining _model.       ;
;                               Defaults to the small model if          ;
;                               _model is not defined.                  ;
;                                                                       ;
;       1.1     12 MAY 92       Fixed bug in large data models when     ;
;                               running under a DOS version earlier     ;
;                               than 3.0.  Data segment was being       ;
;                               popped on exit, but was not pushed      ;
;                               on entry.                               ;
;                                                                       ;
;                               Now makes no assumption about setting   ;
;                               of DS on entry.  For large data models  ;
;                               (compact and large), sets DS to the     ;
;                               default data segment.  For huge model,  ;
;                               sets DS to segment containing errno     ;
;                               so that errno and _doserrno can be set  ;
;                               on error.                               ;
;-----------------------------------------------------------------------;
;       Copyright (c) 1992 Ray Waters                                   ;
;       All Rights Reserved                                             ;
;-----------------------------------------------------------------------;

EINVFNC EQU     1               ; equate for invalid function number
ENOENT  EQU     2               ; equate for invalid source name
ENOPATH EQU     3               ; equate for invalid drive or malformed path

IFDEF   _model                          ; if a _model was defined,
        .MODEL  _model, C               ;  use it
ELSE                                    ; else, default to
        .MODEL  SMALL, C                ;  SMALL model
ENDIF

IFDEF   ??version                       ; if using TASM,
        LOCALS                          ;  enable local labels
ENDIF

        EXTRN   C errno:WORD            ; global variables for errno
        EXTRN   C _doserrno:WORD        ;  and _doserrno

        .CODE                           ; open code segment

        PUBLIC  truename                ; make visible to Linker
;-----------------------------------------------------------------------;
; int truename (char *pathname, char *qualname)                         ;
;                                                                       ;
; Returns:      If successful, returns 0.                               ;
;                                                                       ;
;               If unsuccessful, returns -1 and sets errno              ;
;               and _doserrno to one of the following:                  ;
;                                                                       ;
;                   EINVFNC Invalid function number (1)                 ;
;                   ENOENT  Invalid source name (2)                     ;
;                   ENOPATH Invalid drive or malformed path (3)         ;
;-----------------------------------------------------------------------;
truename        PROC    C USES si di, pathname:PTR BYTE, qualname:PTR BYTE

IF @DataSize                            ; if large data model,
        push    ds                      ;  save original data segment
ENDIF
        mov     ax,3000h                ; check DOS version number
        int     21h
        cmp     al,3                    ; is it version 3.0 or later?
        mov     ax,EINVFNC              ; assume not, set error code
        jb      @@error                 ; abort if not version 3.0 or above

IF @DataSize                            ; if large data model,
        lds     si,[pathname]           ;  load pathname address in DS:SI
        les     di,[qualname]           ;  load ES:DI with qualname buffer
ELSE                                    ; for small data model,
        mov     ax,ds                   ;  set ES = DS
        mov     es,ax
        mov     si,[pathname]           ;  load pathname address in DS:SI
        mov     di,[qualname]           ;  load ES:DI with qualname buffer
ENDIF

        mov     ah,60h                  ; DOS function to qualify pathname
        int     21h
        jc      @@error                 ; jump on error
        xor     ax,ax                   ; AX = 0 for success

IF @DataSize                            ; if large data model,
        pop     ds                      ;  restore original data segment
ENDIF
        ret                             ; return to caller

@@error:
IF @DataSize EQ 2                       ; if huge data model,
        mov     bx,SEG errno            ; get segment of errno
        mov     ds,bx                   ;  into DS
ELSEIF @DataSize EQ 1                   ; if large data model,
        mov     bx,@data                ;  get default data segment
        mov     ds,bx                   ;  into DS
ENDIF
        mov     [errno],ax              ; set errno
        mov     [_doserrno],ax          ; set _doserrno
IF @DataSize                            ; if large data model,
        pop     ds                      ;  restore original data segment
ENDIF
        mov     ax,-1                   ; return int value of -1
        ret                             ; return to caller

truename        ENDP

        END
