/*  This is a short program demonstrating the fcopy function.  It
    prompts the user for source and target filenames and then performs
    the copy.  If an error occurred during the copy operation, an error
    message is displayed.

    Written by Ray Waters */

#include <io.h>                         /* access */
#include <stdio.h>                      /* printf, fprintf, remove */
#include <string.h>                     /* strupr */
#include <errno.h>                      /* errno, perror */
#include "fcopy.h"                      /* strtrim, fcopy */

main()
{
    char SrcName[80];                   /* buffer for source filename */
    char TgtName[80];                   /* buffer for target filename */
    register int count = 0;
    int InputError;

    printf("\nDemonstration of fcopy function:\n");

    for (;;) {
        do {
            printf("\n  Enter the SOURCE file name:  ");
            gets(SrcName);                      /* get source filename */
            if (!*SrcName) {                    /* trim white space */
                printf("\nDemonstration terminated by user\n");
                return 0;                       /* exit if nothing entered */
            }

            InputError = access(SrcName, 0);    /* see if source exists */
            if (InputError) {
                if (++count > 2) {              /* give them up to 3 tries */
                    fprintf(stderr, "\nDemonstration terminated: "
                                    "Too many input errors\n");
                    return -1;
                }
                perror("\nINPUT ERROR");        /* if not, display error */
            }
        }
        while (InputError);                     /* and try again */
        count = 0;                              /* clear error count */

        printf("\n  Enter the TARGET file name:  ");
        gets(TgtName);                          /* get target filename */
        if (!*TgtName) {                        /* trim white space */
            printf("\nDemonstration terminated by user\n");
            return 0;                           /* exit if nothing entered */
        }

        if (!fcopy(SrcName, TgtName)) {     /* perform the file copy */
                                            /* if successful, */
            strupr(SrcName);                /* fold file names to upper case */
            strupr(TgtName);
            printf("\nSUCCESS: Copied %s to %s\n", SrcName, TgtName);
        }

        else switch (errno) {   /* on error, display appropriate message */
            case DISKFUL:
                fprintf(stderr, "\nFCOPY ERROR: Target disk full\n");
                printf("Target file %s deleted\n", TgtName);
                break;
            case NOCOPY:
                fprintf(stderr, "\nFCOPY ERROR: File cannot be copied "
                                               "onto itself\n");
                break;
            default:                    /* message depends upon errno */
                perror("\nFCOPY ERROR");
                break;
        }
    }
}
