;-----------------------------------------------------------------------;
; FARREAD.ASM                                                           ;
;                                                                       ;
; This module contains a function that duplicates the Turbo C library   ;
; function _read(), except that this new function expects a far pointer ;
; to the file buffer.  Thus, when used with farmalloc(), the calling    ;
; program can set up large file buffers using the far heap, regardless  ;
; of the memory model being used.                                       ;
;                                                                       ;
; The bsize variable, indicating the buffer size, can be any int sized  ;
; value up to (but not including) 65,535.  65,535 is also used to       ;
; represent -1, which is used as the return value in case of error.     ;
; It is recommended that the buffer be a multiple of the sector size    ;
; (512 bytes in the current version of DOS), since reads and writes     ;
; are more efficient if they involve whole sectors.  A good value to    ;
; use is 65024 (decimal), since this is 1 sector (512 bytes) short      ;
; of a complete segment (64k).                                          ;
;-----------------------------------------------------------------------;
; Usage:                                                                ;
;                                                                       ;
; #include "fcopy.h"                                                    ;
;                                                                       ;
; Function prototype:                                                   ;
;                                                                       ;
; int _farread (int handle, void far *buf, unsigned bsize)              ;
;                                                                       ;
; Returns:  If successful, return number of bytes written.  On          ;
;           end-of-file, returns 0.                                     ;
;                                                                       ;
;           If function fails, returns -1 and sets errno and            ;
;           _doserrno to one of the following:                          ;
;                                                                       ;
;               EACCES  Permission denied                               ;
;               EBADF   Bad file number                                 ;
;-----------------------------------------------------------------------;
; Revision history:                                                     ;
;                                                                       ;
;       1.0      5 JAN 92       Original.                               ;
;                                                                       ;
;                               Uses conditional assembly for all       ;
;                               memory models by defining _model.       ;
;                               Defaults to the small model if          ;
;                               _model is not defined.                  ;
;                                                                       ;
;       1.1     19 JAN 92       Split _farread and _farwrite into       ;
;                               separate modules.  Removed TASM         ;
;                               extensions so that the modules would    ;
;                               assemble using either TASM or MASM.     ;
;                                                                       ;
;       1.2     19 APR 92       Added conditional to enable local       ;
;                               labels when assembling with TASM.       ;
;                                                                       ;
;                               Rearranged exit code to avoid an        ;
;                               extra push of DS in huge data models.   ;
;                                                                       ;
;       1.3     12 MAY 92       Now makes no assumption about setting   ;
;                               of DS on entry.  For large data models  ;
;                               (compact and large), sets DS to the     ;
;                               default data segment.  For huge model,  ;
;                               sets DS to segment containing errno     ;
;                               so that errno and _doserrno can be set  ;
;                               on error.                               ;
;-----------------------------------------------------------------------;
;   Copyright (c) 1992 Ray Waters                                       ;
;   All Rights Reserved                                                 ;
;-----------------------------------------------------------------------;

EACCES  EQU     5                       ; equate for permission denied
EBADF   EQU     6                       ; equate for bad file number

IFDEF   _model                          ; if a _model was
        .MODEL  _model, C               ;  defined, use it
ELSE                                    ; else, default to
        .MODEL  SMALL, C                ;  SMALL model
ENDIF

IFDEF   ??version                       ; if using TASM,
        LOCALS                          ;  enable local labels
ENDIF


        EXTRN   C errno:WORD            ; global error variable
        EXTRN   C _doserrno:WORD        ; global DOS error variable

        .CODE                           ; open code segment

        PUBLIC  _farread                ; make visible to Linker
;-----------------------------------------------------------------------;
; int _farread (int handle, void far *buf, unsigned bsize)              ;
;                                                                       ;
; Reads a file into a far buffer.                                       ;
;                                                                       ;
; Returns:  If successful, returns number of bytes read.  On            ;
;           end-of-file, returns 0.                                     ;
;                                                                       ;
;           If read failed, returns -1 and sets errno and _doserrno     ;
;           to one of the following:                                    ;
;                                                                       ;
;               EACCES  Permission denied                               ;
;               EBADF   Bad file number                                 ;
;-----------------------------------------------------------------------;
_farread        PROC    C \
                handle:WORD, buf:FAR PTR BYTE, bsize:WORD

        push    ds                      ; save original data segment
        mov     ah,3Fh                  ; DOS read file function
        mov     bx,[handle]             ; file handle
        mov     cx,[bsize]              ; number bytes to read
        lds     dx,[buf]                ; far pointer to buffer
        int     21h
        jc      @@read_error            ; jump on error, else...
        pop     ds                      ; restore original data segment
        ret                             ; return to caller

@@read_error:                           ; if read error:
IF @DataSize EQ 2                       ; if huge data model,
        mov     bx,SEG errno            ; get segment address
        mov     ds,bx                   ;  of errno into DS
ELSEIF @DataSize EQ 1                   ; if large data model,
        mov     bx,@data                ;  get default data segment
        mov     ds,bx                   ;  into DS
ELSE                                    ; if small data model,
        pop     ds                      ;  restore original data segment
ENDIF
        mov     [errno],ax              ; set errno
        mov     [_doserrno],ax          ; set _doserrno
IF @DataSize                            ; if large data model,
        pop     ds                      ;  restore original data segment
ENDIF
        mov     ax,-1                   ; return int value of -1
        ret                             ; return to caller

_farread        ENDP

        END
