

  /* PROGRAM WKND.C TO PRODUCE THE GAME PLAN FOR TUESDAY FOOD INSERT/
		   ROP WITH 5 MACHINES SLS1...SLS5.
    ZONES WITH NSSS DISTRIBUTION WILL BE ASSIGNED BY THE AFTERNOON SHIFT
  */


  #include <stdio.h>
  #include <malloc.h>

  enum 	     ZONE_COLOR { YELLOW = 0,
			  RED, /*= 1 */
			  BLUE /*= 2 */
			};

  enum       ZONE_DIST { ODD = 0,
			 SUB_CTRY, /* = 1 */
			 HOME_SC,  /* = 2 */
			 HOME,     /* = 3 */
			 NSSS      /* = 4 */
		       };

  struct ad_data{

	     char   AD_NAME[10];
	     int    AD_PAGE;

	     };
  typedef struct ad_data AD_ITEMS;


  #define    MAX_AD_ITEMS   25        /* MAX. NO. OF AD. INSERTS PER ZONE */

  struct zone_data{

	     int         MONTH, DAY, YEAR;
	     int         ZONE_NUM;
	     enum ZONE_COLOR  zone_color;
	     enum ZONE_DIST   zone_dist;
	     char        AD_NAME[10];
	     AD_ITEMS    ad_items[MAX_AD_ITEMS];
	     int         AD_COUNT;       /* TOT.NUM. OF ADS. IN EACH ZONE */
	     int         AD_PAGE;        /* NUMBER OF PAGES OF EACH AD.   */
	     int         PAGE_COUNT;     /* TOT.NUM. OF PGS OF ALL AD.    */
					 /* IN A ZONE.                    */
	     long        NW_ORDER;       /* NUM. OF COPIES ORDERRED AT NW.*/
	     long        SE_ORDER;       /* ...........................SE.*/
	     long        SP_ORDER;       /* ...........................SP.*/
	     long        TOT_ZONE_ORDER; /* TOT.Z.ORDER = NW+SE+SP_ORDER  */
	     int         BNDL_SIZE;      /* = 2600/PAGE_COUNT             */
	     struct zone_data   *next;

	     };
  typedef struct zone_data  zone_t;

  struct machine_data {

	     char         MACHINE_NAME[4];
	     int          ZONE_NUM;
	     int          TOT_Z_ORDER;

	     };
  typedef struct machine_data machine_t;

  zone_t *ptr, *top_ptr, *prev_ptr;
  int first = 0;
  int no_of_rec = 0;

  int no_of_odd  = 0;
  int no_of_yelw = 0;
  int no_of_red  = 0;
  int no_of_blue = 0;
  int no_of_nsss = 0;
  zone_t odd_rec[4], yelw_rec[20], red_rec[20], blue_rec[23];

  zone_t *sls1_top, *sls2_top, *sls3_top, *sls4_top, *sls5_top;
  int odd_per_machn, yelw_per_machn, red_per_machn, blue_per_machn;

  /* Global Variables */

	     long        TOT_YEL_ORDER  = 0;
	     long	 TOT_RED_ORDER  = 0;
	     long  	 TOT_BLUE_ORDER = 0;
	     long	 TOT_RUN_ORDER  = 0; /* =TOT_YEL_ORD.+RED+BLUE */

	     long	 tot_sls1_order = 0;
	     long	 tot_sls2_order = 0;
	     long	 tot_sls3_order = 0;
	     long	 tot_sls4_order = 0;
	     long	 tot_sls5_order = 0;

	     zone_t	 *top_ptr;
	     zone_t	 yellw_array[20];
	     zone_t	 red_array[20];
	     zone_t	 blue_array[20];


  zone_t *x_malloc(int num)
  {
    zone_t *ptr;

    ptr = (zone_t *) farmalloc(sizeof(zone_t));
    if (ptr == NULL)
      {
	 printf ("\nERROR: NO MORE FREE MEMORY - ptr = %x - num = %d",
				 ptr, num);
	 getch();
      }
    return (ptr);
  }

  read_data()
  {
    FILE     *fp, *fopen();
    zone_t   *ptr,  *prev_ptr;
    int      n = 0;
    char     text;
    int      MONTH, DAY, YEAR;
    int      PAGE_COUNT = 0;
    char     AD_NAME[10];
    int      FIRST   = 0;

    printf("\n Start Reading Data File \n ");
    fp = fopen("TESTPLAN.DAT","r");

    do
    {
   /*   getch(); /*for debug only */
      fscanf (fp, "%c", &text);
/*
      printf ("text = %c", text);
*/
      if ( text == '#' )                    /* NEW ZONE RECORD */
      {
	ptr = (zone_t *) x_malloc(0);
	if (ptr == 0)
	   printf("ptr = 0, out of memory\n");

	if ( FIRST == 0 )
	{
	  top_ptr = ptr;
	  FIRST   = 1;
	}
	else
	prev_ptr->next = ptr;
	fscanf( fp, "\n%d", &ptr->MONTH);
	fscanf( fp, "/%d", &ptr->DAY);
	fscanf( fp, "/%d", &ptr->YEAR);

	fscanf( fp, "\n%d", &ptr->ZONE_NUM );
	fscanf( fp, "\n%d", &ptr->zone_color );
	fscanf( fp, "\n%d", &ptr->zone_dist );

/*      ONLY USED TO CHECK DATA ENTRY ON SREEN

	printf ("\nzone_dist = %d", ptr->zone_dist);
	printf ("\nzone_num = %d", ptr->ZONE_NUM);
	printf ("\nzone_num = %d", ptr->ZONE_NUM);
*/

	/* READ AD. ITEM STRUCTURE  */

	fscanf( fp, "\n%c", &text);
/*
	printf ("\nitem text = %c", text);
*/
	n = 0;
	do
	{
	  n++ ;
      printf("n is: %d\n" , n);
	  fscanf( fp, "\n%s", ptr->ad_items[n].AD_NAME);
	  fscanf( fp, "\n%d", &ptr->ad_items[n].AD_PAGE );
	  PAGE_COUNT = PAGE_COUNT + ptr->ad_items[n].AD_PAGE;
	  fscanf( fp, "\n%c", &text );

/*        ONLY USED TO CHECK DATA ENTRY ON SREEN

	  printf ("\nAD_NAME = %d", ptr->ad_items[n].ad_name);
	  printf ("\nAD_PAGE = %d", ptr->ad_items[n].AD_PAGE);
	  printf ("\ntext = %c", text);
*/
	}
	while ( text != '-' );

	ptr->AD_COUNT = n;
   /*	ptr->PAGE_COUNT = PAGE_COUNT;
	ptr->BNDL_SIZE  = ( 2600/PAGE_COUNT );
   */

	fscanf( fp,"\n%ld", &ptr->NW_ORDER );
	fscanf( fp,"\n%ld", &ptr->SE_ORDER );
	fscanf( fp,"\n%ld", &ptr->SP_ORDER );
	ptr->TOT_ZONE_ORDER = ptr->NW_ORDER + ptr->SE_ORDER +ptr->SP_ORDER;

/*      ONLY USED TO CHECK DATA ENTRY ON SREEN

	printf ("\nSE_ORDER = %ld", ptr->SE_ORDER);
	printf ("\nNW_ORDER = %ld", ptr->NW_ORDER);
	printf ("\nSP_ORDER = %ld", ptr->SP_ORDER);
*/
      }
      prev_ptr = ptr;
      ptr->next = NULL;
    }
    while ( text != '*' );
    fclose(fp);

    printf( "\n End Of Read Data, hit ENTER KEY " );

    getch(); /*for debug only */

  }

  /*-----------------------------------------------------*/

  void sort_rec()

{
  zone_t  *x_ptr, *xx_ptr, *temp_ptr;
  zone_t  temp_rec;

  x_ptr = top_ptr;
  xx_ptr= x_ptr;

  if (x_ptr->next == 0)
  return;

  do  /* Compare Zone */
  {
   temp_rec = *x_ptr;  /* Updated Compared Zones */
   do
   {
    xx_ptr = xx_ptr->next;
    if (xx_ptr == NULL)
    break;

    if (((xx_ptr->zone_color == BLUE) && (temp_rec.zone_color == BLUE)
	&& ((xx_ptr->NW_ORDER > temp_rec.NW_ORDER)
	    || (xx_ptr->SE_ORDER > temp_rec.SE_ORDER)))
	|| (((xx_ptr->TOT_ZONE_ORDER > temp_rec.TOT_ZONE_ORDER) || (xx_ptr->zone_dist == ODD))
		      && (temp_rec.zone_dist != ODD)
		      && (xx_ptr->zone_dist != NSSS)))

    {
     temp_rec = *x_ptr;  /* Save old Data */
     temp_ptr = x_ptr->next;
     *x_ptr = *xx_ptr;   /* Copy new Data */
     x_ptr->next = temp_ptr;
     temp_ptr = xx_ptr->next;
     *xx_ptr = temp_rec; /* Restore Old Data */
     xx_ptr->next = temp_ptr;

     temp_rec = *x_ptr; /* Get Data for next comparison */
    }
   }while ( xx_ptr->next != NULL );

   x_ptr = x_ptr->next;
   xx_ptr = x_ptr;

 }while (x_ptr != NULL);
}
 /*------------------------------------------------------------------------*/
 /*          SORT ZONES INTO THREE GROUPS OF COLORS : YEL.,RED, BLUE       */
 /*------------------------------------------------------------------------*/

void color_sort()
{
 zone_t      *temp_ptr;
 int n, i, y, a, b;
 long x;

 temp_ptr =  top_ptr;

 if (temp_ptr != NULL)
 do
  {
   if (temp_ptr->zone_color == YELLOW)
   {
    yelw_rec[no_of_yelw++] = *temp_ptr;
    if (temp_ptr->TOT_ZONE_ORDER > 30000)
    {
     n = temp_ptr->TOT_ZONE_ORDER/30000;
     y = temp_ptr->TOT_ZONE_ORDER%(n+1);
     x = temp_ptr->TOT_ZONE_ORDER/(n+1);
     a = y/(n+1);
     b = y%(n+1);
     no_of_yelw--;
     if (y == 0)
      {
       yelw_rec[no_of_yelw].TOT_ZONE_ORDER = x+a;
      }
     else
      {
       yelw_rec[no_of_yelw].TOT_ZONE_ORDER = x+a+b;
      }

      for (i = 0; i < n; i++)
      {
       yelw_rec[++no_of_yelw] = *temp_ptr;
       yelw_rec[no_of_yelw].TOT_ZONE_ORDER = x+a;
      }
      no_of_yelw++;
      }
       TOT_YEL_ORDER = TOT_YEL_ORDER + temp_ptr->TOT_ZONE_ORDER;
      }
       else if (temp_ptr->zone_color == RED)
      {
       red_rec[no_of_red++] = *temp_ptr;
       if (temp_ptr->TOT_ZONE_ORDER > 30000)
       {
	n = temp_ptr->TOT_ZONE_ORDER/30000;
	y = temp_ptr->TOT_ZONE_ORDER%(n+1);
	x = temp_ptr->TOT_ZONE_ORDER/(n+1);
	a = y/(n+1);
	b = y%(n+1);
	no_of_red--;
	if (y == 0)
	{
	 red_rec[no_of_red].TOT_ZONE_ORDER = x;
	}
	else
	{
	 red_rec[no_of_red].TOT_ZONE_ORDER = x+a+b;
	}

	 for (i = 0; i < n; i++)
	 {
	    red_rec[++no_of_red] = *temp_ptr;
	    red_rec[no_of_red].TOT_ZONE_ORDER = x+a;
	  }
	  no_of_red++;
	}
	TOT_RED_ORDER = TOT_RED_ORDER + temp_ptr->TOT_ZONE_ORDER;
      }
       else if (temp_ptr->zone_color == BLUE)
      {
	blue_rec[no_of_blue++] = *temp_ptr;
	if (temp_ptr->TOT_ZONE_ORDER > 30000)
	{
	  n = temp_ptr->TOT_ZONE_ORDER/30000;
	  y = temp_ptr->TOT_ZONE_ORDER%(n+1);
	  x = temp_ptr->TOT_ZONE_ORDER/(n+1);
	  a = y/(n+1);
	  b = y%(n+1);
	  no_of_blue--;
	  if (y == 0)
	  {
	   blue_rec[no_of_blue].TOT_ZONE_ORDER = x+a;
	  }
	  else
	  {
	    blue_rec[no_of_blue].TOT_ZONE_ORDER = x+a+b;
	  }

	  for (i = 0; i < n; i++)
	  {
	    blue_rec[++no_of_blue] = *temp_ptr;
	    blue_rec[no_of_blue].TOT_ZONE_ORDER = x+a;
	  }
	  no_of_blue++;

	}
	TOT_BLUE_ORDER = TOT_BLUE_ORDER + temp_ptr->TOT_ZONE_ORDER;
      }
    } while ((temp_ptr = temp_ptr->next) != NULL);
    }

 /*-----------------------------------------------------------------------
 Blue record with NW_ORDER and SE_ORDER greater than zero will be on top,
 except ODD and NSSS zones.
-----------------------------------------------------------------------*/
special_sort (list, count)
zone_t *list;
int count;

{
  register int a, b, c;
  zone_t temp_rec;

  for (a=0; a<count-1; ++a)
  {
     c = a;
     temp_rec = list[a];
     for (b=a+1; b < count; ++b)
     {
	if (((list[b].NW_ORDER > temp_rec.NW_ORDER)
	     || ((list[b].SE_ORDER > temp_rec.SE_ORDER)
	     && (list[b].NW_ORDER >= temp_rec.NW_ORDER)))
	    && (temp_rec.zone_dist != ODD)
	    && (list[b].zone_dist != NSSS))
	{
	   c = b;
	   temp_rec = list[b];
	}
     }
     list[c] = list[a];
     list[a] = temp_rec;
  }

}

  /* -----------------------------------------------------------------
     This routine will return the machine number which has the smallest
     total order
   --------------------------------------------------------------------*/
   int next_machine()
   {
     register int a, b, c;
     int count = 5;
     long list[5];
     long temp;

     list[0] = tot_sls1_order;
     list[1] = tot_sls2_order;
     list[2] = tot_sls3_order;
     list[3] = tot_sls4_order;
     list[4] = tot_sls5_order;

     for (a = 0; a < count-1; ++a)
     {
       c = a;
       temp = list[a];
       for (b=a+1; b < count; ++b)
       {
	 if (list[b] < temp)
	 {
	   c = b;
	   temp = list[b];
	 }
       }
       list[c] = list[a];
       list[a] = temp;
     }

     if (list[0] == tot_sls1_order) return(1);
     if (list[0] == tot_sls2_order) return(2);
     if (list[0] == tot_sls3_order) return(3);
     if (list[0] == tot_sls4_order) return(4);
     if (list[0] == tot_sls5_order) return(5);

   }

 /*-----------------------------------------------------------------------*/
 /*                   ZONES ASSIGNMENT TO MACHINES                        */
 /*-----------------------------------------------------------------------*/

 machine_assign()
 {
    zone_t *sls1_temp, *sls2_temp, *sls3_temp, *sls4_temp, *sls5_temp;
    zone_t *sls1_prev_ptr, *sls2_prev_ptr, *sls3_prev_ptr, *sls4_prev_ptr,
							   *sls5_prev_ptr;
    int first_flg, i;
    int index = 0;
    int machine;


   /* create sls pointers */

   sls1_top = (zone_t *) x_malloc (1);
   if (sls1_top == 0)
	      printf("sls1_top = 0, out of memory\n");
   sls2_top = (zone_t *) x_malloc (2);
   if (sls2_top == 0)
	      printf("sls2_top = 0, out of memory\n");
   sls3_top = (zone_t *) x_malloc (3);
   if (sls3_top == 0)
	      printf("sls3_top = 0, out of memory\n");
   sls4_top = (zone_t *) x_malloc (4);
   if (sls4_top == 0)
	      printf("sls4_top = 0, out of memory\n");
   sls5_top = (zone_t *) x_malloc (5);
   if (sls5_top == 0)
	      printf("sls5_top = 0, out of memory\n");
   sls1_temp = sls1_top;
   sls2_temp = sls2_top;
   sls3_temp = sls3_top;
   sls4_temp = sls4_top;
   sls5_temp = sls5_top;
   sls1_temp->next = NULL;
   sls2_temp->next = NULL;
   sls3_temp->next = NULL;
   sls4_temp->next = NULL;
   sls5_temp->next = NULL;
   sls1_prev_ptr = NULL;
   sls2_prev_ptr = NULL;
   sls3_prev_ptr = NULL;
   sls4_prev_ptr = NULL;
   sls5_prev_ptr = NULL;

   /* assign odd to machine first */

    index = 0;
    ODD_START:
    odd_per_machn = (no_of_odd-index)/5;
    if ( odd_per_machn == 0 )
       odd_per_machn++;

    if ( index < no_of_odd )
   {
	 if (sls2_prev_ptr != NULL)
	 {
	   sls2_temp = (zone_t *) x_malloc (6);
	   if (sls2_temp == 0)
	      printf("sls2_temp = 0, out of memory\n");
	   sls2_prev_ptr->next = sls2_temp;
	 }
	 *sls2_temp = odd_rec[index++];
	  sls2_prev_ptr = sls2_temp;
	  sls2_temp->next = NULL;
   }

   if ( index < no_of_odd )
   {
	 if (sls3_prev_ptr != NULL)
	 {
	   sls3_temp = (zone_t *) x_malloc (7);
	   if (sls3_temp == 0)
	      printf("sls3_temp = 0, out of memory\n");
	   sls3_prev_ptr->next = sls3_temp;
	 }
	 *sls3_temp = odd_rec[index++];
	  sls3_prev_ptr = sls3_temp;
	  sls3_temp->next = NULL;
   }

   if ( index < no_of_odd )
   {
	 if (sls4_prev_ptr != NULL)
	 {
	   sls4_temp = (zone_t *) x_malloc (8);
	   if (sls4_temp == 0)
	      printf("sls4_temp = 0, out of memory\n");
	   sls4_prev_ptr->next = sls4_temp;
	 }
	 *sls4_temp = odd_rec[index++];
	  sls4_prev_ptr = sls4_temp;
	  sls4_temp->next = NULL;
   }

   if ( index < no_of_odd )
   {
	 if (sls1_prev_ptr != NULL)
	 {
	   sls1_temp = (zone_t *) x_malloc (9);
	   if (sls1_temp == 0)
	      printf("sls1_temp = 0, out of memory\n");
	   sls1_prev_ptr->next = sls1_temp;
	 }
	 *sls1_temp = odd_rec[index++];
	  sls1_prev_ptr = sls1_temp;
	  sls1_temp->next = NULL;
   }

   if ( index < no_of_odd )
   {
	 if (sls5_prev_ptr != NULL)
	 {
	   sls5_temp = (zone_t *) x_malloc (10);
	   if (sls5_temp == 0)
	      printf("sls5_temp = 0, out of memory\n");
	   sls5_prev_ptr->next = sls5_temp;
	 }
	 *sls5_temp = odd_rec[index++];
	  sls5_prev_ptr = sls5_temp;
	  sls5_temp->next = NULL;
   }
   if (index < no_of_odd) goto ODD_START;

  /* assign Yellow Zones to Machines */

   index = 0;
   YELLOW_START:
   yelw_per_machn = (no_of_yelw-index)/5;
   if ( yelw_per_machn == 0 )
       yelw_per_machn++;

   machine = next_machine();

   if (( index < no_of_yelw ) && (machine == 2))
   {
	 if (sls2_prev_ptr != NULL)
	 {
	   sls2_temp = (zone_t *) x_malloc (11);
	   if (sls2_temp == 0)
	      printf("sls2_temp = 0, out of memory\n");
	   sls2_prev_ptr->next = sls2_temp;
	 }
	 *sls2_temp = yelw_rec[index++];
	  sls2_prev_ptr = sls2_temp;
	  sls2_temp->next = NULL;
	  tot_sls2_order = tot_sls2_order + sls2_temp->TOT_ZONE_ORDER;

   }

   else if (( index < no_of_yelw ) && (machine == 3))
   {
	 if (sls3_prev_ptr != NULL)
	 {
	   sls3_temp = (zone_t *) x_malloc (12);
	   if (sls3_temp == 0)
	      printf("sls3_temp = 0, out of memory\n");
	   sls3_prev_ptr->next = sls3_temp;
	 }
	 *sls3_temp = yelw_rec[index++];
	  sls3_prev_ptr = sls3_temp;
	  sls3_temp->next = NULL;
	  tot_sls3_order = tot_sls3_order + sls3_temp->TOT_ZONE_ORDER;
   }

   else if (( index < no_of_yelw ) && (machine == 4))
   {
	 if (sls4_prev_ptr != NULL)
	 {
	   sls4_temp = (zone_t *) x_malloc (13);
	   if (sls4_temp == 0)
	      printf("sls4_temp = 0, out of memory\n");
	   sls4_prev_ptr->next = sls4_temp;
	 }
	 *sls4_temp = yelw_rec[index++];
	  sls4_prev_ptr = sls4_temp;
	  sls4_temp->next = NULL;
	  tot_sls4_order = tot_sls4_order + sls4_temp->TOT_ZONE_ORDER;
   }

   else if (( index < no_of_yelw ) && (machine == 1))
   {
	 if (sls1_prev_ptr != NULL)
	 {
	   sls1_temp = (zone_t *) x_malloc (14);
	   if (sls1_temp == 0)
	      printf("sls1_temp = 0, out of memory\n");
	   sls1_prev_ptr->next = sls1_temp;
	 }
	 *sls1_temp = yelw_rec[index++];
	  sls1_prev_ptr = sls1_temp;
	  sls1_temp->next = NULL;
	  tot_sls1_order = tot_sls1_order + sls1_temp->TOT_ZONE_ORDER;
   }

   else if (( index < no_of_yelw ) && (machine == 5))
   {
	 if (sls5_prev_ptr != NULL)
	 {
	   sls5_temp = (zone_t *) x_malloc (15);
	   if (sls5_temp == 0)
	      printf("sls5_temp = 0, out of memory\n");
	   sls5_prev_ptr->next = sls5_temp;
	 }
	 *sls5_temp = yelw_rec[index++];
	  sls5_prev_ptr = sls5_temp;
	  sls5_temp->next = NULL;
	  tot_sls5_order = tot_sls5_order + sls5_temp->TOT_ZONE_ORDER;
   }
   if (index < no_of_yelw) goto YELLOW_START;

   /* assign Red Zone to machines */

   index = 0;
   RED_START:
   red_per_machn = (no_of_red-index)/5;
   if ( red_per_machn == 0 )
       red_per_machn++;

   machine = next_machine();

   if (( index < no_of_red ) && (machine == 2))
   {
	 if (sls2_prev_ptr != NULL)
	 {
	   sls2_temp = (zone_t *) x_malloc (16);
	   if (sls2_temp == 0)
	      printf("sls2_temp = 0, out of memory\n");
	   sls2_prev_ptr->next = sls2_temp;
	 }
	 *sls2_temp = red_rec[index++];
	  sls2_prev_ptr = sls2_temp;
	  sls2_temp->next = NULL;
	  tot_sls2_order = tot_sls2_order + sls2_temp->TOT_ZONE_ORDER;
   }

   if (( index < no_of_red ) && (machine == 3))
   {
	 if (sls3_prev_ptr != NULL)
	 {
	   sls3_temp = (zone_t *) x_malloc (17);
	   if (sls3_temp == 0)
	      printf("sls3_temp = 0, out of memory\n");
	   sls3_prev_ptr->next = sls3_temp;
	 }
	 *sls3_temp = red_rec[index++];
	  sls3_prev_ptr = sls3_temp;
	  sls3_temp->next = NULL;
	  tot_sls3_order = tot_sls3_order + sls3_temp->TOT_ZONE_ORDER;
   }

   if (( index < no_of_red ) && (machine == 4))
   {
	 if (sls4_prev_ptr != NULL)
	 {
	   sls4_temp = (zone_t *) x_malloc (18);
	   if (sls4_temp == 0)
	      printf("sls4_temp = 0, out of memory\n");
	   sls4_prev_ptr->next = sls4_temp;
	 }
	 *sls4_temp = red_rec[index++];
	  sls4_prev_ptr = sls4_temp;
	  sls4_temp->next = NULL;
	  tot_sls4_order = tot_sls4_order + sls4_temp->TOT_ZONE_ORDER;
   }

   if (( index < no_of_red ) && (machine == 1))
   {
	 if (sls1_prev_ptr != NULL)
	 {
	   sls1_temp = (zone_t *) x_malloc (19);
	   if (sls1_temp == 0)
	      printf("sls1_temp = 0, out of memory\n");
	   sls1_prev_ptr->next = sls1_temp;
	 }
	 *sls1_temp = red_rec[index++];
	  sls1_prev_ptr = sls1_temp;
	  sls1_temp->next = NULL;
	  tot_sls1_order = tot_sls1_order + sls1_temp->TOT_ZONE_ORDER;
   }

   if (( index < no_of_red ) && (machine == 5))
   {
	 if (sls5_prev_ptr != NULL)
	 {
	   sls5_temp = (zone_t *) x_malloc (20);
	   if (sls5_temp == 0)
	      printf("sls5_temp = 0, out of memory\n");
	   sls5_prev_ptr->next = sls5_temp;
	 }
	 *sls5_temp = red_rec[index++];
	  sls5_prev_ptr = sls5_temp;
	  sls5_temp->next = NULL;
	  tot_sls5_order = tot_sls5_order + sls5_temp->TOT_ZONE_ORDER;
   }
   if (index < no_of_red) goto RED_START;

   /* assign blue Zone to machines */

   index = 0;
   BLUE_START:
   blue_per_machn = (no_of_blue-index)/5;
   if ( blue_per_machn == 0 )
       blue_per_machn++;

   machine = next_machine();

   if (( index < no_of_blue ) && (machine == 2))
   {
	 if (sls2_prev_ptr != NULL)
	 {
	   sls2_temp = (zone_t *) x_malloc (21);
	   if (sls2_temp == 0)
	      printf("sls2_temp = 0, out of memory\n");
	   sls2_prev_ptr->next = sls2_temp;
	 }
	 *sls2_temp = blue_rec[index++];
	  sls2_prev_ptr = sls2_temp;
	  sls2_temp->next = NULL;
	  tot_sls2_order = tot_sls2_order + sls2_temp->TOT_ZONE_ORDER;
   }

   if (( index < no_of_blue ) && (machine == 3))
   {
	 if (sls3_prev_ptr != NULL)
	 {
	   sls3_temp = (zone_t *) x_malloc (22);
	   if (sls3_temp == 0)
	      printf("sls3_temp = 0, out of memory\n");
	   sls3_prev_ptr->next = sls3_temp;
	 }
	 *sls3_temp = blue_rec[index++];
	  sls3_prev_ptr = sls3_temp;
	  sls3_temp->next = NULL;
	  tot_sls3_order = tot_sls3_order + sls3_temp->TOT_ZONE_ORDER;
   }

   if (( index < no_of_blue ) && (machine == 4))
   {
	 if (sls4_prev_ptr != NULL)
	 {
	   sls4_temp = (zone_t *) x_malloc (22);
	   if (sls4_temp == 0)
	      printf("sls4_temp = 0, out of memory\n");
	   sls4_prev_ptr->next = sls4_temp;
	 }
	 *sls4_temp = blue_rec[index++];
	  sls4_prev_ptr = sls4_temp;
	  sls4_temp->next = NULL;
	  tot_sls4_order = tot_sls4_order + sls4_temp->TOT_ZONE_ORDER;
   }

   if (( index < no_of_blue ) && (machine == 1))
   {
	 if (sls1_prev_ptr != NULL)
	 {
	   sls1_temp = (zone_t *) x_malloc (23);
	   if (sls1_temp == 0)
	      printf("sls1_temp = 0, out of memory\n");
	   sls1_prev_ptr->next = sls1_temp;
	 }
	 *sls1_temp = blue_rec[index++];
	  sls1_prev_ptr = sls1_temp;
	  sls1_temp->next = NULL;
	  tot_sls1_order = tot_sls1_order + sls1_temp->TOT_ZONE_ORDER;
   }

   if (( index < no_of_blue ) && (machine == 5))
   {
	 if (sls5_prev_ptr != NULL)
	 {
	   sls5_temp = (zone_t *) x_malloc (24);
	   if (sls5_temp == 0)
	      printf("sls5_temp = 0, out of memory\n");
	   sls5_prev_ptr->next = sls5_temp;
	 }
	 *sls5_temp = blue_rec[index++];
	  sls5_prev_ptr = sls5_temp;
	  sls5_temp->next = NULL;
	  tot_sls5_order = tot_sls5_order + sls5_temp->TOT_ZONE_ORDER;
   }
      if (index < no_of_blue) goto BLUE_START;
   }
/*-----------------------------------------------------*/
   void print_color(fp, color)
   FILE *fp;
   int color;
   {
     switch (color)
     {
       case 0:
	printf (" YELLOW");
	fprintf (fp, " YELLOW");
	break;
       case 1:
	printf (" RED   ");
	fprintf (fp, " RED   ");
	break;
       case 2:
	printf (" BLUE  ");
	fprintf (fp, " BLUE  ");
	break;
      }
  }
  /*-----------------------------------------------------*/

   void print_distr(fp, distr)
   FILE *fp;
   int distr;
   {
     switch (distr)
     {
       case 0:
	     printf (" ODD    ");
	     fprintf (fp, " ODD    ");
	     break;
       case 1:
	     printf (" SUBCTRY");
	     fprintf (fp, " SUBCTRY");
	     break;
       case 2:
	     printf (" HOME_SC");
	     fprintf (fp, " HOME_SC");
	     break;
       case 3:
	     printf (" HOME   ");
	     fprintf (fp, " HOME   ");
	     break;
       case 4:
	     printf (" NSSS   ");
	     fprintf (fp, " NSSS   ");
	     break;
      }
  }

  void list_zones()
  {
    zone_t  *temp_ptr;
    int n;
    int day, month, year;

    FILE *fp, *fopen();

    fp = fopen ("TEST.OUT", "a");
    temp_ptr = top_ptr;

 /* display yellow zones */
 /*
 n = 0;
 printf ("\n\n\nno_of_yelw: %d", no_of_yelw);
 do
 {
    printf ("\nzone_dist = %d", yelw_rec[n].zone_dist);
    printf ("   AD_COUNT = %d", yelw_rec[n].AD_COUNT);
    printf ("   zone_no = %d", yelw_rec[n].ZONE_NUM);
    printf (" totzone = %ld", yelw_rec[n].TOT_ZONE_ORDER);
    fprintf (fp, "\nzone_dist = %d", yelw_rec[n].zone_dist);
    fprintf (fp, "   AD_COUNT = %d", yelw_rec[n].AD_COUNT);
    fprintf (fp, "   zone_no = %d", yelw_rec[n].ZONE_NUM);
    fprintf (fp, " totzone = %ld", yelw_rec[n].TOT_ZONE_ORDER);
    print_distr(yelw_rec[n].zone_dist);
    print_color(fp, yelw_rec[n].zone_color);
 } while (++n < no_of_yelw);

 getch();

 /* display red Zones */
 /*
 n = 0;
 printf ("\n\nno_of_red: %d", no_of_red);
 do
 {
    printf ("\nzone_dist = %d", red_rec[n].zone_dist);
    printf ("   AD_COUNT = %d", red_rec[n].AD_COUNT);
    printf ("   zone_no = %d", red_rec[n].ZONE_NUM);
    printf (" totzone = %ld", red_rec[n].TOT_ZONE_ORDER);
    fprintf(fp,"\nzone_dist = %d", red_rec[n].zone_dist);
    fprintf(fp,"   AD_COUNT = %d", red_rec[n].AD_COUNT);
    fprintf(fp,"   zone_no = %d", red_rec[n].ZONE_NUM);
    fprintf(fp," totzone = %ld", red_rec[n].TOT_ZONE_ORDER);
    print_distr(fp, red_rec[n].zone_dist);
    print_color(fp, red_rec[n].zone_color);
 } while (++n < no_of_red);

 getch();

  /* display blue zones */
  /*
 n = 0;
 printf ("\n\nno_of_blue: %d", no_of_blue);
 do
 {
    printf ("\nzone_dist = %d", blue_rec[n].zone_dist);
    printf ("   AD_COUNT = %d", blue_rec[n].AD_COUNT);
    printf ("   zone_no = %d", blue_rec[n].ZONE_NUM);
    printf (" totzone = %ld", blue_rec[n].TOT_ZONE_ORDER);
    fprintf(fp,"\nzone_dist = %d", blue_rec[n].zone_dist);
    fprintf(fp,"   AD_COUNT = %d", blue_rec[n].AD_COUNT);
    fprintf(fp,"   zone_no = %d", blue_rec[n].ZONE_NUM);
    fprintf(fp," totzone = %ld", blue_rec[n].TOT_ZONE_ORDER);
    print_distr(fp, blue_rec[n].zone_dist);
    print_color(fp, blue_rec[n].zone_color);
    /*
    printf ("%ld %ld", blue_rec[n].NW_ORDER, blue_rec[n].SE_ORDER);
    */ /*
 } while (++n < no_of_blue);

 getch();  */

 /* display SLS1 machine assignments */
 tot_sls1_order = 0;
 temp_ptr = sls1_top;
 printf ("\n\n");
 fprintf(fp,"\n\n");
 printf (" \n ENTER EDITION DATE  mm/dd/yy: ");
 fprintf(fp,"\n ENTER EDITION DATE mm/dd/yy: ");
 scanf  ("%d/%d/%d", &month, &day, &year);
 printf ("  GAMEPLAN FOR TUESDAY INSERT/ROP(FOOD) RUNNING");
 fprintf(fp," GAMEPLAN FOR TUESDAY INSERT/ROP(FOOD) RUNNING");
 printf ("\n EDITION DATE : %d/%d/%d ", month, day, year);
 fprintf(fp,"\n EDITION DATE : %d/%d/%d ", month, day, year);
 printf ("\n");
 fprintf(fp,"\n");
 printf ("\n");
 fprintf(fp,"\n");
 fprintf(fp,"\n SLS1:");
 fprintf(fp,"\n");
 do
 {
   if (temp_ptr == 0)
      break;
   printf ("\n        ZONE %2d ", temp_ptr->ZONE_NUM);
   fprintf(fp,"\n        ZONE %2d ",temp_ptr->ZONE_NUM);
   print_color(fp, temp_ptr->zone_color);
   print_distr(fp, temp_ptr->zone_dist);
   printf (" AD_COUNT = %2d  ", temp_ptr->AD_COUNT);
   fprintf(fp," AD_COUNT = %2d  ", temp_ptr->AD_COUNT);
   printf (" tot_zone = %5ld     ", temp_ptr->TOT_ZONE_ORDER);
   fprintf(fp," tot_zone = %5ld     ", temp_ptr->TOT_ZONE_ORDER);

   tot_sls1_order = tot_sls1_order + temp_ptr->TOT_ZONE_ORDER;

 } while ((temp_ptr = temp_ptr->next) != NULL);
 printf ("\n");
 fprintf(fp,"\n");
 printf ("\nTotal order for machine 1 = %ld copies", tot_sls1_order);
 fprintf(fp,"\n              Total order for machine 1 = %ld copies",
						      tot_sls1_order);
 getch();

 /* display SLS2 machine assignments */

 tot_sls2_order = 0;
 temp_ptr = sls2_top;
 printf ("\n\n");
 fprintf(fp,"\n\n");
 fprintf(fp,"\n SLS2:");
 printf ("\n");
 fprintf(fp,"\n");
 do
 {
   if (temp_ptr == 0)
      break;
   printf ("\n        ZONE %2d ", temp_ptr->ZONE_NUM);
   fprintf(fp,"\n        ZONE %2d ",temp_ptr->ZONE_NUM);
   print_color(fp, temp_ptr->zone_color);
   print_distr(fp, temp_ptr->zone_dist);
   printf (" AD_COUNT = %2d  ", temp_ptr->AD_COUNT);
   fprintf(fp," AD_COUNT = %2d  ", temp_ptr->AD_COUNT);
   printf (" tot_zone = %5ld     ", temp_ptr->TOT_ZONE_ORDER);
   fprintf(fp," tot_zone = %5ld     ", temp_ptr->TOT_ZONE_ORDER);

   tot_sls2_order = tot_sls2_order + temp_ptr->TOT_ZONE_ORDER;

 } while ((temp_ptr = temp_ptr->next) != NULL);
 fprintf(fp,"\n");
 printf ("\n");
 printf ("\nTotal order for machine 2 = %ld", tot_sls2_order);
 fprintf(fp,"\n              Total order for machine 2 = %ld copies",
						      tot_sls2_order);
 getch();

 /* display SLS3 machine assignments */

 tot_sls3_order = 0;
 temp_ptr = sls3_top;
 printf ("\n\n");
 fprintf(fp,"\n\n");
 printf ("\nSLS3: ");
 fprintf(fp,"\n SLS3: ");
 printf ("\n");
 fprintf(fp,"\n");
 do
 {
   if (temp_ptr == 0)
      break;
   printf ("\n        ZONE %2d ", temp_ptr->ZONE_NUM);
   fprintf(fp,"\n        ZONE %2d ",temp_ptr->ZONE_NUM);
   print_color(fp, temp_ptr->zone_color);
   print_distr(fp, temp_ptr->zone_dist);
   printf (" AD_COUNT = %2d  ", temp_ptr->AD_COUNT);
   fprintf(fp," AD_COUNT = %2d  ", temp_ptr->AD_COUNT);
   printf (" tot_zone = %5ld     ", temp_ptr->TOT_ZONE_ORDER);
   fprintf(fp," tot_zone = %5ld     ", temp_ptr->TOT_ZONE_ORDER);

   tot_sls3_order = tot_sls3_order + temp_ptr->TOT_ZONE_ORDER;

 } while ((temp_ptr = temp_ptr->next) != NULL);
 printf ("\n");
 fprintf(fp,"\n");
 printf ("\nTotal order for machine 3 = %ld", tot_sls3_order);
 fprintf(fp,"\n              Total order for machine 3 = %ld copies",
						      tot_sls3_order);
 getch();

 /* display SLS4 machine assignments */

 tot_sls4_order = 0;
 temp_ptr = sls4_top;
 printf ("\n\n");
 fprintf(fp,"\n\n");
 printf ("\nSLS4: ");
 fprintf(fp,"\n SLS4: ");
 fprintf(fp,"\n");
 do
 {
   if (temp_ptr == 0)
      break;
   printf ("\n        ZONE %2d ", temp_ptr->ZONE_NUM);
   fprintf(fp,"\n        ZONE %2d ",temp_ptr->ZONE_NUM);
   print_color(fp, temp_ptr->zone_color);
   print_distr(fp, temp_ptr->zone_dist);
   printf (" AD_COUNT = %2d  ", temp_ptr->AD_COUNT);
   fprintf(fp," AD_COUNT = %2d  ", temp_ptr->AD_COUNT);
   printf (" tot_zone = %5ld     ", temp_ptr->TOT_ZONE_ORDER);
   fprintf(fp," tot_zone = %5ld     ", temp_ptr->TOT_ZONE_ORDER);

   tot_sls4_order = tot_sls4_order + temp_ptr->TOT_ZONE_ORDER;

 } while ((temp_ptr = temp_ptr->next) != NULL);
  fprintf(fp,"\n");
  printf ("\nTotal order for machine 4 = %ld", tot_sls4_order);
  fprintf(fp,"\n              Total order for machine 4 = %ld copies",
						      tot_sls4_order);
 getch();

 /* display SLS5 machine assignments */

 tot_sls5_order = 0;
 temp_ptr = sls5_top;
 printf ("\n\n");
 fprintf(fp,"\n\n");
 printf ("\nSLS5: ");
 fprintf(fp,"\n SLS5: ");
 fprintf(fp,"\n");
 do
 {
   if (temp_ptr == 0)
      break;
   printf ("\n        ZONE %2d ", temp_ptr->ZONE_NUM);
   fprintf(fp,"\n        ZONE %2d ",temp_ptr->ZONE_NUM);
   print_color(fp, temp_ptr->zone_color);
   print_distr(fp, temp_ptr->zone_dist);
   printf (" AD_COUNT = %2d  ", temp_ptr->AD_COUNT);
   fprintf(fp," AD_COUNT = %2d  ", temp_ptr->AD_COUNT);
   printf (" tot_zone = %5ld     ", temp_ptr->TOT_ZONE_ORDER);
   fprintf(fp," tot_zone = %5ld     ", temp_ptr->TOT_ZONE_ORDER);

   tot_sls5_order = tot_sls5_order + temp_ptr->TOT_ZONE_ORDER;

 } while ((temp_ptr = temp_ptr->next) != NULL);
 fprintf(fp,"\n");
 printf ("\nTotal order for machine 5 = %ld", tot_sls5_order);
 fprintf(fp,"\n              Total order for machine 5 = %ld copies",
						      tot_sls5_order);
 printf ("\n");
 fprintf(fp,"\n");
 fclose (fp);
 }


/*------------------------------------------------------------------------*/
/*                         MAIN PROGRAM START                             */
/*------------------------------------------------------------------------*/

  /* SORT ZONE COLOR */

  main()
  {
   read_data();
   sort_rec();
   color_sort();
   special_sort (&blue_rec[0], no_of_blue);
   machine_assign();
   list_zones();

  }
