//========================================================================
//  The following example routines have been provided by the Technical
//  Support staff at Borland International.  They are provided as a
//  courtesy and not as part of a Borland product, and as such, are
//  provided without the assurance of technical support or any specific
//  guarantees.
//========================================================================
//  GetWord - This program is designed to allow implementation of a
//  context sensitive transfer option.  The program accepts column
//  and row information representing the cursor position in a text
//  file, locates the word located at that position in the file,
//  and passes that word with the appropriate parameters to grep.
//
//  The implementation of the locating and tokenizing routines is
//  very simple and does not allow for nested control characters
//  such as the tab character.
//
//  To use the routine successfully from the Borland Integrated
//  Development Environment:
//
//  1.  Turn off Options|Environment|Editor|Use Tab Character
//
//  2.  Set up the following transfer item:
//      $MEM(64) $NOSWAP $SAVE CUR $CAP MSG(grep2msg)
//      $LINE $COL $EDNAME -n+ $PROMPT *.c
//
//  3.	When you invoke the transfer, a dialog box will appear giving
//      the user the opportunity to change the parameters to grep or
//      the mask for the files to be searched.  To bypass this, one
//      might replace $PROMPT *.c with *$EXT($EDNAME) to automatically
//      search only files with the same file extension as that in the
//      current edit window.
//
//  Input parameters:
//      argv[1] 	= row;
//      argv[2] 	= column;
//      argv[3]		= name of file containing word;
//      argv[...]	= options to be passed on;
//      argv[argc] 	= files (or mask) to be searched;
//
//  Output:
//      Since the program executes grep, the output is effectively
//      that of grep.
//
//  Notes:
//      Both options passed from the Integrated Development Environment
//      and the file mask are passed on to grep.
//
//      If the program does not work properly, returning references that
//      do not match the word under the cursor, or strange behavior which
//      is reminiscent of memory corruption, then the source file probably
//      contains a tab character on the line under the cursor.
//========================================================================

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <process.h>
#include <string.h>

// maxLen is the longest line in the source text file
#define maxLen 256
char bfr[maxLen];
char CHILD[] = "grep";  // child process to be executed

void main( int argc, char **argv )
{
	int col, row, i;
	char *ptr, **parms;
	FILE *fp;

	if( argc<4 ) return;  // insufficient parameters

	if( (fp=fopen( argv[3], "r" )) == NULL )
	{
		fprintf( stderr, "Cannot open file %s", argv[argc] );
		return;
	}

	row = atoi( argv[1] );
	col = atoi( argv[2] );

	// position to row
	for( i=0; i<row; i++ )
		fgets( bfr, maxLen, fp );
	fclose( fp );

	if( col > strlen( bfr ) ) return;

	// insert null terminator at end of word
	ptr = bfr + col;
	while( isalnum( *ptr ) )
		ptr++;
	*ptr = '\0';

	// back up ptr to beginning of word
	while( isalnum( *(ptr-1) ) && ptr>bfr )
		ptr--;

	parms = (char **) malloc( argc * sizeof( char* ) );
	if( parms == NULL ) return;

    parms[0] = CHILD;
	for( i=1; i<argc-4; i++ )    // get any parameters passed
        parms[i] = argv[i+3];
	parms[i++] = ptr;            // search word
	parms[i++] = argv[argc-1];   // file mask
	parms[i] = NULL;

    execvp( CHILD, parms );
}
