/*-------------------------------------------------------------------*

 Name		PrintImage

 Description	Prints an image to an Epson compatible printer, ala
		GetImage and PutImage.

 Syntax		printimage(int x1, int y1, int x2, int y2);

 *-------------------------------------------------------------------*/
#include <graphics.h>
#include <stdio.h>
#include <io.h>

#define		ESC		'\x1B'
#define		LPT1		0
#define		LPT2		1
#define		prn_putc(x)	biosprint(0,(x),LPT1)

/*
    Sets Epson printer to bit image mode.
    N is the number of bytes to print.
*/
static void bitImage(int N)
{
    register int	n1, n2;

    n2 = N >> 8;
    n1 = N - (n2 << 8);

    prn_putc(ESC);
	prn_putc('*');
	prn_putc(4); /* K=standard density,  L=double density,
					  Y=dbl speed + dbl density, Z=quad density
					*/
    prn_putc(n1);
    prn_putc(n2);
}

/*
    Get pixels from the screen and convert them to
    the printer's pin order.
*/
static unsigned char getScrBits(int x, int y)
{
    unsigned char firePins;

    firePins  = (getpixel(x, y++)==0)? 0: 0x80;
    firePins |= (getpixel(x, y++)==0)? 0: 0x40;
    firePins |= (getpixel(x, y++)==0)? 0: 0x20;
    firePins |= (getpixel(x, y++)==0)? 0: 0x10;
    firePins |= (getpixel(x, y++)==0)? 0: 0x08;
    firePins |= (getpixel(x, y++)==0)? 0: 0x04;
    firePins |= (getpixel(x, y++)==0)? 0: 0x02;
    firePins |= (getpixel(x, y  )==0)? 0: 0x01;

    return	firePins;
}

int printimage(int x1, int y1, int x2, int y2)
{
    int		x, y, width, height;

    width  = x2-x1;
    height = y2-y1;

    for (y=0; y<height; y+=8)
    {
		prn_putc(ESC); prn_putc('1'); /* Initialize line spacing to 7/72" */

		bitImage(width);

		for (x=0; x<width; x++)
			prn_putc(getScrBits(x,y));

		prn_putc('\n');
    }

    return	0;

}

void InitGraf(int *hor, int *ver)
{
	int gmode, i;
	int gdriver = DETECT;
	struct viewporttype vp;

	initgraph(&gdriver, &gmode, "");
	getviewsettings( &vp );
	*hor = (vp.right - vp.left);
	*ver = (vp.bottom - vp.top);
	for (i=0; i<(*hor); i+=10) line(i,0,i,*ver);
	for (i=0; i<(*ver); i+=10) line(0,i,*hor,i);
}

main()
{
  int h, v;

  InitGraf(&h,&v);

  printimage(0,0,h,v);

  closegraph();
  return 0;
}
