/* GRIPPLE.C -- a 4x4 peg game. Requires VGA.
   The file EGAVGA.BGI must be in the same directory
   as the executable file.  */

#include <graphics.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <time.h>

#define PEGCOLOR1 1
#define PEGCOLOR2 2
#define PEGCOLOR3 14
#define PEGCOLOR4 4
#define SELECT_ON_EXEC 5

void grstart(void);
void Startgame(void);
void RandomBoard(void);
void DrawFour(int,int);
void DoRect(int,int);
void Rotate(int,int);
void Shuffle(void);
void WinCheck(void);

int kb,olds=5,s,shuf,c[5][5],count=0;
char cou[4];

void main(void)
{
grstart();
Startgame();
do {kb=getch();
switch (kb)
{	
	case 0: kb=getch();
		switch(kb)
		{case 75: case 72: Rotate(s,1); break;
		 case 77: case 80: Rotate(s,2); break;}
		 break;
	case 49: case 50: case 51: case 52: case 53:
		DoRect(kb-48,15); break;
	case 18: Shuffle(); break;
} WinCheck(); 
} while (kb!=27);
closegraph();   
}


void grstart(void)
{
   int gdriver = DETECT, gmode, errorcode;
   initgraph(&gdriver, &gmode, "");
   errorcode = graphresult();
   if (errorcode != grOk)
   {
      printf("Graphics error: %s\n", grapherrormsg(errorcode));
      printf("Press any key to halt:");
      getch();
      exit(1);  }
}

void Startgame(void)
{
randomize();
setcolor(1);
setfillstyle(1,4);
rectangle(205,95,445,335);
rectangle(324,95,326,335);
rectangle(205,214,445,216);    
rectangle(270,160,380,270);
setcolor(8);
rectangle(25,15,615,50);
rectangle(1,1,639,450);
rectangle(139,355,501,435);
setcolor(15);
outtextxy(255,148,"1");
outtextxy(255,280,"3");
outtextxy(387,148,"2");
outtextxy(387,280,"4");
outtextxy(322,212,"5");
settextstyle(0,0,2);
outtextxy(270,20,"Gripple");
settextstyle(0,0,1);
outtextxy(32,40,"Based on the game by M-Squared Incorporated.  Program by Doug Beeferman.");
outtextxy(280,360,"Key Commands:");
outtextxy(160,380,"1,2,3,4,5:  Select a region to rotate");
outtextxy(152,390,"Left Arrow:  Rotate region counterclockwise");
outtextxy(144,400,"Right Arrow:  Rotate region clockwise");
outtextxy(184,410,"CTRL-R:  Reshuffle the pieces");
outtextxy(208,420,"ESC:  Quit the program");
s=SELECT_ON_EXEC;
Shuffle();
DoRect(s,15);
}

void DrawFour(int x,int y)
{int i,j;
for (i=y; i<y+2; i++)   
for (j=x; j<x+2; j++)
	{setfillstyle(1,c[j][i]);
	fillellipse(175+60*j,65+i*60,20,20);}
setfillstyle(1,0);
bar(600,5,635,13);
setcolor(15);
itoa(count,cou,10);
outtextxy(600,6,cou);
}

void DoRect(int x,int color)
{
setcolor(color);
if (color==15) {
olds=s; s=x; 
if (olds!=s) {DoRect(olds,1);
		setcolor(15); outtextxy(322,212,"5");}
}
switch (x) {
	case 1: rectangle(205,95,324,214); break;
	case 2: rectangle(326,95,445,214); break;
	case 3: rectangle(205,216,324,335); break;
	case 4: rectangle(326,216,445,335); break;
	case 5: rectangle(270,160,380,270); break;
	   }
}

void Rotate(int x,int dir)
{int a,b,i,j,temp;
count++;
switch(x) {
	case 1: case 2: a=-1+2*x; b=1; break;
	case 3: case 4: a=-5+2*x; b=3; break;
	case 5: a=2; b=2; break;}
temp=c[a][b];
if (dir==1) {c[a][b]=c[a+1][b]; c[a+1][b]=c[a+1][b+1];
	c[a+1][b+1]=c[a][b+1]; c[a][b+1]=temp;}
else {c[a][b]=c[a][b+1]; c[a][b+1]=c[a+1][b+1];
	c[a+1][b+1]=c[a+1][b]; c[a+1][b]=temp;} 
if (!shuf) DrawFour(a,b); 
}

void Shuffle(void)
{int i,j,r;
shuf=1;
for (i=1; i<3; i++)   
for (j=1; j<3; j++)
{c[j][i]=PEGCOLOR1; c[j+2][i]=PEGCOLOR2; 
c[j][i+2]=PEGCOLOR3; c[j+2][i+2]=PEGCOLOR4;}
for (i=1; i<201; i++)
	{r=random(7)+1; if (r>5) r=5; Rotate(r,1);}
shuf=0; count=0;
DrawFour(1,1); DrawFour(3,1); DrawFour(1,3); DrawFour(3,3);

}

void WinCheck(void)
{int i,j,win=1;
if (c[1][1]==c[2][2])
	{ for (i=1; i<4; i+=2) for (j=1; j<4; j+=2)
	 if (((c[j][i]!=c[j][i+1])||(c[j][i+1]!=c[j+1][i+1]))||
	    (c[j+1][i+1]!=c[j+1][i])) win=0;  }
else win=0;
if (win==1) {for (i=1; i<6; i++) {
	setcolor(15); rectangle(1,1,639,450); delay(250);
	setcolor(8);  rectangle(1,1,639,450); delay(250); }
        setcolor(15);
	setfillstyle(1,0); bar(32,20,605,49);
	settextstyle(0,0,2); outtextxy(193,20,"Congratulations!");
	settextstyle(0,0,1); outtextxy(233,40,"Press a key to continue.");
	i=getch(); setfillstyle(1,0); bar(32,20,605,50);
	Startgame();
	}


}