#include <stdio.h>
#include <conio.h>
#include <dos.h>

#define IGNORE	0
#define RETRY	1
#define ABORT	2

int buf[500];

static char *err_msg[] = {	"write protect",
							"unknown unit",
							"drive not ready",
							"unknown command",
							"data error (CRC)",
							"bad request",
							"seek error",
							"unknown media type",
							"sector not found",
							"printer out of paper",
							"write fault",
							"read fault",
							"general failure",
							"reserved",
							"reserved",
							"invalid disk change"
						 };


error_win(char *msg)
{
	int retval;
	struct text_info ti;

	gettextinfo(&ti);
	window(10,10,45,11);
	gettext(10,10,45,11,buf);
	textattr(WHITE + (BLUE << 4));
	clrscr();
	cputs(msg);


	while(1)
	{
		retval= getch();
		if (retval == 'a' || retval == 'A')
		{
			retval = ABORT;
			break;
		}
		if (retval == 'r' || retval == 'R')
		{
			retval = RETRY;
			break;
		}
		if (retval == 'i' || retval == 'I')
		{
			retval = IGNORE;
			break;
		}
	}
	puttext(10,10,45,11,buf);
	textattr(ti.attribute);
	window(ti.winleft, ti.wintop, ti.winright, ti.winbottom);
	gotoxy(ti.curx, ti.cury);
	return(retval);
}


int handler(int errval, int ax, int bp, int si)
{
	static char msg[80];
	unsigned di;
	int drive;
	int errorno;

	di= _DI;
	if (ax < 0)
	{
		error_win("Device error");
		hardretn(ABORT);
	}
	drive = ax & 0x00FF;
	errorno = di & 0x00FF;
	sprintf(msg, "Error: %s on drive %c\r\nA)bort, R)etry, I)gnore: ", err_msg[errorno], 'A' + drive);
	hardresume(error_win(msg));
	printf("Outta here\n");
	return ABORT;
}


main()
{
	harderr(handler);
	clrscr();
	printf("Make sure there is no disk in drive A:\n");
	printf("Press any key ....\n");
	getch();
	fprintf(stdprn,"Attempting to access drive A:\n");
	printf("fopen returned %p\n", fopen("A:temp.dat", "w"));
	return 0;
}
