/************************************************************************
    HEAPSIZE.C

    Purpose:
        This function will determine how much memory is available on
    the far heap.

    Usage:
        To use this function you must put the statement:
             extern long heapsize(void);
    within the scope of the calling function.

    Method:
        The memory available on the far heap is computed by determining
    the sum of the freed blocks of memory and adding that amount to the
    value returned by coreleft().

    Input:
        None.

    Written by:
        Jerry Shockley      03/02/91

*************************************************************************/
#include <alloc.h>
#include <stdio.h>


unsigned long heapsize(void)
{
   unsigned long i = 0;          /* Return variable                     */
   struct farheapinfo hi;        /* Value returned from farheapwalk     */
   hi.ptr = NULL;                /* Set the beginning of farheapwalk    */

   if( farheapcheck() <= 0 )     /* Check for corrupted heap            */
      return (-1L);

     while( farheapwalk(&hi) == _HEAPOK )   /* Walk the heap and sum size
                                               of free blocks           */
        if( hi.in_use == 0 )
           i += hi.size;


   i += farcoreleft();           /* Check for amount of free memory from
                                    the highest allocated block to the
                                    end of DOS                          */
   return i;
}

