/*
This program is issued in the PUBLIC DOMAIN, not written by Borland
International.  As such Borland will be unable to provide any
support for the use of these routines.
*/

#include <conio.h>
#include <process.h>
#include <graphics.h>
#include <mem.h>
#include <alloc.h>

#define ESC     27
#define UP      72
#define DOWN    80

void show_menu(void);
int select_entry(void);

char *menu[] = { "Select one",
				 "Selection two",
				 "Selection three",
				 "Fourth Spot" };

#define ENTRIES (sizeof(menu)/sizeof(menu[0]))

int width, height;

main()
{
	int gr_driver = DETECT, gr_mode, errorcode;

/* Initialize the graphics */
	initgraph(&gr_driver, &gr_mode, "c:\\tc\\bgi\\");
	errorcode = graphresult();
	if (errorcode)
	{
		cprintf("graphresult: %s\n",grapherrormsg(errorcode));
		exit(3);
	}

/* show menu and get a selection */
	select_entry();

/* shut down the graphics */
	closegraph();
	return 0;
}

void show_menu(void)
{
   int i;
   for (i=0;i<ENTRIES;i++)
	  outtextxy(10, 10 + ((height+2)*i), menu[i]);
   rectangle( 3, 5, width+7, (ENTRIES*(height+2)) + 7);
}

int select_entry(void)
{
	char *buffer;
	unsigned buffer_size;
	int new, current;
	char ch;

	/* set up width and height */
	width = textwidth(menu[2]) + 10;
	height = textheight("W") + 4;

	/* display the menu */
	show_menu();

	/* setup the highlight bar image */
	buffer_size = imagesize(0,0,width,height); /* get size of buffer */
	buffer = malloc(buffer_size);     /* allocate space for buffer */
	memset(buffer, 0xFF, buffer_size);/* set buffer contents all bits on */
	*(int *)buffer = width-1;         /* stuff width into buffer */
	*((int *)buffer+1) = height-1;    /* stuff height into buffer */

	/* highlight entry in menu */
	current = new = 0;
	/* highlight first entry */
	putimage(5,8+(current*(height+2)),buffer,XOR_PUT);

	/* get keypresses to check up and down */
	while ((ch = getch()) != ESC)
	{
	   if (ch == 0)
		  switch(getch())
		  {
		  case UP  : if (current > 0) new = current-1;
					 break;
		  case DOWN: if (current < (ENTRIES-1)) new = current+1;
					 break;
		  }
	   /* if new selection made, revert old spot, highlight new */
	   if (new != current)
	   {
		  putimage(5,8+(current*(height+2)),buffer,XOR_PUT);
		  current = new;
		  putimage(5,8+(current*(height+2)),buffer,XOR_PUT);
	   }
	}
	/* return the selection */
	return current;
}