/***************** Program Source Module ***********************/
#ifdef AUTOPDOC

MODULE:     hmdemo1.c

DESCRIPTION:

Demo program to demonstrate the HIM (tm) Window, Help, and Keyboard Manager
routines.

TABLE OF CONTENTS:

#endif
/********** Filled by Polytron Version Control System **********

$Author:   james borders  $

$Date:   01 Dec 1988 12:13:48  $

$Revision:   1.1  $

$Log:   D:/C/FMLIB/HM/VCS/HMDEMO1.C  $
 * 
 *    Rev 1.1   01 Dec 1988 12:13:48   james borders
 * support for Turbo C
 * 
 *    Rev 1.0   07 May 1988 16:34:54   james borders
 * Initial revision.

****************************************************************/
/*
 *
 *   Copyright 1988  Allsoft (tm)
 *   100 Calle Playa Del Sol NE
 *   Albuquerque, NM  87109
 *
 *   ALL RIGHTS RESERVED.
 *
 *   Unauthorized distribution, adaptation or use may be 
 *   subject to civil and criminal penalties.
 *
 */

#include  "stdio.h"              /* standard include file */
#ifdef MSC
#include  "malloc.h"             /* used in lminit and wninit call */
#endif
#ifdef TURBOC
#include  "alloc.h"
#endif
#include  "lm.h"                 /* list manager include file */
#include  "wn.h"                 /* window manager include file */
#include  "km.h"                 /* keyboard manager include file */
#include  "hm.h"                 /* help manager include file */

main()
{
int  kbhit(),getch();            /* used in kminit call */
int  wide(), narrow(), multi(), quit();

lminit((char *(*)())malloc,free,0);           /* init the list manager */
kminit(kbhit,getch);             /* init the keyboard manager */
wninit(0,0,NULL,0,(char *(*)())malloc,free);  /* init the window manager */
hminit("HELPFILE.HLP",0,
       0,0,WNBLUE,WNCYAN);       /* init the help manager */

kmsir(KF1,wide);                 /* register our function key routines */
kmsir(KF2,narrow);
kmsir(KF3,multi);
kmsir(KF10,quit);

explain();                       /* tell user how program works */
for (;;)
    kmgetch();                   /* get keys */

}

explain()
/********/
{
int wnum;

wnum = wncreate(2,0,80,22,WNBLACK,WNCYAN,WNBLACK,WNBLUE);
wnttitle(wnum,"[ Helpdemo V1.00  4/4/88 ]");
wnprintf(wnum,"\nA program to demonstrate capabilities of the Window, Keyboard, and ");
wnprintf(wnum,"\nHelp Manager routines contained in the Human Interface Manager (HIM)");
wnprintf(wnum,"\nlibrary.");
wnprintf(wnum,"\n\nThe text in this window is displayed via the Window Manager routine");
wnprintf(wnum,"\nwnprintf().");
wnprintf(wnum,"\n\nThe help text presented by this routine (via F1-F3) is contained");
wnprintf(wnum,"\nin the file HELPFILE.HLP which was built by HFBILDER.EXE from ");
wnprintf(wnum,"\nthe text file HELPFILE.TXT.");
wnprintf(wnum,"\n\nThe 3 routines wide(), narrow(), and multi() have been attached");
wnprintf(wnum,"\nto the f1-f3 keys via the Keyboard Manager.  When these keys");
wnprintf(wnum,"\nare pressed the appropriate routine is called by the Keyboard");
wnprintf(wnum,"\nManager, no switch statement is neccessary.");
wnprintf(wnum,"\n\nF1   to demonstrate wide help text..");
wnprintf(wnum,"\nF2   to demonstrate narrow help text..");
wnprintf(wnum,"\nF3   to demonstrate multi-page help text..");
wnprintf(wnum,"\nF10  to quit program");
}

wide()
/*****/
{
hmscontext("wide_help");          /* tells what help to give */
hmhelp();                         /* gives the help */
}

narrow()
/*****/
{
hmscontext("narrow_help");        /* tells what help to give */
hmhelp();                         /* gives the help */
}

multi()
/*****/
{
hmscontext("multipage_help");     /* tells what help to give */
hmhelp();                         /* gives the help */
}

quit()
/*****/
{
wndestroy(-1);                    /* take down all windows */
exit(0);                          /* quit program */
}

