/***************** Program Source Module ***********************/
#ifdef AUTOPDOC

MODULE:     kmdemo1.c

DESCRIPTION:

This program will demonstrate how a mouse can be used to simulate arrow
keycodes with the Keyboard Manager package.  It will be registered as
a User Input Routine (UIR) and whenever movement of the mouse is noted the
correct arrow keycode will be sent to the Keyboard Manager.  Added
capabilities such as button command support is not present in this
example but could easily be added.

This program will create a window and place the cursor in the center.  As
the user enters arrow keycodes the cursor will be moved.  Hit the ESCAPE
key or press any mouse button to exit the program.

This program must be linked with the mouse driver library in addition to
the Forms Processing Lib.

NOTE:  The mouse driver must be loaded.

#endif
/*
 *
 *   Copyright 1988  Allsoft (tm)
 *   100 Calle Playa Del Sol NE
 *   Albuquerque, NM  87109
 *
 *   ALL RIGHTS RESERVED.
 *
 *   Unauthorized distribution, adaptation or use may be 
 *   subject to civil and criminal penalties.
 *
 */
/********** Filled by Polytron Version Control System **********

$Author:   james borders  $

$Date:   01 Dec 1988 12:15:48  $

$Revision:   1.0  $

$Log:   D:/C/FMLIB/KM/VCS/KMDEMO1.C  $
 * 
 *    Rev 1.0   01 Dec 1988 12:15:48   james borders
 * Initial revision.

****************************************************************/

/*** Include Files ***/

#include  "stdio.h"
#ifdef MSC
#include  "malloc.h"
#endif
#ifdef TURBOC
#include  "alloc.h"
#endif
#include  "lm.h"
#include  "km.h"
#include  "wn.h"

/*** Typedefs ***/

/*** Constants ***/

/*** Global Vars ***/

/*** Macros ***/

/*
    case is important for MOUSECML/MOUSECMS, the turbo shell tcc passes
    a /c (case sensitive switch) to tlink.
*/
#define   MOUSE MOUSECML(&m1,&m2,&m3,&m4) /* MOUSECMS=small, MOUSECML=large */

int  m1,m2,m3,m4;

main()
/***********/
{
int  kbhit(),getch();           /* for kminit call */
int  crow,ccol,lrow,lcol;       /* current and last cursor row,col */
int  keycode;
int  wnum;                      /* window number */
int  uir;                       /* uir number from kmsuir() */
int  mouseuir();                /* our mouse User Input Routine */

lminit((char *(*)())malloc,free,0);          /* init list manager */
kminit(kbhit,getch);            /* init keyboard manager */
wninit(0,0,NULL,0,(char *(*)())malloc,free); /* init window manager */

wnum = wncreate(0,0,80,25,WNBLUE,WNCYAN,WNBLUE,WNCYAN); /* create window */
wnttitle(wnum,"[ KMDEMO1 V1.0 Mouse Tester ]");         /* put up top title */
wnbtitle(wnum,"[ ESC or mouse button to exit ]");       /* bottom title */

m1 = 0;
MOUSE;         /* see if driver is installed (m1==0) */
if (m1 != -1){
    wndestroy(wnum);            /* take down window */
    printf("\nSorry.  Mouse driver not found.");
    exit(1);
    }
else{
    uir = kmsuir(mouseuir);     /* register User Input Routine */
    kmmsabort(KESC);            /* tell keyboard package what an abort is */
    crow = 10;
    lrow = -1;
    ccol = 40;
    lcol = -1;
    for (;;){
        if ((lrow != crow) || (lcol != ccol)){ /* don't move unless changed */
            wnlocate(wnum,crow,ccol);   /* position cursor */
            lrow = crow;
            lcol = ccol;        /* update last coords */
            }
        keycode = kmgetch();    /* get a key from keyboard manager */
        switch (keycode){
            case    KUP:        /* up arrow key */
                crow = (crow == 1)?crow:--crow;
                break;
            case    KDOWN:      /* down arrow key */
                crow = (crow == 23)?crow:++crow;
                break;
            case    KRIGHT:     /* right arrow key */
                ccol = (ccol == 78)?ccol:++ccol;
                break;
            case    KLEFT:      /* left arrow key */
                ccol = (ccol == 1)?ccol:--ccol;
                break;
            case    KESC:       /* escape keycode */
                wndestroy(wnum);/* take down window */
                kmduir(uir);    /* remove from list just to be clean */
                exit(0);
                break;
            }
        }
    }
} /* end of main */


/************** User Input Routine section **************/


/* these global static vars are for the mouse input routines */

#define KQ 20
int  current_abort_code = KESC;
int  waiting_keycode[KQ];
int  nwaiting,in,out;


mouseuir(func,data)
/******************/
/* This is the actual user input routine which was registered via kmsuir()
   above.
*/
int func,data;
{
int tkey;

switch(func){   /* a UIR must be capable of performing 4 functions: */
    case    fuirsabort: /* set abort keycode */
        current_abort_code = data;
        break;

    case    fuirqabort:             /* is abort code pending */
        m1 = 3;                     /* get mouse position and button status */
        MOUSE;     /* call the mouse driver */
        if (m2 & 7){
            push_keycode(current_abort_code);
            return(1);              /* button down, return abort true */
            }
        else
            return(0);              /* no button down */

    case    fuirchavail:            /* keycode ready yet? */
        return(mouseuirchavail());

    case    fuirgetch:              /* don't return until char ready */
        while (!mouseuirchavail())
            ;                       /* wait for keycode */
        return(pop_keycode());
    }
} /* end of mouseuir */

mouseuirchavail()
/****************/
{
if (any_keycodes())
    return(1);
else{
    if (mouseuirbuttondown()){
        push_keycode(current_abort_code);
        return(1);                  /* yes, keycode is ready */
        }
    m1 = 11;                        /* get relative mouse movement */
    MOUSE;         /* call driver */
    if (m3 > 0)                     /* did mouse move to the right? */
        push_keycode(KRIGHT);
    else if (m3 < 0)                /* did mouse move to the left? */
        push_keycode(KLEFT);
    if (m4 > 0)                     /* did mouse move down? */
        push_keycode(KDOWN);
    else if (m4 < 0)                /* did mouse move up? */
        push_keycode(KUP);

    return(any_keycodes());         /* return updated status */
    }
} /* end of mouseuirchavail */

mouseuirbuttondown()
/*******************/
{
m1 = 3;                             /* get mouse position and button status */
MOUSE;             /* call driver */
if (m2 & 7)
    return(1);                      /* yes, button is down */
else
    return(0);
}

clear_keycodes()
/****************/
{
nwaiting = 0;
in = out = 0;
}

any_keycodes()
/*************/
{
return(nwaiting);
}

push_keycode(keycode)
/********************/
int keycode;
{
if (nwaiting < KQ){
    waiting_keycode[in++] = keycode;
    in = (in == KQ)?0:in;
    nwaiting++;
    }
}

pop_keycode()
/*************/
{
int i;

i = waiting_keycode[out++];
out = (out == KQ)?0:out;
nwaiting--;
return(i);
}


        
