/* hodge.c:  The Hodgepodge machine, as described in SA August 1988 */
/* Originally coded by Raymond Chen (rjchen@phoenix) 24 August 1988 */
/* Changed to compile with Microsoft C by Kevet Duncombe 8 October 1988 */

#define MICROSOFT	/* Just remove this line to go back to Turbo C */

/* This is for Turbo C version 1.5; if that's not what you have, 
	read the caveats above. */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>  /* remove if not using Turbo C 1.5 */

#ifdef MICROSOFT
#include <graph.h>
#define gotoxy(x,y) (void)_settextposition(y,x)
#define clrscr()	_clearscreen(_GCLEARSCREEN)
#define NHSIZE (sizeof(d)/sizeof(int))  /* size of our neighborhood */
#else
#define NHSIZE (sizeof d /sizeof int)	/* size of our neighborhood */
#endif

#ifdef DEBUG

#define assert(condition, code) \
if (!(condition)) { \
		printf("Assertion failed (" #condition ") " \
"%s (%d)\n", __FILE__, __LINE__); \
			printf code; \
		exit(1); \
 }
#else /* not debugging */
#define assert(condition, code)
#endif /* DEBUG */

#define HEIGHT 20	/* vertical size of world */
#define WIDTH 20	/* horizontal size of world */

/* given an offset (x,y), return the integer offset which gives you
	that element.  Did that make any sense? */
#define delta(x,y) ( (y) * (WIDTH + 2) + (x))

/* The members of our neighborhood */
int d[] = {delta(-1,0), delta(0,-1), delta(1,0), delta(0,1), delta(0,0)};

/* Zero-sensitive divide */
#define divide(num, den) ( (den) ? (num) / (den) : 0)

/* Our world is conceptually a two-dimensional world, but it is stored
	as a linear array.  The element which you would usually call
	w1[y][x] is stored in locate w1[delta(x,y)].

   There is an "extra" row and column of cells which act as a "border".
	These cells are always healthy.  They serve to make the
	algorithm much easier to implement (since you don't have
	to do boundary checking all the time).

   This program uses the standard trick of one copy of the world
	to calculate what the world should look like in the next generation.
	The roles of the "from" and "to" worlds are reversed, and the
	game continues.
*/

typedef unsigned char cell;

cell w1[(HEIGHT + 2) * (WIDTH + 2)];
cell w2[(HEIGHT + 2) * (WIDTH + 2)];

int infected;	/* number of infected cells */

unsigned int k1 = 2;		/* The parameters.  This should probably be */
unsigned int k2 = 3;		/* command-line arguments. */
unsigned int g = 3;
unsigned int n = 100;

/* generate:  Calculate what the world "from" will look like next year.
	Put the results in the world "to". */
void
generate(cell *from, cell *to)
{
	unsigned int A, B, S;	/* the parameters used in the algorithm */
	char *p, *q;			/* pointers used to step through the world */
	int i, s;
	int x, y;		/* this keeps track of our current position */
	
/* My compiler isn't too smart, so I had to hand-optimize this double
	loop via strength reduction. */
	
	p = from + delta(1,1);
	q = to + delta(1,1);
	
	for (y = 1; y <= HEIGHT; y++, p += 2, q += 2) {
		for (x = 1; x <= WIDTH; x++, p++, q++) {
		
			/* Here are the loop invariants: */
			assert(p == from + delta(x,y),
					("x = %d; y = %d; delta(x,y) = %d; offset = %d\n",
					x, y, delta(x,y), p - from));
			assert(q == to + delta(x,y),
					("x = %d; y = %d; delta(x,y) = %d; offset = %d\n",
					x, y, delta(x,y), q - to));
			/* end of loop invariants */
		
			if (*p == n) {
				*q = 0;
				infected--;
			} /* magically recover */
			else {	/* get slightly sicker */
				S = A = B = 0;
				for (i = 0; i < NHSIZE; i++) {	/* look around */
					s = p[d[i]];
					if (s == n) B++;
					if (s) A++;
					S += s;
				}
				assert(A != 0 || S == 0, 
						("x = %d, y = %d, B = %d, S = %d\n", x, y, B, S));

				/* do the right thing, depending on */
				/* whether our cell is healthy or not */
				if (*p) {
					*q = divide(S, A) + g;
				}
				else {
					*q = (A / k1) + (B / k2);
					if (*q) infected++;
				}
				if (*q > n) *q = n;
			}
		}
	}
}

/* display:  Show the user our world */
void
display(cell *w)
{
	int x, y;
#ifdef DEBUG
	int numinfect = 0;
#endif /* DEBUG */
	
	for (y = 1; y <= HEIGHT; y++)
		for (x = 1; x <= WIDTH; x++) {
		gotoxy(x,y);
		putch(' ' + w[delta(x,y)]);
#ifdef DEBUG
		if (w[delta(x,y)]) numinfect++;
#endif /* DEBUG */
	}
	gotoxy(1,21);
	printf("%3d", infected);
	assert(infected == numinfect, ("%d should be %d\n", infected, numinfect));
}

/* mrand:  Return a random number in the range 0 .. range-1  */
int mrand(unsigned int range)
{
	unsigned long x = rand();
	
	return (x * range) / 32768U;
}

/* main:  Initialize the world randomly, then generate forever */
main()
{
	int x,y;
	
	clrscr();
	
/* Fill the world with random nonsense.  Keep track of how many of them
	are infected. */
	infected = 0;
	memset(w1, 0, sizeof w1);
	for(x = 1; x <= WIDTH; x++) {
		for(y = 1; y <= HEIGHT; y++) {
			if (w1[delta(x,y)] = mrand(n)) infected++;
		}
	}
	
	/* Show the user our initial conditions */
	display(w1);
	
	/* Generate like mad */
	while (!kbhit()) {
		generate(w1,w2);
		display(w2);
		generate(w2,w1);
		display(w1);
	}
}

