/*------------------------------------------------------------------------
 * This program demonstrates sorting of a huge array of 440000 bytes by
 * reading up to maxElem lines of up to maxLen bytes each from a source
 * file, sorting the array of strings, and writing the sorted output to a
 * destination file.
 *
 * It requires the huge memory model; otherewise, the modified qsort()
 * routine which accompanies this program will be working with far
 * pointers and the routine will fail.
 *
 * To invoke the program, enter:
 *      hugesort source.dat dest.dat
 * where source is an ASCII file to be read and dest is the sorted
 * output file.
------------------------------------------------------------------------*/
#if !defined(__HUGE__)
#error This program requires the huge memory model!
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <alloc.h>
#include <conio.h>

//Be careful not to overflow the stack!
extern unsigned _stklen = 1024u * 30;


#define maxElem 3100u
#define maxLen 130
char huge list[maxElem][maxLen];

int SortFunk( const void *a, const void *b);
unsigned ReadFile(char *inFile);
void WriteFile(char *outFile, unsigned nItems);
void ExitErr(char *msg);

//------------------------------------------------------------------------
int main(int argc, char **argv)
{
    size_t nItems;

    if (argc<2)
        ExitErr("Usage:  hugesort [path\]source.dat [path\]dest.dat\n");
    nItems = ReadFile (argv[1]);
    printf("Read %u items from %s\n", nItems, argv[1]);
    puts("sorting...");
    qsort( (void *)list, (size_t)nItems, (size_t)sizeof(list[0]), SortFunk);
    printf("sort complete.  writing %u items data...", nItems);
    WriteFile (argv[2], nItems);

    puts("all done!");

    return 0;
}

//------------------------------------------------------------------------
int SortFunk( const void *a, const void *b)
{
    return( strcmp(a, b) );
}

//------------------------------------------------------------------------
unsigned ReadFile (char *inFile)
{
    unsigned i=0;
    FILE *fp;
    if ((fp = fopen (inFile, "r")) == NULL)
    {
        printf("unable to open input file %s\n", inFile);
        exit(1);
    }
    while ( (i<maxElem) && (fgets(list[i], maxLen, fp) != NULL) )
        i++;
    fclose(fp);
    return i;
}

//------------------------------------------------------------------------
void WriteFile (char *outFile, unsigned nItems)
{
    unsigned i = 0;
    FILE *fp;
    if ((fp = fopen (outFile, "w")) == NULL)
    {
        printf("unable to open output file %s\n", outFile);
        exit(1);
    }
    for (i=0; i<nItems; i++)
        fputs (list[i], fp);
    fclose(fp);
}

//------------------------------------------------------------------------
void ExitErr(char *msg)
{
    puts(msg);
    exit(1);
}

