/* Example of 256 colour animation of images from IMED256 */
/* Requires VGA and Microsoft C V6 */
#include <conio.h>
#include <graph.h>
#include <stdio.h>

/* This is the standard size for a 24x48 image */
#define IMAGSIZE 1156

/* Buffer for 4 images */
char images[4][IMAGSIZE];

void main(void);
void noimage(void);

void main()
{
  int i,j;
  FILE *f;
  if (!_setvideomode(_MRES256COLOR))
    {
    fprintf(stderr,"\nYou need a system which supports 256 colour 320x200 mode");
    exit(1);
    }


  f=fopen("s1col.img","rb");
  if (f==NULL)
    noimage();
  for (i=0;i<IMAGSIZE;i++)
    images[0][i]=(unsigned char)getc(f);
  fclose(f);

  f=fopen("s2col.img","rb");
  if (f==NULL)
    noimage();
  for (i=0;i<IMAGSIZE;i++)
    images[1][i]=(unsigned char)getc(f);
  fclose(f);

  f=fopen("s3col.img","rb");
  if (f==NULL)
    noimage();
  for (i=0;i<IMAGSIZE;i++)
    images[2][i]=(unsigned char)getc(f);
  fclose(f);

  f=fopen("s4col.img","rb");
  if (f==NULL)
    noimage();
  for (i=0;i<IMAGSIZE;i++)
    images[3][i]=(unsigned char)getc(f);
  fclose(f);

  /* Display images until user presses a key */
  while (!kbhit())
    {
    for (i=0;i<4;i++)
      {
      _putimage(0,0,(char far *)images[i],_GPSET);
      for (j=0;j<30000;j++);
      }
    }
  _setvideomode(_DEFAULTMODE);
}

void noimage(void)
{
  _setvideomode(_DEFAULTMODE);
  fprintf(stderr,"You must have\ns1col.img\ns2col.img\ns3col.img\
    \nand s4col.img\nin the current directory");
  exit(1);
}
