

#include <string.h>
#include <stdio.h>

#include "externs.h"

/* function to handle command line parameter checking */
/* prior to searching and deleting of a link list record */
int delete_student(int argc,char *argv[])
{
 if (argc==3)
 {
  long number=atol(argv[2]);     /* check if id number is valid long integer */

  if (number)
   delete(argv[1],number,&start); /* delete a record */
  else
   error(etable[1]);              /* notify user invalid parameters */

 }
 else
  if (argc<3)
   error(etable[9]);  /* too few arguments passed at command line */
  else
   error(etable[8]);  /* too many arguments passed at command line */

 return 0;
}


/* function to look for a link specified by name and id */
/* and delete that link only when both id and name match */
int delete(char *name,long id,struct stu **start)
{
 int done;
 struct stu *index;
 index=*start;

 if (*start)
 {
  done=0;
  while ( !done )
  {
  if (index->next==*start)              /* check if end of list */
    done=1;

   if (!strcmp(index->name,name) && index->id==id)   /* check if found */
    done=2;

  index=index->next;

  }

  if (done==2)
  {
   index=index->prev;               /* reset index counter */

   printf("record deleted\n");       /* notify user */

   if (index==*start)
   {
    if ( (**start).next==*start )   /* check if start link is involved */

     *start=NULL;  /* remove last link in list */
    else

     *start=index->next;  /* remove the start link */
   }


   index->prev->next=index->next;      /* by pass link to remove in list */
   index->next->prev=index->prev;
   free (index);                       /* free space of link removed */
  }
  else
  {
   error(etable[15]);      /* record passed not found */
   return 0;
  }


 }
 else
 {
  error(etable[12]);     /* output student list is empty */
  return 0;
 }

 return 1;
}
