
#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <mem.h>
#include <alloc.h>


#include "externs.h"

/* function to handle command line parameter checking */
/* prior to searching and deleting of a link list record */
int delete_student(int argc,char *argv[])
{
 if (argc==3)
 {
  long number=atol(argv[2]);     /* check if id number is valid long integer */

  if (number)
   delete(argv[1],number,&start); /* delete a record */
  else
   error(etable[1]);              /* notify user invalid parameters */

 }
 else
  if (argc<3)
   error(etable[9]);  /* too few arguments passed at command line */
  else
   error(etable[8]);  /* too many arguments passed at command line */

 return 0;
}


/* function to look for a link specified by name and id */
/* and delete that link only when both id and name match */
int delete(char *name,long id,struct stu **start)
{
 int done;
 struct stu *index;
 index=*start;

 if (*start)
 {
  done=0;
  while ( !done )
  {
  if (index->next==*start)              /* check if end of list */
    done=1;

   if (!strcmp(index->name,name) && index->id==id)   /* check if found */
    done=2;

  index=index->next;

  }

  if (done==2)
  {
   index=index->prev;               /* reset index counter */

   printf("record deleted\n");       /* notify user */

   if (index==*start)
   {
    if ( (**start).next==*start )   /* check if start link is involved */

     *start=NULL;  /* remove last link in list */
    else

     *start=index->next;  /* remove the start link */
   }


   index->prev->next=index->next;      /* by pass link to remove in list */
   index->next->prev=index->prev;
   free (index);                       /* free space of link removed */
  }
  else
  {
   error(etable[15]);      /* record passed not found */
   return 0;
  }


 }
 else
 {
  error(etable[12]);     /* output student list is empty */
  return 0;
 }

 return 1;
}




/* add student model for command line interpeter */

int add_student(int argc,char *argv[])
{

 if (argc!=3)      /* check for right number of arguments */

  if (argc<3)      /* too few arguments */
   error(etable[9]);       /* handle error condition */
  else
   error(etable[8]);

 else
 {
  long identification=atol(argv[2]);

  if(identification<1)    /* check for improper numerical input */
   error(etable[6]);              /* for id number and reprot error */
  else
	    /* add student to link list */
   switch( link_student(argv[1],identification,&start) )
   {
   case(NO_MEM):
    error(etable[10]);
    break;

   case(NOT_UNQ):
    error(etable[11]);
    break;

   case(LINKED):
    printf("<* RECORD LINKED *>\n");
    break;

   default:
    break;

   }


 }

 return 0;
}


int link_student(char *new_name,long new_id,struct stu **start)
{
 struct stu *current=*start;               /* create new record it link */
 struct stu *new;
 int result;

 /* get memory return if with error if not possible */

 if (!(new=(struct stu *)malloc(sizeof(struct stu))) )
  return NO_MEM;

 /* get more memory for name */

  new->name=(struct stu *)malloc(strlen(new_name)+1);
  if (!new->name)
   return NO_MEM;                   /* return if cant */
  else
   strcpy(new->name,new_name);      /* move string into link list element */

 new->id=new_id;      /* assign identification number to link */

 if (!*start)  /* check if empty list */
 {
  *start=new;         /* new record is start of list */

  (**start).next=*start;   /* make first record in list point back */
  (**start).prev=*start;   /* to itself for standard insertion     */
  result=LINKED;
 }
 else
 {
  struct stu *current=*start;

  while( current->next!=*start && new->id > current->id )   /* find position to insert */
   current=current->next;

  if ( new->id < current->id )
  {

   new->next=current;               /* insert new link before current link */
   new->prev=current->prev;
   current->prev->next=new;
   current->prev=new;

   if ( new-> id < (**start).id )   /* check if comes before first record */
    *start=new;
   result=LINKED;
  }
  else

   if (current->id!=new->id)        /* check if id already exsist */
   {

    new->next=*start;               /* add this id and name to link list */
    new->prev=(**start).prev;
    (**start).prev->next=new;
    (**start).prev=new;
    result=LINKED;

   }
   else
    result=NOT_UNQ;        /* id number already exsisted in link list */

 }   /* if else for start assignment */

 return result;
}


/* show all student in link list */
/* allow user to show list forward */
/* or backward with - parameter */
int show_students(int argc,char *argv[])
{

 struct stu *index;

 index=start;

 if (start)            /* show list forward */
 {
  printf("\nStudent Name       \tStudent Id\n");     /* header */

  if ( strcmp("-",argv[1]) )
   do
   {
    printf("%-20s\t%10d \n",index->name,index->id);
    index=index->next;
   } while (index!=start);
  else
  {
   struct stu *end=start->prev;
   index=end;                      /* get end of list to start with */

   do                      /* show list backward */
   {
    printf("%-20s\t%-9d \n",index->name,index->id);
    index=index->prev;
   } while (index!=end) ;

  }

 }
 else
  error(etable[12]);     /* student list is empty */

 return 0;
}

/* find one student searched by id number */
/* or searched by string name             */
int find(int argc,char *argv[])
{
 struct stu *student;

 if (argc==3)                       /* check for right # of  arguments */
  if(!strcmp(argv[1],"student") || !strcmp(argv[1],"id") )
  {

   if( !strcmp(argv[1 ],"student") )  /* check if search by name */
   {
      /* search by student name */
    if(student=search_name(argv[2]))
     printf("\n%s %d\n",student->name,student->id);
    else
     error(etable[13]);      /* output student not found */

   }
   else
   {
    long id;
	    /* search by id number */

    if ( !(id=atol(argv[2])) )
     error(etable[1]);
    else
    if (student=search_id(id))
     printf("\n%s %d\n",student->name,student->id);
    else
     error(etable[14]);


   }

  }
  else
   error(etable[1]);
 else                        /* incorect number of parmaters */
  if (argc<3)
   error(etable[9]);         /* to few arguments */
  else
   error(etable[8]);         /* to many arguments */

 return 0;
}

/* function to search link list for id */
struct stu *search_id(long id)
{
 struct stu *index=start;

 while(index->id!=id && index->next!=start) /* loop until end of list or */
  index=index->next;                        /* id is found               */

 if (index->id==id)
  return index;
 else
  return NULL;             /* return null if id not found */

}



/* function to search link list for specific name */
struct stu *search_name(char *name)
{
 struct stu *index=start;

 while(strcmp(index->name,name) && index->next!=start) /* loop until end of  */
  index=index->next;                                   /* list or name found */

 if ( !strcmp(index->name,name) )
  return index;
 else
  return NULL;            /* return null if name not found */

}


void release_all()
{
 struct stu *end;
 struct stu *current;
 current=start;
 end=start->prev;

 while(current!=end)         /* free mem allocated for link list */
 {
  current=current->next;
  free(current->prev);
 }

}
